/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query;

import com.ibm.cognos.aurora.api.query.provider.dim.IMeasureRecord;
import com.ibm.cognos.aurora.core.util.UniqueNameGenerator;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.MetadataRecordBuilder;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Cube;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Dimension;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Hierarchy;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Level;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Member;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataSession;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.MetadataQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1Utils;
import com.ibm.cognos.tm1.TM1Exception;
import com.ibm.cognos.tm1.TreeOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public class MeasureRecordQuery
extends MetadataQuery<IMeasureRecord> {
    private String mCubeName = null;
    private String mMUN = null;
    private String mLUN = null;
    private Integer mLevelNumber = null;
    private boolean mRootsOnly = false;
    private boolean mIncludeSelf = true;
    private boolean mIncludeChildren = false;

    public MeasureRecordQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setLUN(String lun) {
        this.mLUN = lun;
    }

    public void setLevelNumber(Integer levelNum) {
        this.mLevelNumber = levelNum;
    }

    public void setMUN(String mun) {
        this.mMUN = mun;
    }

    public void setRootsOnly(boolean isRootsOnly) {
        this.mRootsOnly = isRootsOnly;
    }

    public void setIncludeSelf(boolean includeSelf) {
        this.mIncludeSelf = includeSelf;
    }

    public void setIncludeChildren(boolean includeChildren) {
        this.mIncludeChildren = includeChildren;
    }

    @Override
    public List<IMeasureRecord> execute() throws TM1Exception {
        this.checkRangeRestrictions();
        if (null == this.mCubeName) {
            throw new IllegalArgumentException("A cube name was not specified.");
        }
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        TM1Cube cube = this.getLoader().loadCube(this.mCubeName);
        if (null == cube) {
            throw new QLSRuntimeException(TM1MessageKeys.MET_CubeNotFound, (Object)this.mCubeName);
        }
        TM1Dimension measureDim = cube.getMeasureDimension();
        if (null == measureDim) {
            return Collections.emptyList();
        }
        ArrayList<TM1Member> measuresFound = new ArrayList<TM1Member>();
        this.findMeasures(measureDim, measuresFound);
        int effectiveSize = Math.min(this.mRangeSize, measuresFound.size() - this.mRangeFrom);
        if (effectiveSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<IMeasureRecord> records = new ArrayList<IMeasureRecord>(effectiveSize);
        for (int i = this.mRangeFrom; i < this.mRangeFrom + effectiveSize; ++i) {
            records.add((IMeasureRecord)MetadataRecordBuilder.buildMeasure((TM1Member)measuresFound.get(i), this.mSharedFieldIndex));
        }
        return records;
    }

    private void findMeasures(TM1Dimension dimension, List<TM1Member> result) throws TM1Exception {
        TM1Hierarchy hierarchy = dimension.getDefaultHierarchy();
        if (null == hierarchy) {
            throw new QLSRuntimeException(TM1MessageKeys.MET_HierarchyNotFound, (Object)UniqueNameGenerator.createUniqueName((String)dimension.getName(), (String)dimension.getDefaultHierarchyName()));
        }
        if (null != this.mMUN) {
            String providerMUN = TM1Utils.convertMDDSMUNToProviderMUN(this.mMUN);
            EnumSet<TreeOperator> treeOps = EnumSet.noneOf(TreeOperator.class);
            if (this.mIncludeSelf) {
                treeOps.add(TreeOperator.Self);
            }
            if (this.mIncludeChildren) {
                treeOps.add(TreeOperator.Children);
            }
            this.getLoader().loadMembersTreeOp(hierarchy, providerMUN, treeOps, result);
        } else if (this.mRootsOnly) {
            result.addAll(hierarchy.getAccessibleRoots());
        } else if (null != this.mLevelNumber) {
            TM1Level level = hierarchy.findLevel(this.mLevelNumber);
            if (null == level) {
                throw new QLSRuntimeException(TM1MessageKeys.MET_LevelNumberNotFound, (Object)this.mLevelNumber, (Object)hierarchy.getUniqueName());
            }
            this.getLoader().loadLevelMembers(level, result);
        } else if (null != this.mLUN) {
            String providerLUN = TM1Utils.convertMDDSLUNToProviderLUN(this.mLUN);
            TM1Level level = hierarchy.findLevel(providerLUN);
            if (null == level) {
                throw new QLSRuntimeException(TM1MessageKeys.MET_LevelNotFound, (Object)this.mLUN);
            }
            this.getLoader().loadLevelMembers(level, result);
        } else {
            this.getLoader().loadMembersTreeOp(hierarchy, null, null, result);
        }
    }

    @Override
    public void release() {
    }
}

