/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core;

import com.ibm.aurora.rare.IClassificationEntry;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassificationEntry
implements IClassificationEntry {
    private final String mType;
    private final String mClassificationId;
    private final String mVariationKey;
    private final Float mScore;
    private final Map<String, Set<String>> mAttributes;
    private final String mName;
    private final List<String> mScoreDescriptions;
    private final Map<String, List<InputScopeObject>> mBoundScopes;

    public ClassificationEntry(String classificationId, String type, String variationKey, Float score, Map<String, Set<String>> attributes, List<String> scoreDescriptions, Map<String, List<InputScopeObject>> boundScopes) {
        this.mClassificationId = classificationId;
        this.mVariationKey = variationKey;
        this.mScore = score;
        this.mType = type;
        this.mAttributes = attributes;
        this.mName = attributes.get("name").iterator().next();
        this.mScoreDescriptions = scoreDescriptions;
        this.mBoundScopes = boundScopes;
    }

    public ClassificationEntry(String classificationId, String name, String type, String variationKey) {
        this.mClassificationId = classificationId;
        this.mVariationKey = variationKey;
        this.mScore = Float.valueOf(0.0f);
        this.mType = type;
        this.mAttributes = null;
        this.mName = name;
        this.mScoreDescriptions = null;
        this.mBoundScopes = null;
    }

    @Override
    public String getClassificationId() {
        return this.mClassificationId;
    }

    @Override
    public String getVariationKey() {
        return this.mVariationKey;
    }

    @Override
    public Float getScore() {
        return this.mScore;
    }

    @Override
    public String getType() {
        return this.mType;
    }

    @Override
    public Map<String, Set<String>> getAttributes() {
        return this.mAttributes;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public List<String> getScoreDescriptions() {
        return this.mScoreDescriptions;
    }

    @Override
    public List<InputScopeObject> getBoundScopes() {
        ArrayList<InputScopeObject> boundScopeList = new ArrayList<InputScopeObject>();
        for (Map.Entry<String, List<InputScopeObject>> entry : this.mBoundScopes.entrySet()) {
            boundScopeList.addAll((Collection<InputScopeObject>)entry.getValue());
        }
        return boundScopeList;
    }

    @Override
    public Map<String, List<InputScopeObject>> getBindings() {
        return this.mBoundScopes;
    }

    public boolean equals(Object entry) {
        if (IClassificationEntry.class.isInstance(entry)) {
            return this.compareTo((IClassificationEntry)entry) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(IClassificationEntry entry) {
        if (ClassificationEntry.class.isInstance(entry)) {
            return this.compareTo((ClassificationEntry)entry);
        }
        return 0;
    }

    @Override
    public int compareTo(ClassificationEntry entry) {
        if (entry.mScore.floatValue() > this.mScore.floatValue()) {
            return 1;
        }
        if (entry.mScore.floatValue() < this.mScore.floatValue()) {
            return -1;
        }
        return this.mName.compareTo(entry.getName());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{\n").append("\ttype: \"" + this.mType + "\",\n").append("\tname=\"" + this.mClassificationId + "\",\n").append("\tvariation=\"" + this.mVariationKey + "\",\n").append("\tattributes=" + this.mAttributes + ",\n").append("\tscore=\"" + String.format("%.3f", this.mScore) + "\",\n").append("\tscoreDescriptions=" + this.mScoreDescriptions + "\n").append("}");
        return buffer.toString();
    }
}

