/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core;

import com.ibm.aurora.rare.IClassificationEntry;
import com.ibm.aurora.rare.IClassificationStreamer;
import com.ibm.aurora.rare.IIndividualParameterFactory;
import com.ibm.aurora.rare.IInputManager;
import com.ibm.aurora.rare.IOutputManager;
import com.ibm.aurora.rare.IRARE;
import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.ClassificationEntry;
import com.ibm.aurora.rare.core.VariationsInitializationHandle;
import com.ibm.aurora.rare.core.classification.IClassification;
import com.ibm.aurora.rare.core.classification.IClassificationClass;
import com.ibm.aurora.rare.core.classification.IClassificationClassLoader;
import com.ibm.aurora.rare.core.classification.ITemplateRepository;
import com.ibm.aurora.rare.core.classification.impl.ClassificationClassLoader;
import com.ibm.aurora.rare.core.classification.impl.ClassificationLoader;
import com.ibm.aurora.rare.core.classification.impl.TemplateRepository;
import com.ibm.aurora.rare.core.exception.CancelException;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.exception.XMLParsingException;
import com.ibm.aurora.rare.core.parameter.ScopeParentParameter;
import com.ibm.aurora.rare.core.parameter.parameterFactory.ParameterFactory;
import com.ibm.aurora.rare.core.rule.IRule;
import com.ibm.aurora.rare.core.rule.RulesLibrary;
import com.ibm.aurora.rare.core.rule.impl.JavaRuleFactory;
import com.ibm.aurora.rare.core.rule.impl.XMLRulesLoader;
import com.ibm.aurora.rare.core.template.Template;
import com.ibm.aurora.rare.core.utils.TreeWriter;
import com.ibm.aurora.rare.core.variationengine.ParameterVariationTreeProducer;
import com.ibm.aurora.rare.core.variationengine.VariationKeyScorePair;
import com.ibm.aurora.rare.core.variationengine.VariationTree;
import com.ibm.aurora.rare.core.variationengine.VariationTreeResolver;
import com.ibm.aurora.rare.core.variationengine.VariationsSerializationsEnumerator;
import com.ibm.aurora.rare.logging.ELogLevel;
import com.ibm.aurora.rare.logging.ILogger;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class RARE
implements IRARE {
    private IClassification mClassification;
    private final RulesLibrary mRules;
    private final ParameterFactory mParameterFactory;
    private final ITemplateRepository mTemplateRepository;
    private final LoggingManager mLoggingManager;

    public RARE() throws Exception {
        this(null);
    }

    public RARE(ILogger logger) throws Exception {
        this.mLoggingManager = new LoggingManager(logger);
        this.mClassification = null;
        this.mParameterFactory = RARE.makeParameterFactory(this.mLoggingManager);
        this.mTemplateRepository = new TemplateRepository(this.mLoggingManager);
        this.mRules = new RulesLibrary();
        if (this.mLoggingManager.canLog(ELogLevel.INFO)) {
            this.mLoggingManager.getLogger().info("RARE instance initialized");
        }
    }

    @Override
    public IVariationsInitializationHandle initializeHandle(IInputManager inputManager, IOutputManager outputManager) {
        return this.initializeHandle(inputManager, outputManager, this.mLoggingManager);
    }

    @Override
    public IVariationsInitializationHandle initializeHandle(IInputManager inputManager, IOutputManager outputManager, LoggingManager loggingManager) {
        if (this.mLoggingManager.canLog(ELogLevel.INFO)) {
            this.mLoggingManager.getLogger().info("initializeHandle called with parameters (inputManager class = " + inputManager.getClass().getName() + "  outputManager class = " + outputManager.getClass().getName() + ")");
        }
        return new VariationsInitializationHandle(inputManager, outputManager, loggingManager);
    }

    @Override
    public List<IClassificationEntry> getRanked(IVariationsInitializationHandle iHandle, String classificationClassTag, Map<String, Set<String>> attributesFilter, Set<String> resolvableOutputTagFilter, boolean includeAllVariations) throws RAREException {
        VariationsInitializationHandle handle = (VariationsInitializationHandle)iHandle;
        LoggingManager loggingManager = handle.getLoggingManager();
        if (loggingManager.canLog(ELogLevel.INFO)) {
            loggingManager.getLogger().beginSection("getRanked");
            loggingManager.getLogger().info("getRanked called with parameters (classificationClassTag = " + classificationClassTag + ", attributesFilter = " + attributesFilter + ", resolvableOutputTagFilter = " + resolvableOutputTagFilter + ", includeAllVariations = " + includeAllVariations + ")");
        }
        try {
            ArrayList<IClassificationEntry> satisfiedEntries = new ArrayList<IClassificationEntry>();
            for (IClassificationClass classificationClass : this.mClassification.getClasses(classificationClassTag)) {
                boolean satisfiesOutputFilters;
                if (iHandle.isCanceled()) {
                    throw new CancelException();
                }
                if (classificationClass.isAbstract()) continue;
                boolean satisfiesAttributeFilters = attributesFilter == null || classificationClass.satisfiesAttributeFilters(attributesFilter);
                boolean bl = satisfiesOutputFilters = resolvableOutputTagFilter == null || classificationClass.satisfiesOutputFilters(resolvableOutputTagFilter);
                if (satisfiesAttributeFilters && satisfiesOutputFilters) {
                    VariationTree variationTree;
                    String className = classificationClass.getName();
                    if (loggingManager.canLog(ELogLevel.DEBUG)) {
                        loggingManager.getLogger().debug("Processing Class: " + classificationClass.getName());
                    }
                    if ((variationTree = this.getVariationTree(handle, classificationClass)) != null) {
                        if (loggingManager.canLog(ELogLevel.DEBUG)) {
                            loggingManager.getLogger().beginSection("Variation Tree");
                            loggingManager.getLogger().debug(TreeWriter.writeTree(variationTree.getRoot()));
                            loggingManager.getLogger().endSection("Variation Tree");
                        }
                        List<VariationKeyScorePair> variations = VariationsSerializationsEnumerator.getVariationKeys(handle, variationTree.getRoot(), !includeAllVariations);
                        if (loggingManager.canLog(ELogLevel.DEBUG)) {
                            for (VariationKeyScorePair keyScorePair : variations) {
                                loggingManager.getLogger().beginSection("Variation processed");
                                IClassificationEntry entry = this.createEntry(handle, className, classificationClassTag, keyScorePair, classificationClass.getAttributes());
                                loggingManager.getLogger().debug("Entry: " + entry);
                                this.getResolvedVariationTree(handle, entry, classificationClass);
                                loggingManager.getLogger().debug(TreeWriter.writeTree(handle, entry));
                                loggingManager.getLogger().endSection("Variation processed");
                            }
                        }
                        if (includeAllVariations) {
                            for (VariationKeyScorePair keyScorePair : variations) {
                                satisfiedEntries.add(this.createEntry(handle, className, classificationClassTag, keyScorePair, classificationClass.getAttributes()));
                            }
                            continue;
                        }
                        VariationKeyScorePair keyScorePair = this.getBestVariation(variations);
                        if (keyScorePair == null) continue;
                        satisfiedEntries.add(this.createEntry(handle, className, classificationClassTag, keyScorePair, classificationClass.getAttributes()));
                        continue;
                    }
                    if (!loggingManager.canLog(ELogLevel.DEBUG)) continue;
                    loggingManager.getLogger().debug("Class: " + classificationClass.getName() + " did not produce a valid variation tree with the provided input!");
                    continue;
                }
                if (!loggingManager.canLog(ELogLevel.DEBUG)) continue;
                loggingManager.getLogger().debug("Class: " + classificationClass.getName() + " did not satisfy filters (attributes = " + attributesFilter + "  output = " + resolvableOutputTagFilter + ")");
            }
            Collections.sort(satisfiedEntries);
            if (loggingManager.canLog(ELogLevel.INFO)) {
                loggingManager.getLogger().info("getRanked results: " + satisfiedEntries);
                loggingManager.getLogger().endSection("getRanked");
            }
            return satisfiedEntries;
        }
        catch (CancelException ex) {
            if (loggingManager.canLog()) {
                loggingManager.getLogger().error("Operation canceled.");
                loggingManager.getLogger().endSection("getRanked");
            }
            return Collections.emptyList();
        }
        catch (RAREException exception) {
            if (loggingManager.canLog()) {
                loggingManager.getLogger().error("Unable to rank classes", exception);
                loggingManager.getLogger().endSection("getRanked");
            }
            throw exception;
        }
    }

    @Override
    public StringBuilder resolve(IVariationsInitializationHandle handle, IClassificationEntry classificationEntry) throws RAREException {
        return this.resolve(handle, classificationEntry, "default");
    }

    @Override
    public StringBuilder resolve(IVariationsInitializationHandle iHandle, IClassificationEntry classificationEntry, String outputName) throws RAREException {
        VariationsInitializationHandle handle = (VariationsInitializationHandle)iHandle;
        LoggingManager loggingManager = handle.getLoggingManager();
        if (loggingManager.canLog(ELogLevel.INFO)) {
            loggingManager.getLogger().beginSection("resolve");
            loggingManager.getLogger().info("resolve called with parameters (classificationEntry = " + classificationEntry.toString() + ", outputName = " + outputName + ")");
        }
        try {
            IClassificationClass classificationClass = this.mClassification.getNamedClass(classificationEntry.getType(), classificationEntry.getClassificationId());
            Template template = classificationClass.getTemplate(outputName);
            StringBuilder resolvedTemplate = template.resolveTemplate(handle, this.getResolvedVariationTree(handle, classificationEntry, classificationClass));
            StringBuilder resolvedOutput = handle.getOutputManager().resolveOutput(resolvedTemplate, outputName);
            if (loggingManager.canLog(ELogLevel.INFO)) {
                loggingManager.getLogger().info("resolve result: " + resolvedOutput.toString());
                loggingManager.getLogger().endSection("resolve");
            }
            return resolvedOutput;
        }
        catch (RAREException exception) {
            if (loggingManager.canLog()) {
                loggingManager.getLogger().error("Unable to resolve output " + outputName, exception);
                loggingManager.getLogger().endSection("resolve");
            }
            throw exception;
        }
    }

    @Override
    public String serializeCLassificationEntry(IClassificationEntry classificationEntry) {
        return classificationEntry.getClassificationId() + ":" + classificationEntry.getName() + ":" + classificationEntry.getType() + ":" + classificationEntry.getVariationKey();
    }

    @Override
    public IClassificationEntry deserializeCLassificationEntry(String serializedClassificationEntry) {
        StringTokenizer dataTokenizer = new StringTokenizer(serializedClassificationEntry, ":", false);
        String classificationId = dataTokenizer.nextToken();
        String name = dataTokenizer.nextToken();
        String type = dataTokenizer.nextToken();
        String variationKey = dataTokenizer.hasMoreTokens() ? dataTokenizer.nextToken() : "";
        return new ClassificationEntry(classificationId, name, type, variationKey);
    }

    protected void addClassification(IClassificationStreamer streamer) throws Exception {
        this.loadClassification(streamer);
    }

    protected void addRules(InputStream stream) throws Exception {
        XMLRulesLoader loader = new XMLRulesLoader(stream, new JavaRuleFactory());
        try {
            Map<String, IRule<?>> rulesMap = loader.loadRules();
            if (this.mLoggingManager.canLog(ELogLevel.INFO)) {
                this.mLoggingManager.getLogger().beginSection("Registering rules");
            }
            for (Map.Entry<String, IRule<?>> entry : rulesMap.entrySet()) {
                if (this.mLoggingManager.canLog(ELogLevel.INFO)) {
                    this.mLoggingManager.getLogger().info("Register rule: " + entry.getKey());
                }
                this.mRules.add(entry.getKey(), entry.getValue());
            }
        }
        catch (XMLParsingException xpe) {
            if (this.mLoggingManager.canLog()) {
                this.mLoggingManager.getLogger().error("Error loading rules due to IOException", xpe);
                if (this.mLoggingManager.canLog(ELogLevel.INFO)) {
                    this.mLoggingManager.getLogger().endSection("Registering rules");
                }
            }
            throw xpe;
        }
        if (this.mLoggingManager.canLog(ELogLevel.INFO)) {
            this.mLoggingManager.getLogger().endSection("Registering rules");
        }
    }

    protected void addParameterFactory(String type, IIndividualParameterFactory individualParameterFactory) {
        if (this.mLoggingManager.canLog(ELogLevel.INFO)) {
            this.mLoggingManager.getLogger().info("Registering Parameter factory for parameter type: " + type);
        }
        this.mParameterFactory.checkAndRegisterIndividualParameterFactory(type, individualParameterFactory);
    }

    protected RulesLibrary getRulesLibrary() {
        return this.mRules;
    }

    protected LoggingManager getLoggingManager() {
        return this.mLoggingManager;
    }

    private IClassificationEntry createEntry(VariationsInitializationHandle handle, String classificationId, String type, VariationKeyScorePair keyScorePair, Map<String, Set<String>> attributes) throws RAREException {
        return new ClassificationEntry(classificationId, type, keyScorePair.getKey().toString(), Float.valueOf(keyScorePair.getScoreRec().getScore()), this.localizeAttributes(handle, attributes), this.localizeList(handle, keyScorePair.getScoreRec().getScoreDescriptions()), keyScorePair.getBoundScopes());
    }

    private List<String> localizeList(VariationsInitializationHandle handle, List<String> list) throws RAREException {
        List<String> localizedList;
        IOutputManager outputManager = handle.getOutputManager();
        if (outputManager.canLocalize()) {
            localizedList = new ArrayList<String>();
            for (String entry : list) {
                localizedList.add(outputManager.resolveOutput(new StringBuilder(entry), "attribute").toString());
            }
        } else {
            localizedList = list;
        }
        return localizedList;
    }

    private Map<String, Set<String>> localizeAttributes(VariationsInitializationHandle handle, Map<String, Set<String>> attributes) throws RAREException {
        Map<String, Set<String>> localizedAttributes;
        IOutputManager outputManager = handle.getOutputManager();
        if (outputManager.canLocalize()) {
            localizedAttributes = new HashMap<String, Set<String>>();
            for (Map.Entry<String, Set<String>> attribute : attributes.entrySet()) {
                HashSet<String> localizedValues = new HashSet<String>();
                for (String value : attribute.getValue()) {
                    localizedValues.add(outputManager.resolveOutput(new StringBuilder(value), "attribute").toString());
                }
                localizedAttributes.put(attribute.getKey(), localizedValues);
            }
        } else {
            localizedAttributes = attributes;
        }
        return localizedAttributes;
    }

    private VariationKeyScorePair getBestVariation(List<VariationKeyScorePair> variations) {
        if (variations.isEmpty()) {
            return null;
        }
        return variations.get(0);
    }

    private ScopeParentParameter getResolvedVariationTree(VariationsInitializationHandle variationsInitializationHandle, IClassificationEntry classificationEntry, IClassificationClass classificationClass) throws RAREException {
        String variationKey;
        String className = classificationEntry.getClassificationId();
        ScopeParentParameter resolvedTree = variationsInitializationHandle.getResolvedVariationTree(className, variationKey = classificationEntry.getVariationKey());
        if (resolvedTree == null) {
            VariationTree variationTree = this.getVariationTree(variationsInitializationHandle, classificationClass);
            VariationTreeResolver resolver = new VariationTreeResolver(this.mParameterFactory, variationsInitializationHandle.getLoggingManager());
            resolvedTree = resolver.resolveVariation(variationsInitializationHandle, new StringBuilder(classificationEntry.getVariationKey()), variationTree);
            variationsInitializationHandle.setResolvedVariationTree(className, variationKey, resolvedTree);
        }
        return resolvedTree;
    }

    private VariationTree getVariationTree(VariationsInitializationHandle variationHandle, IClassificationClass classificationClass) throws RAREException {
        String className = classificationClass.getName();
        VariationTree variationTree = variationHandle.getVariationTree(className);
        if (variationTree == null && (variationTree = new ParameterVariationTreeProducer(this.mParameterFactory, variationHandle.getLoggingManager()).getParameterVariationTree(variationHandle, classificationClass.getParameterTree())) != null) {
            variationHandle.setVariationTree(className, variationTree);
        }
        return variationTree;
    }

    private void loadClassification(IClassificationStreamer classificationStreamer) throws IOException, RAREException {
        block4: {
            ClassificationClassLoader defaultClassificationClassLoader = new ClassificationClassLoader(this.mTemplateRepository, classificationStreamer, this.mParameterFactory, this.mLoggingManager);
            if (this.mLoggingManager.canLog(ELogLevel.DEBUG)) {
                this.mLoggingManager.getLogger().beginSection("Processing Classification Stream");
            }
            HashMap<String, IClassificationClassLoader> classificationClassLoaders = new HashMap<String, IClassificationClassLoader>();
            ClassificationLoader classificationLoader = new ClassificationLoader(classificationStreamer, defaultClassificationClassLoader, classificationClassLoaders, this.mLoggingManager);
            try {
                this.mClassification = classificationLoader.load(this.getPreloadedClassification());
            }
            catch (RAREException exception) {
                if (!this.mLoggingManager.canLog()) break block4;
                this.mLoggingManager.getLogger().error("Could not parse classification stream", exception);
            }
        }
        if (this.mLoggingManager.canLog(ELogLevel.DEBUG)) {
            this.mLoggingManager.getLogger().endSection("Processing Classification Stream");
        }
    }

    private Set<IClassification> getPreloadedClassification() {
        HashSet<IClassification> preloadedClassifications = new HashSet<IClassification>();
        if (null != this.mClassification) {
            preloadedClassifications.add(this.mClassification);
        }
        return preloadedClassifications;
    }

    private static ParameterFactory makeParameterFactory(LoggingManager loggingManager) {
        return new ParameterFactory(loggingManager);
    }
}

