/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core;

import com.ibm.aurora.rare.IClassificationStreamer;
import com.ibm.aurora.rare.IIndividualParameterFactory;
import com.ibm.aurora.rare.IRARELibrary;
import com.ibm.aurora.rare.core.rule.RulesLibrary;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class RAREFileLibrary
implements IRARELibrary {
    private final String mClassificationPath;
    private final String mTemplateDirPath;
    private final String mRulesPath;
    private final Map<String, IIndividualParameterFactory> mParameterFactories;

    public RAREFileLibrary(String classificationPath, String templateDirPath, String rulesPath, Map<String, IIndividualParameterFactory> parameterFactories) {
        this.mClassificationPath = classificationPath;
        this.mTemplateDirPath = templateDirPath;
        this.mRulesPath = rulesPath;
        this.mParameterFactories = parameterFactories;
    }

    @Override
    public IClassificationStreamer getClassificationStreamer() {
        return new IClassificationStreamer(){

            @Override
            public InputStream getClassificationStream() throws IOException {
                return new FileInputStream(RAREFileLibrary.this.mClassificationPath);
            }

            @Override
            public InputStream getTemplateStream(String name) throws IOException {
                return new FileInputStream(RAREFileLibrary.this.mTemplateDirPath + name + ".xml");
            }
        };
    }

    @Override
    public InputStream getRules() throws IOException {
        return new FileInputStream(this.mRulesPath);
    }

    @Override
    public Map<String, IIndividualParameterFactory> getParameterFactories(RulesLibrary rulesLibrary) {
        return this.mParameterFactories;
    }

    @Override
    public boolean hasClassification() {
        return this.mClassificationPath != null || this.mTemplateDirPath != null;
    }

    @Override
    public boolean hasRules() {
        return this.mRulesPath != null;
    }

    @Override
    public boolean hasParameterFactories() {
        return this.mParameterFactories != null;
    }
}

