/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core;

import com.ibm.aurora.rare.IRARE;
import com.ibm.aurora.rare.IRAREProvider;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.logging.ILogger;
import java.util.HashMap;
import java.util.Map;

public class RAREPerProviderSingletonFixture {
    private static final Map<Class<? extends IRAREProvider>, IRARE> _rareInstancesMap = new HashMap<Class<? extends IRAREProvider>, IRARE>();

    protected RAREPerProviderSingletonFixture() throws RAREException {
        throw new RAREException("RAREPerProviderSingletonFixture should never be instantiated");
    }

    public static final IRARE getRare(Class<? extends IRAREProvider> providerClass) throws RAREException {
        return RAREPerProviderSingletonFixture.getRare(providerClass, null);
    }

    public static final IRARE getRare(Class<? extends IRAREProvider> providerClass, ILogger logger) throws RAREException {
        IRARE rare = _rareInstancesMap.get(providerClass);
        if (rare == null) {
            try {
                rare = RAREPerProviderSingletonFixture.createRare(providerClass.getConstructor(new Class[0]).newInstance(new Object[0]), logger);
            }
            catch (Exception e) {
                throw new RAREException("Could not instantiate provider class", e);
            }
        }
        return rare;
    }

    public static final IRARE getRare(IRAREProvider provider) throws RAREException {
        return RAREPerProviderSingletonFixture.getRare(provider, null);
    }

    public static final IRARE getRare(IRAREProvider provider, ILogger logger) throws RAREException {
        IRARE rare = _rareInstancesMap.get(provider.getClass());
        if (rare == null) {
            rare = RAREPerProviderSingletonFixture.createRare(provider, logger);
        }
        return rare;
    }

    private static final synchronized IRARE createRare(IRAREProvider provider, ILogger logger) throws RAREException {
        IRARE rare;
        try {
            rare = provider.getRARE(logger);
        }
        catch (Exception e) {
            throw new RAREException("Could not create a RARE instance", e);
        }
        _rareInstancesMap.put(provider.getClass(), rare);
        return rare;
    }
}

