/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core;

import com.ibm.aurora.rare.IClassificationStreamer;
import com.ibm.aurora.rare.IIndividualParameterFactory;
import com.ibm.aurora.rare.IRARE;
import com.ibm.aurora.rare.IRARELibrary;
import com.ibm.aurora.rare.IRAREProvider;
import com.ibm.aurora.rare.core.RARE;
import com.ibm.aurora.rare.core.RARELibrary;
import com.ibm.aurora.rare.logging.ELogLevel;
import com.ibm.aurora.rare.logging.ILogger;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RAREProvider
implements IRAREProvider {
    private volatile RARE mRare = null;
    private List<IClassificationStreamer> mClassificationStreamers = new ArrayList<IClassificationStreamer>();

    @Override
    public final IRARE getRARE() throws Exception {
        return this.getRARE(null);
    }

    @Override
    public final IRARE getRARE(ILogger logger) throws Exception {
        if (this.mRare == null) {
            this.initializeRARE(logger);
        }
        return this.mRare;
    }

    protected void addLibraries() throws Exception {
    }

    protected final void addLibrary(IRARELibrary library) throws Exception {
        LoggingManager loggingManager = this.mRare.getLoggingManager();
        if (loggingManager.canLog(ELogLevel.INFO)) {
            loggingManager.getLogger().beginSection("Processing Library");
            loggingManager.getLogger().info("Library: " + library.getClass().getSimpleName());
        }
        if (library.hasParameterFactories()) {
            if (loggingManager.canLog(ELogLevel.INFO)) {
                loggingManager.getLogger().beginSection("Process Parameter Factories");
            }
            Map<String, IIndividualParameterFactory> parameterFactoriesMap = library.getParameterFactories(this.mRare.getRulesLibrary());
            for (Map.Entry<String, IIndividualParameterFactory> entry : parameterFactoriesMap.entrySet()) {
                this.mRare.addParameterFactory(entry.getKey(), entry.getValue());
            }
            if (loggingManager.canLog(ELogLevel.INFO)) {
                loggingManager.getLogger().endSection("Process Parameter Factories");
            }
        }
        if (library.hasRules()) {
            if (loggingManager.canLog(ELogLevel.INFO)) {
                loggingManager.getLogger().beginSection("Process Rules");
            }
            this.mRare.addRules(library.getRules());
            if (loggingManager.canLog(ELogLevel.INFO)) {
                loggingManager.getLogger().endSection("Process Rules");
            }
        }
        if (library.hasClassification()) {
            if (loggingManager.canLog(ELogLevel.INFO)) {
                loggingManager.getLogger().info("Storing Classification for later processing");
            }
            this.mClassificationStreamers.add(library.getClassificationStreamer());
        }
        if (loggingManager.canLog(ELogLevel.INFO)) {
            loggingManager.getLogger().endSection("Processing Library");
        }
    }

    private final synchronized void initializeRARE(ILogger logger) throws Exception {
        if (this.mRare == null) {
            this.mRare = new RARE(logger);
            this.addLibrary(new RARELibrary());
            this.addLibraries();
            LoggingManager loggingManager = this.mRare.getLoggingManager();
            if (loggingManager.canLog(ELogLevel.INFO)) {
                loggingManager.getLogger().beginSection("Process Classification");
            }
            for (IClassificationStreamer streamer : this.mClassificationStreamers) {
                this.mRare.addClassification(streamer);
            }
            if (loggingManager.canLog(ELogLevel.INFO)) {
                loggingManager.getLogger().endSection("Process Classification");
            }
        }
    }
}

