/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core;

import com.ibm.aurora.rare.IInputManager;
import com.ibm.aurora.rare.IOutputManager;
import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.parameter.ScopeParentParameter;
import com.ibm.aurora.rare.core.utils.XMLHelperD4J;
import com.ibm.aurora.rare.core.variationengine.VariationTree;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.util.HashMap;
import java.util.Map;

public class VariationsInitializationHandle
implements IVariationsInitializationHandle {
    private final IInputManager mInputManager;
    private final IOutputManager mOutputManager;
    private final Map<String, VariationTree> mVariationTreeMap;
    private final Map<String, ScopeParentParameter> mResolvedVariationTreeMap;
    private final Map<Class<?>, Object> mResources;
    private final LoggingManager mLoggingManager;
    private volatile boolean mCanceled = false;

    public VariationsInitializationHandle(IInputManager inputManager, IOutputManager outputManager, LoggingManager loggingManager) {
        this.mInputManager = inputManager;
        this.mOutputManager = outputManager;
        this.mVariationTreeMap = new HashMap<String, VariationTree>();
        this.mResolvedVariationTreeMap = new HashMap<String, ScopeParentParameter>();
        this.mResources = new HashMap();
        this.setResource(XMLHelperD4J.class, new XMLHelperD4J());
        this.mLoggingManager = loggingManager;
    }

    @Override
    public IInputManager getInputManager() {
        return this.mInputManager;
    }

    @Override
    public IOutputManager getOutputManager() {
        return this.mOutputManager;
    }

    @Override
    public final <T> T setResource(Class<T> clazz, T resource) {
        return (T)this.mResources.put(clazz, resource);
    }

    @Override
    public <T> T getResource(Class<T> clazz) {
        return (T)this.mResources.get(clazz);
    }

    @Override
    public void cancel() {
        this.mCanceled = true;
    }

    @Override
    public boolean isCanceled() {
        return this.mCanceled;
    }

    public VariationTree getVariationTree(String className) {
        return this.mVariationTreeMap.get(className);
    }

    public LoggingManager getLoggingManager() {
        return this.mLoggingManager;
    }

    protected void setVariationTree(String className, VariationTree variationTree) {
        this.mVariationTreeMap.put(className, variationTree);
    }

    public ScopeParentParameter getResolvedVariationTree(String className, String variationKey) {
        return this.mResolvedVariationTreeMap.get(this.generateVariationClassKey(className, variationKey));
    }

    protected void setResolvedVariationTree(String className, String variationKey, ScopeParentParameter resolvedVariationTree) {
        this.mResolvedVariationTreeMap.put(this.generateVariationClassKey(className, variationKey), resolvedVariationTree);
    }

    private String generateVariationClassKey(String className, String variationKey) {
        return className + ":" + variationKey;
    }
}

