/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.classification.impl;

import com.ibm.aurora.rare.core.classification.IClassification;
import com.ibm.aurora.rare.core.classification.IClassificationClass;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class Classification
implements IClassification {
    private final Map<String, IClassificationClass> mStore;
    private final String mVersion;

    public Classification(String version, Map<String, IClassificationClass> classes) {
        this.mVersion = version;
        this.mStore = classes;
    }

    @Override
    public String getVersion() {
        return this.mVersion;
    }

    @Override
    public Collection<IClassificationClass> getClasses() {
        return this.mStore.values();
    }

    @Override
    public Collection<IClassificationClass> getClasses(String type) {
        HashSet<IClassificationClass> classes = new HashSet<IClassificationClass>();
        Collection<IClassificationClass> allClasses = this.getClasses();
        for (IClassificationClass classificationClass : allClasses) {
            if (!type.equals(classificationClass.getType())) continue;
            classes.add(classificationClass);
        }
        return classes;
    }

    @Override
    public IClassificationClass getNamedClass(String type, String name) {
        IClassificationClass result = null;
        Collection<IClassificationClass> allClasses = this.getClasses();
        for (IClassificationClass classificationClass : allClasses) {
            if (!type.equals(classificationClass.getType()) || !name.equals(classificationClass.getName())) continue;
            result = classificationClass;
            break;
        }
        return result;
    }
}

