/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.classification.impl;

import com.ibm.aurora.rare.core.classification.IClassificationClass;
import com.ibm.aurora.rare.core.classification.IClassificationClassLoader;
import com.ibm.aurora.rare.core.parameter.ScopeParentParameter;
import com.ibm.aurora.rare.core.template.Template;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassificationClass
implements IClassificationClass {
    private static final Set<String> NON_INHERIT_ATTRIBUTES = new HashSet<String>();
    private final List<IClassificationClass> mBaseClassificationClasses;
    private final List<IClassificationClass> mUsedClassificationClasses;
    private final IClassificationClassLoader mClassificationClassLoader;
    private final String mType;
    private final String mName;
    private final ScopeParentParameter mParameterTree;
    private final Map<String, Template> mTemplates;
    private final Map<String, Set<String>> mMultiValuedAttributes;
    private final boolean mIsAbstract;
    private final LoggingManager mLoggingManager;

    public ClassificationClass(List<IClassificationClass> baseClassificationClasses, List<IClassificationClass> usedClassificationClasses, IClassificationClassLoader classificationClassLoader, String type, String name, Map<String, Set<String>> multiValuedAttributes, ScopeParentParameter parameterTree, Map<String, Template> templates, boolean isAbstract, LoggingManager loggingManager) {
        this.mBaseClassificationClasses = baseClassificationClasses;
        this.mUsedClassificationClasses = usedClassificationClasses;
        this.mClassificationClassLoader = classificationClassLoader;
        this.mType = type;
        this.mName = name;
        this.mParameterTree = parameterTree;
        this.mTemplates = templates;
        this.mMultiValuedAttributes = new HashMap<String, Set<String>>(multiValuedAttributes);
        this.mIsAbstract = isAbstract;
        ClassificationClass.mergeInheritedAttributes(this.mBaseClassificationClasses, this.mMultiValuedAttributes);
        this.mLoggingManager = loggingManager;
    }

    @Override
    public List<IClassificationClass> getBaseClassificationClasses() {
        return this.mBaseClassificationClasses;
    }

    @Override
    public List<IClassificationClass> getUsedClassificationClasses() {
        return this.mUsedClassificationClasses;
    }

    @Override
    public IClassificationClassLoader getClassificationClassLoader() {
        return this.mClassificationClassLoader;
    }

    @Override
    public Object getType() {
        return this.mType;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean isAbstract() {
        return this.mIsAbstract;
    }

    @Override
    public Map<String, Set<String>> getAttributes() {
        return this.mMultiValuedAttributes;
    }

    @Override
    public boolean isResolvable(String output) {
        if (output == null) {
            return !this.mTemplates.isEmpty();
        }
        return this.mTemplates.containsKey(output);
    }

    @Override
    public ScopeParentParameter getParameterTree() {
        return this.mParameterTree;
    }

    public Collection<Template> getTemplates() {
        return this.mTemplates.values();
    }

    @Override
    public Template getTemplate(String name) {
        return this.mTemplates.get(name);
    }

    @Override
    public boolean satisfiesAttributeFilters(Map<String, Set<String>> attributes) {
        boolean match = true;
        for (Map.Entry<String, Set<String>> attribute : attributes.entrySet()) {
            String attributeName = attribute.getKey();
            Set<String> attributeValue = attribute.getValue();
            if (null == attributeValue) {
                UnsupportedOperationException exception = new UnsupportedOperationException("Null set of string are not supported (" + attributeName + ')');
                if (this.mLoggingManager.canLog()) {
                    this.mLoggingManager.getLogger().error("Attribute " + attributeName + " contains no attribute values", exception);
                }
                throw exception;
            }
            if (ClassificationClass.satisfiesAttributeFilter(this.mMultiValuedAttributes.get(attributeName), attributeValue)) continue;
            match = false;
            break;
        }
        return match;
    }

    @Override
    public boolean satisfiesOutputFilters(Set<String> resolvableOutputTagFilter) {
        boolean match;
        if (null == resolvableOutputTagFilter) {
            match = true;
        } else {
            match = false;
            for (String resolvableOutputTag : resolvableOutputTagFilter) {
                if (!this.isResolvable(resolvableOutputTag)) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    public String toString() {
        return this.mType + '-' + this.mName;
    }

    private static void mergeInheritedAttributes(List<IClassificationClass> classes, Map<String, Set<String>> mergedAttrs) {
        if (classes != null) {
            for (IClassificationClass cls : classes) {
                Map<String, Set<String>> attrs = cls.getAttributes();
                for (Map.Entry<String, Set<String>> entry : attrs.entrySet()) {
                    if (NON_INHERIT_ATTRIBUTES.contains(entry.getKey()) || mergedAttrs.containsKey(entry.getKey())) continue;
                    mergedAttrs.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    private static boolean satisfiesAttributeFilter(Set<String> classAttributeValues, Set<String> filterAttributeValues) {
        boolean match = false;
        if (null != classAttributeValues) {
            for (String classAttributeValue : classAttributeValues) {
                if (!filterAttributeValues.contains(classAttributeValue)) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    static {
        NON_INHERIT_ATTRIBUTES.add("abstract");
        NON_INHERIT_ATTRIBUTES.add("extends");
    }
}

