/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.classification.impl;

import com.ibm.aurora.rare.IClassificationStreamer;
import com.ibm.aurora.rare.core.classification.IClassificationClass;
import com.ibm.aurora.rare.core.classification.IClassificationClassLoader;
import com.ibm.aurora.rare.core.classification.ITemplateRepository;
import com.ibm.aurora.rare.core.classification.impl.ClassificationClass;
import com.ibm.aurora.rare.core.classification.impl.ClassificationLoader;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.parameter.ParentParameter;
import com.ibm.aurora.rare.core.parameter.ScopeParentParameter;
import com.ibm.aurora.rare.core.parameter.parameterFactory.ParameterFactory;
import com.ibm.aurora.rare.core.parameterparser.ParameterParsingHelper;
import com.ibm.aurora.rare.core.parameterparser.ParameterTreeReader;
import com.ibm.aurora.rare.core.template.ITemplate;
import com.ibm.aurora.rare.core.template.ParsedNode;
import com.ibm.aurora.rare.core.template.Template;
import com.ibm.aurora.rare.core.utils.XMLHelperD4J;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public class ClassificationClassLoader
implements IClassificationClassLoader {
    protected static final String CLASSIFICATION_NAMESPACE_URI = "http://developer.cognos.com/rare/xmlns/classification/";
    private final ITemplateRepository mTemplateRepository;
    private final IClassificationStreamer mClassificationStreamer;
    private final ParameterFactory mParameterFactory;
    private final LoggingManager mLoggingManager;

    public ClassificationClassLoader(ITemplateRepository templateRepository, IClassificationStreamer classificationStreamer, ParameterFactory parameterFactory, LoggingManager loggingManager) {
        this.mTemplateRepository = templateRepository;
        this.mClassificationStreamer = classificationStreamer;
        this.mParameterFactory = parameterFactory;
        this.mLoggingManager = loggingManager;
    }

    @Override
    public IClassificationClass load(Element classElement) throws RAREException {
        return this.load(null, null, classElement);
    }

    @Override
    public IClassificationClass load(List<IClassificationClass> baseClassificationClassList, List<IClassificationClass> usesClassificationClassList, Element classElement) throws RAREException {
        String xmlns = XMLHelperD4J.lookupPrefix(CLASSIFICATION_NAMESPACE_URI, classElement);
        String classificationClassName = this.getName(xmlns, classElement);
        boolean isAbstract = this.getIsAbstract(xmlns, classElement);
        XMLHelperD4J xmlHelper = new XMLHelperD4J();
        try {
            Map<String, Template> templates = this.loadTemplates(xmlHelper, xmlns, classElement, classificationClassName);
            if (null != baseClassificationClassList) {
                for (IClassificationClass baseClassificationClass : baseClassificationClassList) {
                    for (Template baseTemplate : baseClassificationClass.getTemplates()) {
                        templates.put(baseTemplate.getId(), baseTemplate);
                    }
                }
            }
            Map<String, Set<String>> classificationAttrs = this.getMultiValuedAttributes(xmlHelper, xmlns, classElement);
            ScopeParentParameter parameterTree = this.loadParameterTree(classificationAttrs, baseClassificationClassList, usesClassificationClassList, xmlns, classElement, templates.values());
            return new ClassificationClass(baseClassificationClassList, usesClassificationClassList, this, this.getType(xmlns, classElement), classificationClassName, classificationAttrs, parameterTree, templates, isAbstract, this.mLoggingManager);
        }
        catch (IOException e) {
            RAREException exception = new RAREException("failed loading classification class '" + classificationClassName + '\'', e);
            if (this.mLoggingManager.canLog()) {
                this.mLoggingManager.getLogger().error("Could not load the calssification class " + classificationClassName + " due to an IO error", exception);
            }
            throw exception;
        }
    }

    protected String getType(String xmlns, Element classElement) {
        return classElement.getName();
    }

    protected String getName(String xmlns, Element classElement) throws RAREException {
        return ClassificationLoader.getName(xmlns, classElement, this.mLoggingManager);
    }

    protected boolean getIsAbstract(String xmlns, Element classElement) throws RAREException {
        return ClassificationLoader.getIsAbstract(xmlns, classElement);
    }

    protected static void addAttribute(Map<String, Set<String>> multiValuedAttributes, String name, String value) {
        Set<String> values = multiValuedAttributes.get(name);
        if (null == values) {
            values = new HashSet<String>();
            multiValuedAttributes.put(name, values);
        }
        values.add(value);
    }

    protected static Map<String, Set<String>> makeUnmodifiableWrapper(Map<String, Set<String>> multiValuedAttributes) {
        for (Map.Entry<String, Set<String>> entry : multiValuedAttributes.entrySet()) {
            entry.setValue(Collections.unmodifiableSet(entry.getValue()));
        }
        return Collections.unmodifiableMap(multiValuedAttributes);
    }

    protected Map<String, Set<String>> getMultiValuedAttributes(XMLHelperD4J xmlHelper, String xmlns, Element classElement) throws RAREException {
        HashMap<String, Set<String>> multiValuedAttributes = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> entry : XMLHelperD4J.getAttributesFromNode(classElement).entrySet()) {
            ClassificationClassLoader.addAttribute(multiValuedAttributes, entry.getKey(), entry.getValue());
        }
        Element attributesElement = xmlHelper.getChildElement(classElement, "attributes", xmlns);
        if (null != attributesElement) {
            List<Element> attributeElements = XMLHelperD4J.getChildElements(attributesElement, "attribute", xmlns);
            for (Element attributeElement : attributeElements) {
                String attributeName = XMLHelperD4J.getAttributeOrNull(attributeElement, xmlns, CLASSIFICATION_NAMESPACE_URI, "name");
                List<Element> valueElements = XMLHelperD4J.getChildElements(attributeElement, "value", xmlns);
                for (Element valueElement : valueElements) {
                    String valueText = valueElement.getText();
                    ClassificationClassLoader.addAttribute(multiValuedAttributes, attributeName, valueText);
                }
            }
        }
        return ClassificationClassLoader.makeUnmodifiableWrapper(multiValuedAttributes);
    }

    protected ScopeParentParameter loadParameterTree(Map<String, Set<String>> classificationAttrs, List<IClassificationClass> baseClassificationClassList, List<IClassificationClass> usesClassificationClassList, String xmlns, Element classElement, Collection<Template> templates) throws RAREException {
        HashMap<String, ParentParameter> usedTrees = new HashMap<String, ParentParameter>();
        if (usesClassificationClassList != null) {
            for (IClassificationClass classificationClass : usesClassificationClassList) {
                usedTrees.put(classificationClass.getName(), classificationClass.getParameterTree());
            }
        }
        ParameterTreeReader treeReader = new ParameterTreeReader(this.mTemplateRepository, this.mClassificationStreamer, this.mParameterFactory, templates, usedTrees, this.mLoggingManager);
        ParentParameter baseParameterTree = null;
        if (null != baseClassificationClassList) {
            for (IClassificationClass baseClassificationClass : baseClassificationClassList) {
                baseParameterTree = (ParentParameter)ParameterParsingHelper.mergeTrees(baseParameterTree, baseClassificationClass.getParameterTree(), this.mLoggingManager);
            }
        }
        return treeReader.getVisParameterTree(classificationAttrs, null, new ParsedNode(xmlns, classElement), baseParameterTree);
    }

    protected Map<String, Template> loadTemplates(XMLHelperD4J xmlHelper, String xmlns, Element classElement, String classificationClassName) throws RAREException, IOException {
        HashMap<String, Template> result = new HashMap<String, Template>();
        Element outputElement = xmlHelper.getChildElement(classElement, "output", xmlns);
        if (null != outputElement) {
            Iterator childItr = outputElement.elementIterator();
            while (childItr.hasNext()) {
                Element outputChildNode = (Element)childItr.next();
                if (1 != outputChildNode.getNodeType() || !XMLHelperD4J.checkNamespace(outputChildNode, xmlns)) continue;
                Element outputChildElement = outputChildNode;
                String templateAttribute = XMLHelperD4J.getAttributeOrNull(outputChildElement, xmlns, CLASSIFICATION_NAMESPACE_URI, "template");
                String templateId = outputChildElement.getName();
                boolean suppressWhiteSpace = outputChildElement.attribute("suppressWhiteSpaceContent") != null ? outputChildElement.attribute("suppressWhiteSpaceContent").getValue().equalsIgnoreCase("true") : false;
                ITemplateRepository.ITemplateFactory templateFactory = this.newTemplateFactoryForChildElement(templateId, outputChildElement, templateAttribute);
                ITemplate template = null == templateAttribute ? new Template(templateId, outputChildElement, this.mParameterFactory, this.mTemplateRepository, this.mClassificationStreamer, this.mLoggingManager, suppressWhiteSpace) : this.mTemplateRepository.getOrCreateTemplate(templateAttribute, templateFactory);
                if (template == null || !Template.class.isInstance(template)) continue;
                result.put(templateId, (Template)template);
            }
        }
        return result;
    }

    protected ITemplateRepository.ITemplateFactory newTemplateFactoryForChildElement(final String templateId, Element outputChildElement, final String templateAttribute) {
        return new ITemplateRepository.ITemplateFactory(){

            @Override
            public Template createTemplate() throws RAREException, IOException {
                InputStream is = ClassificationClassLoader.this.mClassificationStreamer.getTemplateStream(templateAttribute);
                if (null == is) {
                    RAREException exception = new RAREException("Template '" + templateAttribute + "' not found by " + ClassificationClassLoader.this.mClassificationStreamer);
                    if (ClassificationClassLoader.this.mLoggingManager.canLog()) {
                        ClassificationClassLoader.this.mLoggingManager.getLogger().error("The template " + templateAttribute + " does not exist at the provided path", exception);
                    }
                    throw exception;
                }
                Element templateRoot = XMLHelperD4J.parseXMLStream(is);
                boolean suppressWhiteSpace = templateRoot.attribute("suppressWhiteSpaceContent") != null ? templateRoot.attribute("suppressWhiteSpaceContent").getValue().equalsIgnoreCase("true") : false;
                return new Template(templateId, templateRoot, ClassificationClassLoader.this.mParameterFactory, ClassificationClassLoader.this.mTemplateRepository, ClassificationClassLoader.this.mClassificationStreamer, ClassificationClassLoader.this.mLoggingManager, suppressWhiteSpace);
            }
        };
    }
}

