/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.classification.impl;

import com.ibm.aurora.rare.IClassificationStreamer;
import com.ibm.aurora.rare.core.classification.IClassification;
import com.ibm.aurora.rare.core.classification.IClassificationClass;
import com.ibm.aurora.rare.core.classification.IClassificationClassLoader;
import com.ibm.aurora.rare.core.classification.IClassificationLoader;
import com.ibm.aurora.rare.core.classification.impl.Classification;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.utils.TreeWriter;
import com.ibm.aurora.rare.core.utils.XMLHelperD4J;
import com.ibm.aurora.rare.logging.ELogLevel;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.dom4j.Element;

public class ClassificationLoader
implements IClassificationLoader {
    public static final String CLASSIFICATION_DEFAULT_VERSION = "1";
    private final IClassificationStreamer mStreamer;
    private final IClassificationClassLoader mDefaultClassificationClassLoader;
    private final Map<String, IClassificationClassLoader> mClassificationClassLoaders;
    private final LoggingManager mLoggingManager;

    public ClassificationLoader(IClassificationStreamer streamer, IClassificationClassLoader defaultClassificationClassLoader, Map<String, IClassificationClassLoader> classificationClassLoaders, LoggingManager loggingManager) {
        this.mStreamer = streamer;
        this.mClassificationClassLoaders = classificationClassLoaders;
        this.mDefaultClassificationClassLoader = defaultClassificationClassLoader;
        this.mLoggingManager = loggingManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IClassification load(Set<IClassification> preloadedClassifications) throws IOException, RAREException {
        InputStream classificationStream = this.mStreamer.getClassificationStream();
        try {
            Element classificationElement = XMLHelperD4J.parseXMLStream(classificationStream);
            String xmlns = null;
            Classification classification = new Classification(ClassificationLoader.getVersion(classificationElement), this.getClasses(preloadedClassifications, classificationElement, xmlns));
            return classification;
        }
        finally {
            classificationStream.close();
        }
    }

    public static String getName(String xmlns, Element classElement, LoggingManager loggingManager) throws RAREException {
        String result = XMLHelperD4J.getAttributeOrNull(classElement, xmlns, "http://developer.cognos.com/rare/xmlns/classification/", "name");
        if (null == result || result.isEmpty()) {
            RAREException exception = new RAREException("The classification is missing the 'name' attribute or the 'name' attribute is empty");
            if (loggingManager.canLog()) {
                loggingManager.getLogger().error("The class being loaded does not have a name attribute", exception);
            }
            throw exception;
        }
        return result;
    }

    public static boolean getIsAbstract(String xmlns, Element classElement) {
        String result = XMLHelperD4J.getAttributeOrNull(classElement, xmlns, "http://developer.cognos.com/rare/xmlns/classification/", "abstract");
        if (null == result || result.isEmpty()) {
            return false;
        }
        return result.equals("true");
    }

    private static String getVersion(Element classificationElement) {
        String version;
        String string = version = classificationElement.attribute("version") != null ? classificationElement.attribute("version").getValue() : "";
        if (version.isEmpty()) {
            version = CLASSIFICATION_DEFAULT_VERSION;
        }
        return version;
    }

    private Map<String, IClassificationClass> getClasses(Set<IClassification> preloadedClassifications, Element classificationElement, String xmlns) throws RAREException {
        HashMap<String, IClassificationClass> classes = new HashMap<String, IClassificationClass>();
        this.loadPreloadClassificationClasses(classes, preloadedClassifications);
        XMLHelperD4J xmlHelper = new XMLHelperD4J();
        HashSet loadedClassNamesForSanity = new HashSet(classes.keySet());
        Iterator childItr = classificationElement.elementIterator();
        while (childItr.hasNext()) {
            Element child = (Element)childItr.next();
            if (child.getNodeType() != 1) continue;
            Element childElement = child;
            String className = ClassificationLoader.getName(xmlns, childElement, this.mLoggingManager);
            if (!loadedClassNamesForSanity.add(className)) {
                RAREException exception = new RAREException("Duplicate classification class with name '" + className + '\'');
                if (this.mLoggingManager.canLog()) {
                    this.mLoggingManager.getLogger().error("The classifications being loaded contains more than one class with the same name: " + className, exception);
                }
                throw exception;
            }
            IClassificationClassLoader classificationClassLoader = this.getClassificationClassLoader(childElement.getName());
            if (null == classificationClassLoader) continue;
            if (this.mLoggingManager.canLog(ELogLevel.DEBUG)) {
                this.mLoggingManager.getLogger().beginSection("Processing Class");
                this.mLoggingManager.getLogger().debug("Class name: " + className);
            }
            IClassificationClass classificationClass = this.loadClass(xmlHelper, className, classificationElement, childElement, classificationClassLoader, classes, xmlns);
            if (!this.mLoggingManager.canLog(ELogLevel.DEBUG)) continue;
            this.mLoggingManager.getLogger().beginSection("Parameter Tree");
            this.mLoggingManager.getLogger().debug(TreeWriter.writeTree(classificationClass.getParameterTree()));
            this.mLoggingManager.getLogger().endSection("Parameter Tree");
            this.mLoggingManager.getLogger().endSection("Processing Class");
        }
        return classes;
    }

    private IClassificationClassLoader getClassificationClassLoader(String type) {
        IClassificationClassLoader classificationClassLoader = this.mClassificationClassLoaders.get(type);
        if (classificationClassLoader == null) {
            classificationClassLoader = this.mDefaultClassificationClassLoader;
        }
        return classificationClassLoader;
    }

    private void loadPreloadClassificationClasses(Map<String, IClassificationClass> classes, Set<IClassification> preloadedClassifications) {
        for (IClassification classification : preloadedClassifications) {
            for (IClassificationClass classificationClass : classification.getClasses()) {
                classes.put(classificationClass.getName(), classificationClass);
            }
        }
    }

    private IClassificationClass loadClass(XMLHelperD4J xmlHelper, String className, Element classificationElement, Element childElement, IClassificationClassLoader classificationClassLoader, Map<String, IClassificationClass> classes, String xmlns) throws RAREException {
        IClassificationClass classificationClass = classes.get(className);
        if (null == classificationClass) {
            List<IClassificationClass> baseClassificationClassList = this.loadBaseClass(xmlHelper, classificationElement, childElement, classificationClassLoader, classes, xmlns, "extends");
            List<IClassificationClass> usesClassificationClassList = this.loadBaseClass(xmlHelper, classificationElement, childElement, classificationClassLoader, classes, xmlns, "uses");
            classificationClass = classificationClassLoader.load(baseClassificationClassList, usesClassificationClassList, childElement);
            classes.put(className, classificationClass);
        }
        return classificationClass;
    }

    private List<IClassificationClass> loadBaseClass(XMLHelperD4J xmlHelper, Element classificationElement, Element childElement, IClassificationClassLoader classificationClassLoader, Map<String, IClassificationClass> classes, String xmlns, String extendsAttr) throws RAREException {
        ArrayList<IClassificationClass> baseClassificationClassList = new ArrayList<IClassificationClass>();
        String baseClassNames = XMLHelperD4J.getAttributeOrNull(childElement, xmlns, "http://developer.cognos.com/rare/xmlns/classification/", extendsAttr);
        if (null != baseClassNames && !baseClassNames.isEmpty()) {
            StringTokenizer dataTokenizer = new StringTokenizer(baseClassNames, ",", false);
            while (dataTokenizer.hasMoreElements()) {
                String baseClassName = dataTokenizer.nextToken();
                IClassificationClass baseClassificationClass = classes.get(baseClassName);
                if (null == baseClassificationClass) {
                    Element baseClassElement = xmlHelper.getChildElementWithAttribute(classificationElement, childElement.getName(), "name", baseClassName, xmlns, false);
                    if (null == baseClassElement) {
                        String name = XMLHelperD4J.getAttributeOrNull(childElement, xmlns, "http://developer.cognos.com/rare/xmlns/classification/", "name");
                        RAREException exception = new RAREException("Base class '" + baseClassName + "' cannot be found for '" + name + "'.");
                        if (this.mLoggingManager.canLog()) {
                            this.mLoggingManager.getLogger().error("The class " + name + " extends from a non existant class: " + baseClassName, exception);
                        }
                        throw exception;
                    }
                    baseClassificationClass = this.loadClass(xmlHelper, baseClassName, classificationElement, baseClassElement, classificationClassLoader, classes, xmlns);
                }
                baseClassificationClassList.add(baseClassificationClass);
            }
        }
        return baseClassificationClassList;
    }
}

