/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.classification.impl;

import com.ibm.aurora.rare.core.classification.ITemplateRepository;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.template.ITemplate;
import com.ibm.aurora.rare.core.template.SubTemplateHandle;
import com.ibm.aurora.rare.core.template.Template;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TemplateRepository
implements ITemplateRepository {
    protected final Map<String, ITemplate> mTemplates = new ConcurrentHashMap<String, ITemplate>();

    public TemplateRepository(LoggingManager loggingManager) {
    }

    @Override
    public ITemplate getTemplate(String id) {
        return this.mTemplates.get(id);
    }

    @Override
    public void addTemplate(String id, ITemplate template) {
        this.mTemplates.put(id, template);
    }

    @Override
    public ITemplate getOrCreateTemplate(String id, ITemplateRepository.ITemplateFactory templateFactory) throws RAREException, IOException {
        ITemplate template = this.getTemplate(id);
        if (null == template && (template = templateFactory.createTemplate()) != null) {
            this.mTemplates.put(id, template);
        }
        return template;
    }

    @Override
    public SubTemplateHandle getSubTemplateHandle(String name, String currentTemplateId, ITemplateRepository.ITemplateFactory templateFactory) throws RAREException, IOException {
        String fullName = this.getFullSubTemplateName(name, currentTemplateId);
        int indexOfSeparator = fullName.indexOf(58);
        String templateName = fullName.substring(0, indexOfSeparator);
        String subTemplateName = fullName.substring(indexOfSeparator + 1);
        ITemplate referencedTemplate = this.getOrCreateTemplate(templateName, templateFactory);
        SubTemplateHandle subTemplate = null;
        if (referencedTemplate != null && Template.class.isInstance(referencedTemplate)) {
            subTemplate = ((Template)referencedTemplate).getSubTemplate(subTemplateName);
        }
        return subTemplate;
    }

    @Override
    public String getReferencedTemplateName(String name, String currentTemplateId) {
        String fullName = this.getFullSubTemplateName(name, currentTemplateId);
        int indexOfSeparator = fullName.indexOf(58);
        String templateName = fullName.substring(0, indexOfSeparator);
        return templateName;
    }

    protected String getFullSubTemplateName(String name, String currentTemplateId) {
        if (name.indexOf(58) < 0) {
            return currentTemplateId + ':' + name;
        }
        return name;
    }
}

