/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.parameter;

import com.ibm.aurora.rare.core.exception.ParameterCreationException;
import com.ibm.aurora.rare.core.exception.ParameterResolutionException;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.ParentParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IConditionalParameter;
import java.util.List;
import java.util.Map;

public abstract class ConditionalParentParameter
extends ParentParameter
implements IConditionalParameter {
    private ParentParameter _else = null;

    public ConditionalParentParameter(String name, Map<String, String> attributes) throws ParameterCreationException {
        super(name, attributes);
    }

    public ConditionalParentParameter(ConditionalParentParameter parameter) throws ParameterCreationException {
        this(parameter, false);
    }

    public ConditionalParentParameter(ConditionalParentParameter parameter, boolean shallow) throws ParameterCreationException {
        super(parameter, shallow);
        if (!shallow && parameter._else != null) {
            this._else = parameter._else.copyImpl(shallow);
        }
    }

    public void setElse(ParentParameter elseParam) {
        this._else = elseParam;
    }

    public ParentParameter getElse() {
        return this._else;
    }

    @Override
    public List<Parameter> getParameters() {
        try {
            if (this.isResolved() && !this.isValid()) {
                if (this._else != null) {
                    return this._else.getParameters();
                }
                return null;
            }
        }
        catch (ParameterResolutionException parameterResolutionException) {
            // empty catch block
        }
        return super.getParameters();
    }

    @Override
    public String logResolution() throws ParameterResolutionException {
        StringBuffer result = new StringBuffer();
        result.append(" condition=").append(this.isValid());
        return result.toString();
    }
}

