/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.parameter;

import com.ibm.aurora.rare.core.parameter.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class DependentParameter
extends Parameter {
    private final List<String> mDependentParametersNames;
    private List<Parameter> mDependentParameters = null;

    public DependentParameter(String name, Map<String, String> attributes) {
        super(name, attributes);
        String parameterNames = this.getAttribute("parameters", attributes);
        this.mDependentParametersNames = parameterNames != null ? this.tokenizeList(parameterNames) : null;
    }

    public DependentParameter(DependentParameter parameter) {
        super(parameter);
        this.mDependentParametersNames = parameter.mDependentParametersNames;
        this.mDependentParameters = parameter.mDependentParameters;
    }

    public boolean isDependent() {
        return this.mDependentParametersNames != null && !this.mDependentParametersNames.isEmpty();
    }

    public List<String> getDependentParametersNames() {
        return this.mDependentParametersNames;
    }

    public void setDependentParameters(List<Parameter> dependentParameters) {
        this.mDependentParameters = dependentParameters;
    }

    protected final List<Parameter> getDependentParameters() {
        return this.mDependentParameters;
    }

    @Override
    public boolean validateMatchesAttributes(Map<String, String> attributes) {
        String parameterNames = this.getAttribute("parameters", attributes);
        if (parameterNames != null) {
            List<String> proposedDependentList = this.tokenizeList(parameterNames);
            if (proposedDependentList.size() != this.mDependentParametersNames.size()) {
                return false;
            }
            for (int i = 0; i < proposedDependentList.size(); ++i) {
                if (proposedDependentList.get(i).equals(this.mDependentParametersNames.get(i))) continue;
                return false;
            }
        }
        return super.validateMatchesAttributes(attributes);
    }

    protected final List<String> tokenizeList(String parameterNames) {
        ArrayList<String> tokenized = new ArrayList<String>();
        if (parameterNames != null) {
            StringTokenizer dataTokenizer = new StringTokenizer(parameterNames, ",", false);
            while (dataTokenizer.hasMoreElements()) {
                tokenized.add(dataTokenizer.nextToken());
            }
        }
        return tokenized;
    }
}

