/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.parameter;

import com.ibm.aurora.rare.core.exception.ParameterCreationException;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.ParentParameter;
import com.ibm.aurora.rare.core.parameter.VariableParameter;
import java.util.ArrayList;
import java.util.List;

public class MultiVariableParameter
extends VariableParameter {
    public static final String TYPE = "multivariation";
    private int[] mOrderIndexes = null;
    private int mCurrentOrderIndex;
    private int mMinBindings;
    private int mMaxBindings;
    private boolean mAllowsBindingSizeVariations;
    private boolean mEnumerateAllOrders;

    public MultiVariableParameter(String name) {
        super(name);
        this.mCurrentOrderIndex = 0;
        this.mMinBindings = 1;
        this.mMaxBindings = 1;
        this.mAllowsBindingSizeVariations = false;
        this.setMaxNumBindingsInGroup(this.mMaxBindings);
    }

    public MultiVariableParameter(MultiVariableParameter parameter) throws ParameterCreationException {
        super(parameter);
        if (parameter.mOrderIndexes != null) {
            this.mOrderIndexes = (int[])parameter.mOrderIndexes.clone();
        }
        this.mCurrentOrderIndex = parameter.mCurrentOrderIndex;
        this.mMinBindings = parameter.mMinBindings;
        this.mMaxBindings = parameter.mMaxBindings;
        this.mAllowsBindingSizeVariations = parameter.mAllowsBindingSizeVariations;
    }

    public MultiVariableParameter(MultiVariableParameter parameter, boolean shallow) throws ParameterCreationException {
        super(parameter, shallow);
        if (parameter.mOrderIndexes != null) {
            this.mOrderIndexes = (int[])parameter.mOrderIndexes.clone();
        }
        this.mCurrentOrderIndex = parameter.mCurrentOrderIndex;
        this.mMinBindings = parameter.mMinBindings;
        this.mMaxBindings = parameter.mMaxBindings;
        this.mAllowsBindingSizeVariations = parameter.mAllowsBindingSizeVariations;
    }

    public List<Parameter> getCurrentVariations() {
        ArrayList<Parameter> activeVariations = new ArrayList<Parameter>();
        if (this.mOrderIndexes != null) {
            for (int i = 0; i < this.mCurrentOrderIndex; ++i) {
                activeVariations.add(this.getParameters().get(this.mOrderIndexes[i]));
            }
        }
        return activeVariations;
    }

    public void setVariationActive(int index, boolean active) {
        if (index < this.getNumVariations()) {
            if (this.mOrderIndexes == null) {
                this.mOrderIndexes = new int[this.getNumVariations()];
                this.setAllVariationsInnactive();
            }
            this.mOrderIndexes[this.mCurrentOrderIndex++] = index;
        }
    }

    public void setAllVariationsInnactive() {
        this.mCurrentOrderIndex = 0;
    }

    public int getMinBindings() {
        return this.mMinBindings;
    }

    public void setMinBindings(int minBindingSize) {
        this.mMinBindings = minBindingSize;
    }

    public int getMaxBindings() {
        return this.mMaxBindings;
    }

    public void setMaxBindings(int maxBindingSize) {
        this.mMaxBindings = maxBindingSize;
    }

    public boolean allowsBindingSizeVariations() {
        return this.mAllowsBindingSizeVariations;
    }

    public void setAllowsBindingSizeVariations(boolean allowsBindingSizeVariations) {
        this.mAllowsBindingSizeVariations = allowsBindingSizeVariations;
    }

    public boolean enumerateAllOrders() {
        return this.mEnumerateAllOrders;
    }

    public void setEnumerateAllOrders(boolean enumerateAllOrders) {
        this.mEnumerateAllOrders = enumerateAllOrders;
    }

    @Override
    public StringBuilder serializeVariationChoices() {
        StringBuilder serializeOutput = new StringBuilder("");
        for (int i = 0; i < this.mCurrentOrderIndex; ++i) {
            if (i != 0) {
                serializeOutput.append("-");
            }
            serializeOutput.append(this.mOrderIndexes[i]);
        }
        serializeOutput.append(".");
        return serializeOutput;
    }

    @Override
    public int deserializeVariationChoices(StringBuilder key, int index) {
        this.setAllVariationsInnactive();
        int currentIndex = index;
        int currentVariationIndex = 0;
        if (key.charAt(currentIndex) >= '0' && key.charAt(currentIndex) <= '9' || key.charAt(currentIndex) == '.') {
            while (key.charAt(currentIndex) != '.') {
                if (key.charAt(currentIndex) == '-') {
                    ++currentIndex;
                }
                int numericEndIndex = currentIndex + 1;
                while (key.charAt(numericEndIndex) >= '0' && key.charAt(numericEndIndex) <= '9') {
                    ++numericEndIndex;
                }
                currentVariationIndex = Integer.parseInt(key.substring(currentIndex, numericEndIndex));
                currentIndex = numericEndIndex;
                this.setVariationActive(currentVariationIndex, true);
            }
            ++currentIndex;
        }
        return currentIndex;
    }

    @Override
    public String logResolution() {
        StringBuffer result = new StringBuffer();
        result.append(" active child index(ices)=").append((CharSequence)this.serializeVariationChoices());
        return result.toString();
    }

    @Override
    protected Parameter copyImpl() throws ParameterCreationException {
        MultiVariableParameter copy = new MultiVariableParameter(this);
        return copy;
    }

    @Override
    protected ParentParameter copyImpl(boolean shallow) throws ParameterCreationException {
        MultiVariableParameter copy = new MultiVariableParameter(this, shallow);
        return copy;
    }
}

