/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.parameter;

import com.ibm.aurora.rare.core.exception.ParameterCreationException;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class Parameter {
    private String mName;
    private String mFullName;
    private final Map<String, String> mAttributes;
    private Map<String, Set<String>> mClassificationAttributes;

    public Parameter(String name) {
        this(name, null);
    }

    public Parameter(String name, Map<String, String> attributes) {
        this.mName = name;
        this.mFullName = name;
        this.mAttributes = attributes != null ? attributes : new HashMap();
    }

    public String getName() {
        return this.mName;
    }

    public String getFullName() {
        return this.mFullName;
    }

    protected void setName(String name) {
        this.mName = name;
    }

    protected void setFullName(String fullName) {
        this.mFullName = fullName;
    }

    public void setPath(String path) {
        this.mFullName = path != null ? path + "." + this.mName : this.mName;
    }

    public Parameter(Parameter parameter) {
        this.mName = parameter.mName;
        this.mFullName = parameter.mFullName;
        this.mAttributes = parameter.mAttributes;
        this.mClassificationAttributes = parameter.mClassificationAttributes;
    }

    public boolean validateMatchesAttributes(Map<String, String> attributes) {
        return true;
    }

    protected Map<String, String> getAttributes() {
        return this.mAttributes;
    }

    protected String getAttribute(String name, Map<String, String> attributes) {
        if (attributes != null) {
            return attributes.get(name);
        }
        return null;
    }

    protected boolean hasAttribute(String name, Map<String, String> attributes) {
        if (attributes != null) {
            return attributes.containsKey(name);
        }
        return false;
    }

    public void setAttribute(String name, String value) {
        this.mAttributes.put(name, value);
    }

    public String getAttribute(String name) {
        return this.mAttributes.get(name);
    }

    public void setClassificationAttribute(Map<String, Set<String>> attrs) {
        this.mClassificationAttributes = attrs;
    }

    public Map<String, Set<String>> getClassificationAttributes() {
        return this.mClassificationAttributes;
    }

    @Deprecated
    public Parameter copy() throws ParameterCreationException {
        return this.copy(new LoggingManager(null));
    }

    public Parameter copy(LoggingManager loggingManager) throws ParameterCreationException {
        Parameter copy = this.copyImpl();
        if (copy != null && copy.getClass() != this.getClass()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Parameter ").append(this.getName());
            buffer.append(" doesn't match the copy ").append(copy.getName());
            ParameterCreationException exception = new ParameterCreationException(buffer.toString(), this.getName());
            if (loggingManager.canLog()) {
                loggingManager.getLogger().error("Parameter copy failed for parameter" + this.getName() + ", parameter class is " + this.getClass().getCanonicalName() + " and the copy's class is " + copy.getClass().getCanonicalName(), exception);
            }
            throw exception;
        }
        return copy;
    }

    public String logResolution() throws RAREException {
        return "";
    }

    protected abstract Parameter copyImpl() throws ParameterCreationException;
}

