/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.parameter;

import com.ibm.aurora.rare.core.exception.ParameterCreationException;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.ParentParameter;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.util.HashMap;
import java.util.Map;

public class ParameterGraphCopier {
    protected ParameterGraphCopier() {
    }

    public static ParentParameter deepCopyParameter(ParentParameter param, LoggingManager loggingManager) throws ParameterCreationException {
        HashMap<Parameter, Parameter> copyMap = new HashMap<Parameter, Parameter>();
        return (ParentParameter)ParameterGraphCopier.safeDeepCopyParameter(param, copyMap, loggingManager);
    }

    private static Parameter safeDeepCopyParameter(Parameter param, Map<Parameter, Parameter> copyMap, LoggingManager loggingManager) throws ParameterCreationException {
        if (!copyMap.containsKey(param)) {
            Parameter copiedParameter = ParameterGraphCopier.safeCopyParameter(param, copyMap, loggingManager);
            if (ParentParameter.class.isInstance(param) && ((ParentParameter)param).hasChildren()) {
                for (Parameter childParam : ((ParentParameter)param).getParameters()) {
                    ((ParentParameter)copiedParameter).addChildParameter(ParameterGraphCopier.safeDeepCopyParameter(childParam, copyMap, loggingManager));
                }
            }
            return copiedParameter;
        }
        return copyMap.get(param);
    }

    private static Parameter safeCopyParameter(Parameter param, Map<Parameter, Parameter> copyMap, LoggingManager loggingManager) throws ParameterCreationException {
        Parameter copiedParameter = null;
        copiedParameter = ParentParameter.class.isInstance(param) ? ((ParentParameter)param).shallowCopy(true, loggingManager) : param.copyImpl();
        copyMap.put(param, copiedParameter);
        return copiedParameter;
    }
}

