/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.parameter;

import com.ibm.aurora.rare.core.exception.ParameterCreationException;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.ParameterGraphCopier;
import com.ibm.aurora.rare.core.parameter.ScopeParentParameter;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParentParameter
extends Parameter {
    public static final String TYPE = "parent";
    private Map<String, Parameter> mChildren = null;
    private List<Parameter> mChildList = null;
    private boolean mAllowDuplicates = false;

    public ParentParameter(String name) {
        super(name);
    }

    public ParentParameter(String name, Map<String, String> attributes) {
        super(name, attributes);
    }

    public ParentParameter(ParentParameter parameter) throws ParameterCreationException {
        super(parameter);
        if (parameter.mChildList != null) {
            this.copyChildrenFromParameter(parameter, null);
        }
    }

    public ParentParameter(ParentParameter parameter, boolean shallow) throws ParameterCreationException {
        super(parameter);
        if (!shallow && parameter.mChildList != null) {
            this.copyChildrenFromParameter(parameter, null);
        }
    }

    @Override
    protected Parameter copyImpl() throws ParameterCreationException {
        ParentParameter copy = new ParentParameter(this);
        return copy;
    }

    protected ParentParameter copyImpl(boolean shallow) throws ParameterCreationException {
        ParentParameter copy = new ParentParameter(this, shallow);
        return copy;
    }

    public static Parameter getCopyOfParameter(Parameter parameter, LoggingManager loggingManager) throws ParameterCreationException {
        if (ParentParameter.class.isInstance(parameter)) {
            return ((ParentParameter)parameter).shallowCopy(false, loggingManager);
        }
        return parameter.copyImpl();
    }

    public ParentParameter shallowCopy(boolean shallow) throws ParameterCreationException {
        return this.shallowCopy(shallow, null);
    }

    public ParentParameter shallowCopy(boolean shallow, LoggingManager loggingManager) throws ParameterCreationException {
        if (!shallow) {
            return ParameterGraphCopier.deepCopyParameter(this, loggingManager);
        }
        ParentParameter copy = this.copyImpl(true);
        if (copy != null && copy.getClass() != this.getClass()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Parameter ").append(this.getName());
            buffer.append(" doesn't match the copy ").append(copy.getName());
            ParameterCreationException exception = new ParameterCreationException(buffer.toString(), this.getName());
            if (loggingManager != null && loggingManager.canLog()) {
                loggingManager.getLogger().error("Parameter shallowcopy failed for parameter" + this.getName() + ", parameter class is " + this.getClass().getCanonicalName() + " and the copy's class is " + copy.getClass().getCanonicalName(), exception);
            }
            throw exception;
        }
        return copy;
    }

    private void copyChildrenFromParameter(ParentParameter parameter, LoggingManager loggingManager) throws ParameterCreationException {
        for (Parameter param : parameter.mChildList) {
            this.addChildParameter(ParentParameter.getCopyOfParameter(param, loggingManager));
        }
    }

    public void addChildParameters(List<Parameter> params) {
        for (Parameter param : params) {
            this.addChildParameter(param);
        }
    }

    public final void addChildParameter(Parameter param) {
        if (this.mChildren == null) {
            this.mChildren = new HashMap<String, Parameter>();
            this.mChildList = new ArrayList<Parameter>();
        }
        if (!this.mChildren.containsKey(param.getName())) {
            param.setPath(this.getFullName());
            this.mChildren.put(param.getName(), param);
            this.mChildList.add(param);
        } else if (this.mAllowDuplicates) {
            this.mChildList.add(param);
        }
    }

    public Parameter getChildParameter(String name) {
        if (this.mChildren != null) {
            return this.mChildren.get(name);
        }
        return null;
    }

    public List<Parameter> getParameters() {
        return this.mChildList;
    }

    public final void clearChildParameters() {
        this.mChildren = null;
        this.mChildList = null;
    }

    public final int getNumChildren() {
        List<Parameter> childList = this.getParameters();
        if (childList != null) {
            return childList.size();
        }
        return 0;
    }

    public final boolean hasChildren() {
        return this.getNumChildren() > 0;
    }

    @Override
    public void setPath(String path) {
        super.setPath(path);
        this.setChildPaths();
    }

    protected void setChildPaths() {
        if (this.mChildList != null) {
            for (Parameter param : this.mChildList) {
                if (ScopeParentParameter.class.isInstance(param)) continue;
                param.setPath(this.getFullName());
            }
        }
    }

    protected final void setAllowDuplicates(boolean allowDuplicates) {
        this.mAllowDuplicates = allowDuplicates;
    }
}

