/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.parameter;

import com.ibm.aurora.rare.core.exception.ParameterCreationException;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.ParentParameter;
import com.ibm.aurora.rare.core.parameter.ScopeParentParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IResolutionGroupMember;
import java.util.List;

public class VariableParameter
extends ParentParameter
implements IResolutionGroupMember {
    public static final String TYPE = "variations";
    private int mCurrentVariation = -1;
    private boolean mIsTransient = false;
    private String mResolutionGroupTag = null;
    private boolean mEnumerateVariations = true;
    private int mMaxNumBindingsInGroup = 1;

    public VariableParameter(String name) {
        super(name);
        this.setAllowDuplicates(true);
    }

    public VariableParameter(VariableParameter parameter) throws ParameterCreationException {
        super(parameter);
        this.mCurrentVariation = parameter.mCurrentVariation;
        this.mResolutionGroupTag = parameter.mResolutionGroupTag;
        this.mEnumerateVariations = parameter.mEnumerateVariations;
        this.mIsTransient = parameter.mIsTransient;
        this.mMaxNumBindingsInGroup = parameter.mMaxNumBindingsInGroup;
        this.setAllowDuplicates(true);
    }

    public VariableParameter(VariableParameter parameter, boolean shallow) throws ParameterCreationException {
        super(parameter, shallow);
        this.mCurrentVariation = parameter.mCurrentVariation;
        this.mResolutionGroupTag = parameter.mResolutionGroupTag;
        this.mEnumerateVariations = parameter.mEnumerateVariations;
        this.mIsTransient = parameter.mIsTransient;
        this.mMaxNumBindingsInGroup = parameter.mMaxNumBindingsInGroup;
        this.setAllowDuplicates(true);
    }

    @Override
    protected Parameter copyImpl() throws ParameterCreationException {
        VariableParameter copy = new VariableParameter(this);
        return copy;
    }

    @Override
    protected ParentParameter copyImpl(boolean shallow) throws ParameterCreationException {
        VariableParameter copy = new VariableParameter(this, shallow);
        return copy;
    }

    public int getNumVariations() {
        return this.getNumChildren();
    }

    public Parameter getCurrentVariation() {
        return this.getParameters().get(this.mCurrentVariation);
    }

    public int getcurrentVariationIndex() {
        return this.mCurrentVariation;
    }

    public void setcurrentVariation(int variation) {
        this.mCurrentVariation = variation;
    }

    public void addVariation(Parameter parameter) {
        this.addChildParameter(parameter);
        if (this.isTransient()) {
            parameter.setName(this.getName());
            parameter.setFullName(this.getFullName());
        }
    }

    public StringBuilder serializeVariationChoices() {
        return new StringBuilder(Integer.toString(this.mCurrentVariation));
    }

    public int deserializeVariationChoices(StringBuilder key, int index) {
        int currentIndex = index;
        int keyLength = key.length();
        if (key.charAt(currentIndex) >= '0' && key.charAt(currentIndex) <= '9') {
            int numericEndIndex;
            for (numericEndIndex = currentIndex + 1; numericEndIndex < keyLength && key.charAt(numericEndIndex) >= '0' && key.charAt(numericEndIndex) <= '9'; ++numericEndIndex) {
            }
            this.mCurrentVariation = Integer.parseInt(key.substring(currentIndex, numericEndIndex));
            currentIndex = numericEndIndex;
        }
        return currentIndex;
    }

    @Override
    public void setToResolutionGroup(IResolutionGroupMember resolutionGroupParameter) {
        this.mResolutionGroupTag = resolutionGroupParameter.getResolutionGroupName();
    }

    @Override
    public String getResolutionGroupName() {
        return this.mResolutionGroupTag;
    }

    public boolean isTransient() {
        return this.mIsTransient;
    }

    public void setTransient(boolean isTransient) {
        this.mIsTransient = isTransient;
    }

    public void setEnumerateAllVariationsActive(boolean allow) {
        this.mEnumerateVariations = allow;
    }

    public boolean enumerateAllVariationsActive() {
        return this.mEnumerateVariations;
    }

    public void setMaxNumBindingsInGroup(int maxNum) {
        this.mMaxNumBindingsInGroup = maxNum;
    }

    public int getMaxNumBindingsInGroup() {
        return this.mMaxNumBindingsInGroup;
    }

    @Override
    public String logResolution() {
        StringBuffer result = new StringBuffer();
        result.append(" active child index(ices)=").append(this.getcurrentVariationIndex());
        return result.toString();
    }

    @Override
    protected void setChildPaths() {
        if (!this.isTransient()) {
            super.setChildPaths();
        } else {
            List<Parameter> childParams = this.getParameters();
            if (childParams != null) {
                for (Parameter param : childParams) {
                    if (ScopeParentParameter.class.isInstance(param)) continue;
                    param.setFullName(this.getFullName());
                }
            }
        }
    }
}

