/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.parameter.parameterFactory;

import com.ibm.aurora.rare.IIndividualParameterFactory;
import com.ibm.aurora.rare.core.exception.ParameterCreationException;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ParameterFactory {
    private final Map<String, IIndividualParameterFactory> mIndividualParameterFactories = new HashMap<String, IIndividualParameterFactory>();
    private final LoggingManager mLoggingManager;

    public ParameterFactory(LoggingManager loggingManager) {
        this.mLoggingManager = loggingManager;
    }

    public boolean canCreateParameterType(String type) {
        return this.mIndividualParameterFactories.containsKey(type);
    }

    public void checkAndRegisterIndividualParameterFactory(String type, IIndividualParameterFactory individualParameterFactory) {
        if (null == individualParameterFactory) {
            IllegalArgumentException exception = new IllegalArgumentException("individualParameterFactory cannot be null");
            if (this.mLoggingManager.canLog()) {
                this.mLoggingManager.getLogger().error("individualParameterFactory provided for type " + type + " is invalid", exception);
            }
            throw exception;
        }
        this.mIndividualParameterFactories.put(type, individualParameterFactory);
    }

    public Parameter createParameter(String type) throws ParameterCreationException {
        return this.createParameter(type, "anonymous", Collections.<String, String>emptyMap(), null);
    }

    public Parameter createParameter(String type, String name) throws ParameterCreationException {
        return this.createParameter(type, name, Collections.<String, String>emptyMap(), null);
    }

    public Parameter createParameter(String type, String name, Map<String, String> attributes) throws ParameterCreationException {
        return this.createParameter(type, name, attributes, null);
    }

    public Parameter createParameter(String type, String name, Map<String, String> attributes, Map<String, Set<String>> classificationAttrs) throws ParameterCreationException {
        Parameter visParam = null;
        IIndividualParameterFactory individualParameterFactory = this.mIndividualParameterFactories.get(type);
        if (null != individualParameterFactory) {
            try {
                visParam = individualParameterFactory.createVisParameter(name, attributes);
            }
            catch (ParameterCreationException pce) {
                if (this.mLoggingManager.canLog()) {
                    this.mLoggingManager.getLogger().error("Parameter " + name + " could not be created" + type, pce);
                }
                throw pce;
            }
        } else {
            ParameterCreationException exception = new ParameterCreationException("Could not create parameter of type " + type, name);
            if (this.mLoggingManager.canLog()) {
                this.mLoggingManager.getLogger().error("Parameter " + name + " could not be created as no IndividualParameterFactory has been provided for type " + type, exception);
            }
            throw exception;
        }
        visParam.setClassificationAttribute(classificationAttrs);
        return visParam;
    }
}

