/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.parameterparser;

import com.ibm.aurora.rare.core.exception.ParameterCreationException;
import com.ibm.aurora.rare.core.exception.ParameterParsingException;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.exception.TemplateParsingException;
import com.ibm.aurora.rare.core.parameter.LoopParameter;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.ParentParameter;
import com.ibm.aurora.rare.core.parameter.ScopeParentParameter;
import com.ibm.aurora.rare.core.parameter.SubTemplateParameter;
import com.ibm.aurora.rare.core.parameter.parameterFactory.ParameterFactory;
import com.ibm.aurora.rare.core.parameterparser.ParameterScopeRecord;
import com.ibm.aurora.rare.core.template.ParsedNode;
import com.ibm.aurora.rare.core.template.SubTemplateHandle;
import com.ibm.aurora.rare.core.utils.Pair;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ParameterParsingHelper {
    private static final String ROOT_SCOPE = "root";

    protected ParameterParsingHelper() {
    }

    public static List<String> getPropertyListFromNodeAttribute(String propString) {
        if (propString != null) {
            StringTokenizer nameTokenizer = new StringTokenizer(propString, ",", false);
            ArrayList<String> props = new ArrayList<String>();
            while (nameTokenizer.hasMoreElements()) {
                props.add(nameTokenizer.nextToken());
            }
            return props;
        }
        return null;
    }

    public static ScopeParentParameter getRootParameterFromTemplateHandle(SubTemplateHandle currentTemplate, Map<String, SubTemplateParameter> templateRootParameters) {
        if (currentTemplate == null || templateRootParameters == null) {
            return null;
        }
        return templateRootParameters.get(currentTemplate.getName());
    }

    public static List<Map<String, String>> getSubTemplateCallParameterReferences(ParsedNode subTemplateNode, LoggingManager loggingManager) throws TemplateParsingException {
        ArrayList<Map<String, String>> parameterReferences = new ArrayList<Map<String, String>>();
        for (ParsedNode withParamChildNode : subTemplateNode.getChildNodes()) {
            if (withParamChildNode.getNodeType() != 1) continue;
            if (withParamChildNode.inTemplateNamespace() && withParamChildNode.getNodeName().equals("withParam")) {
                Map<String, String> withParamNodeAttributes = withParamChildNode.getAttributes();
                parameterReferences.add(withParamNodeAttributes);
                continue;
            }
            TemplateParsingException exception = new TemplateParsingException("CallTemplate node contains invalid Element: " + withParamChildNode.getNodeName());
            if (loggingManager.canLog()) {
                loggingManager.getLogger().error("CallTemplate tag contains an invalid child element: " + withParamChildNode.getNodeName(), exception);
            }
            throw exception;
        }
        return parameterReferences;
    }

    public static Map<String, Parameter> getReferencedTemplateParameters(ParsedNode subTemplateNode, ParentParameter parentParam, ParentParameter rootParameter, ScopeParentParameter templateRootParameter, Map<String, Parameter> templateReferencedParameters, ParameterFactory parameterFactory, LoggingManager loggingManager) throws RAREException {
        List<Map<String, String>> subTemplateCallParameterReferences = ParameterParsingHelper.getSubTemplateCallParameterReferences(subTemplateNode, loggingManager);
        return ParameterParsingHelper.getReferencedTemplateParameters(subTemplateCallParameterReferences, parentParam, rootParameter, templateRootParameter, templateReferencedParameters, parameterFactory, loggingManager);
    }

    public static Map<String, Parameter> getReferencedTemplateParameters(List<Map<String, String>> referedParameters, ParentParameter parentParam, ParentParameter rootParameter, ScopeParentParameter templateRootParameter, Map<String, Parameter> templateReferencedParameters, ParameterFactory parameterFactory, LoggingManager loggingManager) throws RAREException {
        HashMap<String, Parameter> templateCallerReferences = new HashMap<String, Parameter>();
        for (Map<String, String> referredParameterAttributes : referedParameters) {
            Pair<String, Parameter> referencedParam = ParameterParsingHelper.extractParameter(null, "withParam", referredParameterAttributes, null, parentParam, null, rootParameter, templateRootParameter, templateReferencedParameters, parameterFactory, loggingManager);
            if (referencedParam == null) continue;
            String paramName = referencedParam.getFirst();
            String as = referredParameterAttributes.get("as");
            if (as != null) {
                paramName = as;
            }
            templateCallerReferences.put(paramName, referencedParam.getSecond());
        }
        return templateCallerReferences;
    }

    public static Pair<String, Parameter> extractParameter(Map<String, Set<String>> classificationAttrs, ParsedNode paramNode, String paramName, ParentParameter parentParam, List<ParameterScopeRecord> orphanedParameters, ParentParameter rootParameter, ScopeParentParameter templateRootParameter, Map<String, Parameter> templateReferencedParameters, ParameterFactory parameterFactory, LoggingManager loggingManager) throws ParameterParsingException, ParameterCreationException {
        return ParameterParsingHelper.extractParameter(classificationAttrs, paramNode.getNodeName(), paramNode.getAttributes(), paramName, parentParam, orphanedParameters, rootParameter, templateRootParameter, templateReferencedParameters, parameterFactory, loggingManager);
    }

    public static Pair<String, Parameter> findParameter(ParsedNode paramNode, String paramName, ParentParameter parentParam, ParentParameter rootParameter, ScopeParentParameter templateRootParameter, Map<String, Parameter> templateReferencedParameters, ParameterFactory parameterFactory) throws ParameterParsingException, ParameterCreationException {
        return ParameterParsingHelper.findParameter(paramNode.getNodeName(), paramNode.getAttributes(), paramName, parentParam, rootParameter, templateRootParameter, templateReferencedParameters, parameterFactory);
    }

    public static Parameter findParameterFromScope(String scope, String paramName, ParentParameter parentParam, ParentParameter rootParameter, ScopeParentParameter templateRootParameter, Map<String, Parameter> templateReferencedParameters) {
        Parameter param = ParameterParsingHelper.getParameterFromScope(scope, paramName, parentParam, rootParameter, templateRootParameter);
        if (param == null) {
            param = ParameterParsingHelper.getReferencedParameterFromScope(scope, paramName, parentParam, templateRootParameter, templateReferencedParameters);
        }
        return param;
    }

    public static Pair<String, Parameter> findParameter(String type, Map<String, String> paramNodeAttributes, String paramName, ParentParameter parentParam, ParentParameter rootParameter, ScopeParentParameter templateRootParameter, Map<String, Parameter> templateReferencedParameters, ParameterFactory parameterFactory) throws ParameterParsingException {
        Parameter param = null;
        String scope = paramNodeAttributes.get("scope");
        String name = null;
        if (parameterFactory.canCreateParameterType(type) && paramName != null) {
            name = paramName;
            param = ParameterParsingHelper.findParameterFromScope(scope, paramName, parentParam, rootParameter, templateRootParameter, templateReferencedParameters);
        }
        if (param == null) {
            for (Map.Entry<String, String> entry : paramNodeAttributes.entrySet()) {
                if (!parameterFactory.canCreateParameterType(entry.getKey())) continue;
                name = paramNodeAttributes.get(entry.getKey());
                type = entry.getKey();
                param = ParameterParsingHelper.findParameterFromScope(scope, name, parentParam, rootParameter, templateRootParameter, templateReferencedParameters);
                if (param == null) continue;
                break;
            }
        }
        return new Pair<String, Object>(name, param);
    }

    public static Pair<String, Parameter> extractParameter(Map<String, Set<String>> classificationAttrs, String type, Map<String, String> paramNodeAttributes, String paramName, ParentParameter parentParam, List<ParameterScopeRecord> orphanedParameters, ParentParameter rootParameter, ScopeParentParameter templateRootParameter, Map<String, Parameter> templateReferencedParameters, ParameterFactory parameterFactory, LoggingManager loggingManager) throws ParameterParsingException, ParameterCreationException {
        Pair<String, Parameter> nameParamPair = ParameterParsingHelper.findParameter(type, paramNodeAttributes, paramName, parentParam, rootParameter, templateRootParameter, templateReferencedParameters, parameterFactory);
        Parameter param = nameParamPair.getSecond();
        if (param != null) {
            if (!param.validateMatchesAttributes(paramNodeAttributes)) {
                ParameterParsingException exception = new ParameterParsingException(paramNodeAttributes, "Parameter attributes clash with existing parameter of the same name and scope!");
                if (loggingManager.canLog()) {
                    loggingManager.getLogger().error("Parameter " + param.getName() + " could not be parsed as it matches a parameter of the same name and scope but with conflicting attributes", exception);
                }
                throw exception;
            }
            return nameParamPair;
        }
        String name = null;
        if ("true".equals(paramNodeAttributes.get("referenced"))) {
            ParameterParsingException exception = new ParameterParsingException(paramNodeAttributes, "Referenced parameter does not exist in the calling template!");
            if (loggingManager.canLog()) {
                loggingManager.getLogger().error("Referenced paremeter " + paramName + " does not exist", exception);
            }
            throw exception;
        }
        if (parameterFactory.canCreateParameterType(type) && paramName != null) {
            name = paramName;
        }
        for (Map.Entry<String, String> entry : paramNodeAttributes.entrySet()) {
            if (!parameterFactory.canCreateParameterType(entry.getKey())) continue;
            name = paramNodeAttributes.get(entry.getKey());
            type = entry.getKey();
            break;
        }
        if (parameterFactory.canCreateParameterType(type)) {
            param = parameterFactory.createParameter(type, name, paramNodeAttributes, classificationAttrs);
            ParameterParsingHelper.addParameterToScope(paramNodeAttributes.get("scope"), parentParam, param, orphanedParameters, templateRootParameter == null ? rootParameter : templateRootParameter);
        }
        return new Pair<String, Parameter>(name, param);
    }

    public static ParentParameter getParentParameterFromScope(String scope, ParentParameter parentParam, ParentParameter rootParam) {
        if (scope != null) {
            ParentParameter currentParentParameter;
            StringTokenizer scopeTokenizer = new StringTokenizer(scope, ".", false);
            ParentParameter parentParameter = currentParentParameter = parentParam != null ? parentParam : rootParam;
            while (scopeTokenizer.hasMoreElements() && currentParentParameter != null) {
                String token = scopeTokenizer.nextToken();
                if (ROOT_SCOPE.equals(token)) {
                    currentParentParameter = rootParam;
                    continue;
                }
                Parameter nextParameter = currentParentParameter.getChildParameter(token);
                currentParentParameter = null;
                if (LoopParameter.class.isInstance(nextParameter) && ((LoopParameter)nextParameter).hasChildren()) {
                    nextParameter = ((LoopParameter)nextParameter).getParameters().get(0);
                }
                if (!ParentParameter.class.isInstance(nextParameter)) continue;
                currentParentParameter = (ParentParameter)nextParameter;
            }
            return currentParentParameter;
        }
        return parentParam;
    }

    public static void addParameterToScope(String scope, ParentParameter parentParam, Parameter param, List<ParameterScopeRecord> orphanedParameters, ParentParameter templateRootParameter) {
        ParentParameter parentParameter = ParameterParsingHelper.getParentParameterFromScope(scope, parentParam, templateRootParameter);
        if (parentParameter != null) {
            parentParameter.addChildParameter(param);
        } else if (orphanedParameters != null) {
            orphanedParameters.add(new ParameterScopeRecord(param, scope, parentParam));
        }
    }

    public static Parameter getReferencedParameterFromScope(String scope, String name, ParentParameter parentParam, ScopeParentParameter templateRootParameter, Map<String, Parameter> templateReferencedParameters) {
        Parameter referencedParameter = null;
        if (templateRootParameter != null && templateReferencedParameters != null) {
            if (scope != null) {
                if (scope.equals(ROOT_SCOPE)) {
                    referencedParameter = templateReferencedParameters.get(name);
                } else {
                    Parameter referencedScopeParameter;
                    String referencedName = scope;
                    int sepPos = scope.indexOf(46);
                    if (sepPos != -1) {
                        referencedName = scope.substring(0, sepPos);
                    }
                    if ((referencedScopeParameter = templateReferencedParameters.get(referencedName)) != null && sepPos != -1) {
                        String remainingScope = scope.substring(sepPos + 1);
                        if (ParentParameter.class.isInstance(referencedScopeParameter)) {
                            referencedScopeParameter = ParameterParsingHelper.getParameterFromRoot(remainingScope, name, (ParentParameter)referencedScopeParameter, templateRootParameter);
                        }
                    }
                    if (referencedScopeParameter != null && ParentParameter.class.isInstance(referencedScopeParameter)) {
                        referencedParameter = ((ParentParameter)referencedScopeParameter).getChildParameter(name);
                    }
                }
            } else if (parentParam.equals(templateRootParameter)) {
                referencedParameter = templateReferencedParameters.get(name);
            }
        }
        return referencedParameter;
    }

    public static Parameter getParameterFromScope(String scope, String name, ParentParameter parentParam, ParentParameter rootParam, ScopeParentParameter templateRootParameter) {
        ParentParameter root = templateRootParameter != null ? templateRootParameter : rootParam;
        return ParameterParsingHelper.getParameterFromRoot(scope, name, parentParam, root);
    }

    public static Parameter getParameterFromRoot(String scope, String name, ParentParameter parentParam, ParentParameter rootParam) {
        ParentParameter parentParameter = ParameterParsingHelper.getParentParameterFromScope(scope, parentParam, rootParam);
        if (parentParameter != null) {
            return parentParameter.getChildParameter(name);
        }
        return null;
    }

    public static Parameter mergeTrees(Parameter param1, Parameter param2, LoggingManager loggingManager) throws RAREException {
        if (param1 == null) {
            return param2.copy(loggingManager);
        }
        if (param2 == null) {
            return param1.copy(loggingManager);
        }
        String param1Name = param1.getName();
        String param2Name = param2.getName();
        if (param1.getClass().equals(param2.getClass()) && (param1Name == null && param2Name == null || param1.getName().equals(param2.getName()))) {
            if (ParentParameter.class.isInstance(param1)) {
                List<Parameter> childParameters;
                ParentParameter parentCopy = ((ParentParameter)param1).shallowCopy(true, loggingManager);
                if (((ParentParameter)param1).hasChildren()) {
                    childParameters = ((ParentParameter)param1).getParameters();
                    for (Parameter childParameter : childParameters) {
                        Parameter matchingChildParam = ((ParentParameter)param2).getChildParameter(childParameter.getName());
                        Parameter childParamCopy = matchingChildParam != null ? ParameterParsingHelper.mergeTrees(childParameter, matchingChildParam, loggingManager) : childParameter.copy(loggingManager);
                        parentCopy.addChildParameter(childParamCopy);
                    }
                }
                if (((ParentParameter)param2).hasChildren()) {
                    childParameters = ((ParentParameter)param2).getParameters();
                    for (Parameter childParameter : childParameters) {
                        if (((ParentParameter)param1).getChildParameter(childParameter.getName()) != null) continue;
                        parentCopy.addChildParameter(childParameter.copy(loggingManager));
                    }
                }
                return parentCopy;
            }
            return param1.copy(loggingManager);
        }
        RAREException exception = new RAREException("Parameter trees cannot be merged, as incompatible parameters: " + param1.getFullName() + ", " + param2.getFullName());
        if (loggingManager.canLog()) {
            loggingManager.getLogger().error("Error merging parameter trees as parameters " + param1Name + " conflict", exception);
        }
        throw exception;
    }
}

