/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.parameterparser;

import com.ibm.aurora.rare.IClassificationStreamer;
import com.ibm.aurora.rare.core.classification.ITemplateRepository;
import com.ibm.aurora.rare.core.exception.ParameterParsingException;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.exception.TemplateParsingException;
import com.ibm.aurora.rare.core.parameter.ConditionalParentParameter;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.ParentParameter;
import com.ibm.aurora.rare.core.parameter.ScopeParentParameter;
import com.ibm.aurora.rare.core.parameter.SubTemplateParameter;
import com.ibm.aurora.rare.core.parameter.VariableParameter;
import com.ibm.aurora.rare.core.parameter.VariationParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IConditionalParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IMultiResolvableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IScopeParameter;
import com.ibm.aurora.rare.core.parameter.parameterFactory.ParameterFactory;
import com.ibm.aurora.rare.core.parameterparser.ParameterParsingHelper;
import com.ibm.aurora.rare.core.parameterparser.ParameterScopeRecord;
import com.ibm.aurora.rare.core.template.ITemplate;
import com.ibm.aurora.rare.core.template.ParsedNode;
import com.ibm.aurora.rare.core.template.SubTemplateHandle;
import com.ibm.aurora.rare.core.template.Template;
import com.ibm.aurora.rare.core.utils.XMLHelperD4J;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class ParameterTreeReader {
    private final ParameterFactory mParameterFactory;
    private final ITemplateRepository mTemplateRepository;
    private final IClassificationStreamer mClassificationStreamer;
    private final Collection<Template> mTemplates;
    private final Map<String, ParentParameter> mUsedTrees;
    private ScopeParentParameter mRootParameter = null;
    private String mRootTemplateId = null;
    private final LoggingManager mLoggingManager;

    public ParameterTreeReader(ITemplateRepository templateRepository, IClassificationStreamer classificationStreamer, ParameterFactory parameterFactory, Collection<Template> templates, Map<String, ParentParameter> usedTrees, LoggingManager loggingManager) {
        this.mTemplateRepository = templateRepository;
        this.mClassificationStreamer = classificationStreamer;
        this.mParameterFactory = parameterFactory;
        this.mTemplates = templates;
        this.mUsedTrees = usedTrees;
        this.mLoggingManager = loggingManager;
    }

    public ScopeParentParameter getVisParameterTree(Map<String, Set<String>> classificationAttrs, String rootTemplateId, ParsedNode parseRoot, ParentParameter baseParameterTree) throws RAREException {
        this.mRootParameter = baseParameterTree != null ? new ScopeParentParameter(baseParameterTree, false) : new ScopeParentParameter((String)null);
        this.mRootParameter.setClassificationAttribute(classificationAttrs);
        this.mRootParameter.setTreeRoot(true);
        this.mRootTemplateId = rootTemplateId;
        this.parseParametersFromRoot(classificationAttrs, parseRoot, this.mRootParameter, null, new HashMap<String, SubTemplateParameter>(), null);
        return this.mRootParameter;
    }

    private void parseParametersFromRoot(Map<String, Set<String>> classificationAttrs, ParsedNode templateRoot, ParentParameter parentParameter, SubTemplateHandle currentTemplate, Map<String, SubTemplateParameter> templateRootParameters, Map<String, Parameter> templateReferencedParameters) throws RAREException {
        ParsedNode payload;
        ParsedNode validation;
        ParsedNode score;
        List<ParameterScopeRecord> orphanedParameters = new ArrayList<ParameterScopeRecord>();
        ParsedNode parameters = templateRoot.getChildElement("definition");
        if (parameters != null) {
            this.parseParameterList(classificationAttrs, parameters, parentParameter, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
        }
        if ((score = templateRoot.getChildElement("scoring")) != null) {
            this.parseParameterList(classificationAttrs, score, parentParameter, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
        }
        if ((validation = templateRoot.getChildElement("validation")) != null) {
            this.parseParameterList(classificationAttrs, validation, parentParameter, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
        }
        if ((payload = templateRoot.getChildElement("payload")) != null) {
            this.parseParameterList(classificationAttrs, payload, parentParameter, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
        }
        if (currentTemplate == null) {
            for (Template template : this.mTemplates) {
                this.parseParameterList(classificationAttrs, template.getTemplateRoot(), parentParameter, orphanedParameters, null, templateRootParameters, templateReferencedParameters);
            }
        }
        orphanedParameters = this.addAllOrphanedParameters(orphanedParameters, parentParameter);
    }

    private void parseParameterList(Map<String, Set<String>> classificationAttrs, ParsedNode node, ParentParameter parentParam, List<ParameterScopeRecord> orphanedParameters, SubTemplateHandle currentTemplate, Map<String, SubTemplateParameter> templateRootParameters, Map<String, Parameter> templateReferencedParameters) throws RAREException {
        for (ParsedNode templateChildNode : node.getChildNodes()) {
            if (templateChildNode.getNodeType() != 1) continue;
            if (templateChildNode.inTemplateNamespace() && !"then".equals(templateChildNode.getNodeName()) && !"else".equals(templateChildNode.getNodeName())) {
                HashMap<String, String> attributes;
                ScopeParentParameter templateRootParameter = ParameterParsingHelper.getRootParameterFromTemplateHandle(currentTemplate, templateRootParameters);
                String localNodeName = templateChildNode.getNodeName();
                if ("callSubTemplate".equals(templateChildNode.getNodeName())) {
                    this.parseSubTemplate(classificationAttrs, templateChildNode, parentParam, currentTemplate, templateRootParameters, templateReferencedParameters);
                    continue;
                }
                if (localNodeName.equals("scope") || localNodeName.equals("loop")) {
                    Parameter scopeParam = ParameterParsingHelper.extractParameter(classificationAttrs, templateChildNode, null, parentParam, orphanedParameters, this.mRootParameter, templateRootParameter, templateReferencedParameters, this.mParameterFactory, this.mLoggingManager).getSecond();
                    if (ParentParameter.class.isInstance(scopeParam)) {
                        this.parseParameterList(classificationAttrs, templateChildNode, (ParentParameter)scopeParam, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
                        continue;
                    }
                    attributes = new HashMap<String, String>();
                    attributes.put("name", scopeParam.getFullName());
                    ParameterParsingException exception = new ParameterParsingException(attributes, "Scope tag referencing a non parent parameter!");
                    if (this.mLoggingManager.canLog()) {
                        this.mLoggingManager.getLogger().error("Scope tag references a leaf level parameter " + scopeParam.getName(), exception);
                    }
                    throw exception;
                }
                if (localNodeName.equals("switch")) {
                    Parameter variationsParam = ParameterParsingHelper.extractParameter(classificationAttrs, templateChildNode, null, parentParam, orphanedParameters, this.mRootParameter, templateRootParameter, templateReferencedParameters, this.mParameterFactory, this.mLoggingManager).getSecond();
                    if (VariableParameter.class.isInstance(variationsParam)) {
                        this.parseParameterList(classificationAttrs, templateChildNode, (ParentParameter)variationsParam, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
                        continue;
                    }
                    attributes = new HashMap();
                    attributes.put("name", variationsParam.getFullName());
                    ParameterParsingException exception = new ParameterParsingException(attributes, "Switch tag referencing a non Variations parameter!");
                    if (this.mLoggingManager.canLog()) {
                        this.mLoggingManager.getLogger().error("Switch tag references a non variations parameter " + variationsParam.getName(), exception);
                    }
                    throw exception;
                }
                if (VariableParameter.class.isInstance(parentParam) && localNodeName.equals("case")) {
                    Parameter variationParam = ParameterParsingHelper.extractParameter(classificationAttrs, templateChildNode, null, parentParam, orphanedParameters, this.mRootParameter, templateRootParameter, templateReferencedParameters, this.mParameterFactory, this.mLoggingManager).getSecond();
                    if (VariationParameter.class.isInstance(variationParam)) {
                        this.parseParameterList(classificationAttrs, templateChildNode, (ParentParameter)variationParam, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
                        continue;
                    }
                    attributes = new HashMap();
                    attributes.put("name", variationParam.getFullName());
                    ParameterParsingException exception = new ParameterParsingException(attributes, "Case tag referencing a non Variation parameter!");
                    if (this.mLoggingManager.canLog()) {
                        this.mLoggingManager.getLogger().error("Case tag references a non variation parameter " + variationParam.getName(), exception);
                    }
                    throw exception;
                }
                if (localNodeName.equals("reference")) {
                    ParameterParsingException exception;
                    HashMap<String, String> attributes2;
                    String scope = templateChildNode.getAttribute("scope");
                    ParentParameter scopeParam = parentParam;
                    if (scope != null) {
                        scopeParam = ParameterParsingHelper.getParentParameterFromScope(scope, parentParam, this.mRootParameter);
                    }
                    String extendsClass = templateChildNode.getAttribute("name");
                    if (ParentParameter.class.isInstance(scopeParam)) {
                        if (this.mUsedTrees.containsKey(extendsClass)) {
                            ParentParameter extendClassParameterTree = this.mUsedTrees.get(extendsClass);
                            for (Parameter extendedChild : extendClassParameterTree.getParameters()) {
                                scopeParam.addChildParameter(extendedChild.copy(this.mLoggingManager));
                            }
                            continue;
                        }
                        attributes2 = new HashMap();
                        attributes2.put("name", extendsClass);
                        exception = new ParameterParsingException(attributes2, "reference tag referencing a non existant class!");
                        if (this.mLoggingManager.canLog()) {
                            this.mLoggingManager.getLogger().error("The class " + extendsClass + " referenced by an reference tag does not exist ", exception);
                        }
                        throw exception;
                    }
                    attributes2 = new HashMap<String, String>();
                    attributes2.put("name", extendsClass);
                    exception = new ParameterParsingException(attributes2, "reference tag referencing a non existant scope, or a scope that is not a parentParameter!");
                    if (this.mLoggingManager.canLog()) {
                        this.mLoggingManager.getLogger().error("reference tag references a leaf level parameter " + parentParam.getName() + "." + scope, exception);
                    }
                    throw exception;
                }
                if (localNodeName.equals("if")) {
                    Parameter conditionParam = ParameterParsingHelper.extractParameter(classificationAttrs, templateChildNode, null, parentParam, orphanedParameters, this.mRootParameter, templateRootParameter, templateReferencedParameters, this.mParameterFactory, this.mLoggingManager).getSecond();
                    if (IConditionalParameter.class.isInstance(conditionParam) || IMultiResolvableParameter.class.isInstance(conditionParam)) {
                        List<ParsedNode> containedNodes = templateChildNode.getChildNodes();
                        boolean hasElse = false;
                        boolean alreadyProcessed = false;
                        if (!containedNodes.isEmpty()) {
                            int idx = 0;
                            int numNodes = containedNodes.size();
                            ParsedNode childNode = containedNodes.get(idx++);
                            while (idx < numNodes && childNode.getNodeType() != 1) {
                                childNode = containedNodes.get(idx++);
                            }
                            String childNodeName = childNode.getNodeName();
                            if ("then".equals(childNodeName)) {
                                if (ConditionalParentParameter.class.isInstance(conditionParam)) {
                                    this.parseParameterList(classificationAttrs, childNode, (ParentParameter)conditionParam, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
                                    alreadyProcessed = true;
                                }
                                for (ParsedNode containedChildNode : containedNodes) {
                                    if (!"else".equals(containedChildNode.getNodeName())) continue;
                                    hasElse = true;
                                    if (!ConditionalParentParameter.class.isInstance(conditionParam)) break;
                                    ParentParameter elseParam = new ParentParameter("else");
                                    elseParam.setAttribute("isElse", "true");
                                    ((ConditionalParentParameter)conditionParam).setElse(elseParam);
                                    this.parseParameterList(classificationAttrs, containedChildNode, elseParam, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
                                    break;
                                }
                            }
                        }
                        conditionParam.setAttribute("hasElse", hasElse ? "true" : "false");
                        if (alreadyProcessed) continue;
                        if (ParentParameter.class.isInstance(conditionParam) && IConditionalParameter.class.isInstance(conditionParam)) {
                            this.parseParameterList(classificationAttrs, templateChildNode, (ParentParameter)conditionParam, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
                            continue;
                        }
                        this.parseParameterList(classificationAttrs, templateChildNode, parentParam, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
                        continue;
                    }
                    attributes = new HashMap();
                    attributes.put("name", conditionParam.getFullName());
                    ParameterParsingException exception = new ParameterParsingException(attributes, "if tag referencing a non condition parameter!");
                    if (this.mLoggingManager.canLog()) {
                        this.mLoggingManager.getLogger().error("If tag references a non conditional parameter " + conditionParam.getName(), exception);
                    }
                    throw exception;
                }
                if (localNodeName.equals("ifexists")) {
                    Parameter foundParam = ParameterParsingHelper.findParameter(templateChildNode, null, parentParam, this.mRootParameter, templateRootParameter, templateReferencedParameters, this.mParameterFactory).getSecond();
                    if (foundParam == null) continue;
                    this.parseParameterList(classificationAttrs, templateChildNode, parentParam, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
                    continue;
                }
                List<String> paramNames = templateChildNode.getAttributeAsPropertyList("name");
                if (paramNames == null) {
                    paramNames = Arrays.asList(UUID.randomUUID().toString());
                }
                for (String paramName : paramNames) {
                    Parameter param = ParameterParsingHelper.extractParameter(classificationAttrs, templateChildNode, paramName, parentParam, orphanedParameters, this.mRootParameter, templateRootParameter, templateReferencedParameters, this.mParameterFactory, this.mLoggingManager).getSecond();
                    if (param != null) {
                        if (ParentParameter.class.isInstance(param)) {
                            this.parseParameterList(classificationAttrs, templateChildNode, (ParentParameter)param, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
                            continue;
                        }
                        if (IScopeParameter.class.isInstance(param)) continue;
                        this.parseParameterList(classificationAttrs, templateChildNode, parentParam, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
                        continue;
                    }
                    HashMap<String, String> attributes3 = new HashMap<String, String>();
                    attributes3.put("name", paramName);
                    ParameterParsingException exception = new ParameterParsingException(attributes3, "No valid parameter can be found or created that can be applied to template element: " + templateChildNode.toString());
                    if (this.mLoggingManager.canLog()) {
                        this.mLoggingManager.getLogger().error("No valid parameter can be found or created that can be applied to template element: " + templateChildNode.toString(), exception);
                    }
                    throw exception;
                }
                continue;
            }
            this.parseParameterList(classificationAttrs, templateChildNode, parentParam, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
        }
    }

    private void parseSubTemplate(Map<String, Set<String>> classificationAttrs, ParsedNode subTemplateNode, ParentParameter param, SubTemplateHandle currentTemplate, Map<String, SubTemplateParameter> templateRootParameters, Map<String, Parameter> templateReferencedParameters) throws RAREException {
        String subTemplateName = subTemplateNode.getAttribute("name");
        SubTemplateHandle subTemplateHandle = currentTemplate != null ? this.getSubTemplate(subTemplateName, currentTemplate) : this.getSubTemplate(subTemplateName, this.mRootTemplateId);
        if (subTemplateHandle == null) {
            TemplateParsingException exception = new TemplateParsingException("Template (" + this.mRootTemplateId + "), CallTemplate node references invalid subtemplate: " + subTemplateName);
            if (this.mLoggingManager.canLog()) {
                this.mLoggingManager.getLogger().error("Template (" + this.mRootTemplateId + "), CallTemplate node references invalid subtemplate:" + subTemplateName, exception);
            }
            throw exception;
        }
        List<Map<String, String>> subTemplateCallParameterReferences = ParameterParsingHelper.getSubTemplateCallParameterReferences(subTemplateNode, this.mLoggingManager);
        Map<String, Parameter> subTemplateReferencedParameters = ParameterParsingHelper.getReferencedTemplateParameters(subTemplateCallParameterReferences, param, (ParentParameter)this.mRootParameter, ParameterParsingHelper.getRootParameterFromTemplateHandle(currentTemplate, templateRootParameters), templateReferencedParameters, this.mParameterFactory, this.mLoggingManager);
        StringBuilder subTemplateLookupKey = new StringBuilder(subTemplateHandle.getName() + "-");
        for (Parameter referencedParam : subTemplateReferencedParameters.values()) {
            subTemplateLookupKey.append(referencedParam.hashCode() + ",");
        }
        String templateName = subTemplateHandle.getName();
        SubTemplateParameter templateRootParameter = templateRootParameters.get(templateName);
        if (templateRootParameter == null || templateRootParameters.get(subTemplateLookupKey.toString()) == null) {
            templateRootParameter = new SubTemplateParameter(templateName);
            templateRootParameters.put(templateName, templateRootParameter);
            templateRootParameters.put(subTemplateLookupKey.toString(), templateRootParameter);
            this.parseParametersFromRoot(classificationAttrs, subTemplateHandle.getRoot(), templateRootParameter, subTemplateHandle, templateRootParameters, subTemplateReferencedParameters);
        }
        param.addChildParameter(templateRootParameter);
    }

    private List<ParameterScopeRecord> addAllOrphanedParameters(List<ParameterScopeRecord> orphanedParameters, ParentParameter rootParam) {
        List<ParameterScopeRecord> parameters = orphanedParameters;
        boolean processedSome = true;
        while (!parameters.isEmpty() && processedSome) {
            processedSome = false;
            ArrayList<ParameterScopeRecord> remainingOrphanedParameters = new ArrayList<ParameterScopeRecord>();
            for (ParameterScopeRecord paramScopeRec : parameters) {
                ParentParameter parentParameter = ParameterParsingHelper.getParentParameterFromScope(paramScopeRec.getScopePath(), paramScopeRec.getParent(), rootParam);
                if (parentParameter != null) {
                    parentParameter.addChildParameter(paramScopeRec.getParameter());
                    processedSome = true;
                    continue;
                }
                remainingOrphanedParameters.add(paramScopeRec);
            }
            parameters = remainingOrphanedParameters;
        }
        return parameters;
    }

    private SubTemplateHandle getSubTemplate(String name, SubTemplateHandle currentTemplate) throws RAREException {
        return this.getSubTemplate(name, currentTemplate.getId());
    }

    private SubTemplateHandle getSubTemplate(String name, String currentTemplateId) throws RAREException {
        try {
            return this.mTemplateRepository.getSubTemplateHandle(name, currentTemplateId, this.newTemplateFactoryForSubTemplate(name, currentTemplateId));
        }
        catch (IOException e) {
            RAREException exception = new RAREException("failed loading sub template " + name + " " + currentTemplateId, e);
            if (this.mLoggingManager.canLog()) {
                this.mLoggingManager.getLogger().error("Subtemplate " + name + " " + currentTemplateId + " could not be loaded", exception);
            }
            throw exception;
        }
    }

    private ITemplateRepository.ITemplateFactory newTemplateFactoryForSubTemplate(String name, String currentTemplateId) {
        final String templateId = this.mTemplateRepository.getReferencedTemplateName(name, currentTemplateId);
        ITemplate currentTemplate = this.mTemplateRepository.getTemplate(templateId);
        final boolean suppressWhiteSpace = currentTemplate != null && Template.class.isInstance(currentTemplate) ? ((Template)currentTemplate).suppressWhiteSpaceContent() : false;
        return new ITemplateRepository.ITemplateFactory(){

            @Override
            public Template createTemplate() throws RAREException, IOException {
                return new Template(templateId, XMLHelperD4J.parseXMLStream(ParameterTreeReader.this.mClassificationStreamer.getTemplateStream(templateId)), ParameterTreeReader.this.mParameterFactory, ParameterTreeReader.this.mTemplateRepository, ParameterTreeReader.this.mClassificationStreamer, ParameterTreeReader.this.mLoggingManager, suppressWhiteSpace);
            }
        };
    }
}

