/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.rule;

import com.ibm.aurora.rare.core.rule.IBooleanRule;
import com.ibm.aurora.rare.core.rule.IInputScopeObjectRule;
import com.ibm.aurora.rare.core.rule.INumericRule;
import com.ibm.aurora.rare.core.rule.IRule;
import com.ibm.aurora.rare.core.rule.IRulesLoader;
import com.ibm.aurora.rare.core.rule.IStringRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RulesLibrary {
    private final Map<String, IRule<?>> mRules = new HashMap();

    public void load(IRulesLoader loader) throws Exception {
        Map<String, IRule<?>> newRules = loader.loadRules();
        this.mRules.putAll(newRules);
    }

    public void add(String id, IRule<?> rule) {
        this.mRules.put(id, rule);
    }

    public IRule<?> get(String id) {
        return this.mRules.get(id);
    }

    public List<IBooleanRule> getBooleanRules() {
        ArrayList<IBooleanRule> rules = new ArrayList<IBooleanRule>();
        for (IRule<?> rule : this.mRules.values()) {
            if (!(rule instanceof IBooleanRule)) continue;
            rules.add((IBooleanRule)rule);
        }
        return rules;
    }

    public List<INumericRule> getNumericRules() {
        ArrayList<INumericRule> rules = new ArrayList<INumericRule>();
        for (IRule<?> rule : this.mRules.values()) {
            if (!(rule instanceof INumericRule)) continue;
            rules.add((INumericRule)rule);
        }
        return rules;
    }

    public List<IStringRule> getStringRules() {
        ArrayList<IStringRule> rules = new ArrayList<IStringRule>();
        for (IRule<?> rule : this.mRules.values()) {
            if (!(rule instanceof IStringRule)) continue;
            rules.add((IStringRule)rule);
        }
        return rules;
    }

    public List<IInputScopeObjectRule> getInputScopeRules() {
        ArrayList<IInputScopeObjectRule> rules = new ArrayList<IInputScopeObjectRule>();
        for (IRule<?> rule : this.mRules.values()) {
            if (!(rule instanceof IInputScopeObjectRule)) continue;
            rules.add((IInputScopeObjectRule)rule);
        }
        return rules;
    }

    public IBooleanRule getBooleanRule(String id) {
        IRule<?> rule = this.mRules.get(id);
        if (rule instanceof IBooleanRule) {
            return (IBooleanRule)rule;
        }
        return null;
    }

    public INumericRule getNumericRule(String id) {
        IRule<?> rule = this.mRules.get(id);
        if (rule instanceof INumericRule) {
            return (INumericRule)rule;
        }
        return null;
    }

    public IStringRule getStringRule(String id) {
        IRule<?> rule = this.mRules.get(id);
        if (rule instanceof IStringRule) {
            return (IStringRule)rule;
        }
        return null;
    }

    public IInputScopeObjectRule getInputScopeObjectRule(String id) {
        IRule<?> rule = this.mRules.get(id);
        if (rule instanceof IInputScopeObjectRule) {
            return (IInputScopeObjectRule)rule;
        }
        return null;
    }

    public void clear() {
        this.mRules.clear();
    }
}

