/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.rule.impl;

import com.ibm.aurora.rare.core.rule.IRule;
import com.ibm.aurora.rare.core.rule.IRulesLoader;
import com.ibm.aurora.rare.core.rule.impl.IRuleFactory;
import com.ibm.aurora.rare.core.rule.impl.JavaRuleFactory;
import com.ibm.aurora.rare.core.utils.XMLHelperD4J;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XMLRulesLoader
implements IRulesLoader {
    private static final String REFERANCE_ATTRIBUTE = "ref";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ID_ATTRIBUTE = "id";
    private static final String RULE_ELEMENT = "rule";
    private static final String ROOT_ELEMENT = "rules";
    private final InputStream mInputStream;
    private final IRuleFactory mFactory;

    public XMLRulesLoader(InputStream stream) {
        this(stream, new JavaRuleFactory());
    }

    public XMLRulesLoader(InputStream stream, IRuleFactory factory) {
        this.mInputStream = stream;
        this.mFactory = factory;
    }

    @Override
    public Map<String, IRule<?>> loadRules() throws Exception {
        LinkedHashMap rules = new LinkedHashMap();
        if (this.mInputStream != null) {
            LinkedHashMap<String, RuleDef> rulesDef = new LinkedHashMap<String, RuleDef>();
            Element eRules = XMLHelperD4J.parseXMLStream(this.mInputStream);
            if (eRules != null && eRules.getName().equals(ROOT_ELEMENT)) {
                Iterator childItr = eRules.elementIterator(RULE_ELEMENT);
                while (childItr.hasNext()) {
                    Element eRule = (Element)childItr.next();
                    RuleDef r = this.createRuleDef(eRule);
                    if (r == null) continue;
                    rulesDef.put(r.mId, r);
                }
                this.convertRules(rules, rulesDef);
            }
        } else {
            throw new IOException("Resource not found");
        }
        return rules;
    }

    private RuleDef createRuleDef(Element eRule) {
        Map<String, String> attrs = this.extractAttributes(eRule.attributes());
        String id = attrs.remove(ID_ATTRIBUTE);
        if (id != null) {
            String className = attrs.remove(CLASS_ATTRIBUTE);
            if (className == null) {
                String ref = attrs.remove(REFERANCE_ATTRIBUTE);
                if (ref != null) {
                    return new RuleDef(id, null, ref, attrs);
                }
            } else {
                return new RuleDef(id, className, null, attrs);
            }
        }
        return null;
    }

    private void convertRules(Map<String, IRule<?>> rules, Map<String, RuleDef> rulesDef) throws Exception {
        for (Map.Entry<String, RuleDef> entry : rulesDef.entrySet()) {
            RuleDef def = entry.getValue();
            IRule<?> rule = null;
            if (def.mClass != null) {
                rule = this.mFactory.createRule(def.mClass);
            } else if (def.mRef != null && rulesDef.containsKey(def.mRef)) {
                RuleDef refDef = rulesDef.get(def.mRef);
                rule = this.mFactory.createRule(refDef.mClass);
                HashMap mergedAttrs = new HashMap(refDef.mAttrs);
                mergedAttrs.putAll(def.mAttrs);
                def.mAttrs = mergedAttrs;
            }
            if (rule == null) continue;
            rule.setProperties(def.mAttrs);
            rules.put(entry.getKey(), rule);
        }
    }

    private Map<String, String> extractAttributes(List<Attribute> attributes) {
        HashMap<String, String> all = new HashMap<String, String>();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attribute = attributes.get(i);
            all.put(attribute.getName(), attribute.getValue());
        }
        return all;
    }

    private final class RuleDef {
        private final String mId;
        private final String mClass;
        private final String mRef;
        private Map<String, String> mAttrs;

        private RuleDef(String id, String className, String ref, Map<String, String> attributes) {
            this.mId = id;
            this.mClass = className;
            this.mRef = ref;
            this.mAttrs = attributes;
        }
    }
}

