/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.score;

import com.ibm.aurora.rare.core.score.Score;
import com.ibm.aurora.rare.core.score.ScoreRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ScoringRec {
    private float mScore;
    private List<String> mDescriptions;

    public ScoringRec() {
        this.mDescriptions = new ArrayList<String>();
        this.mScore = 0.0f;
    }

    public ScoringRec(Score score) {
        if (score != null) {
            this.mDescriptions = new ArrayList<String>();
            this.mScore = score.getScore();
            List<ScoreRecord> scoreRecords = score.getDescribedScores();
            if (score.getDescribedScores() != null) {
                Collections.sort(scoreRecords);
                for (ScoreRecord scoreRecord : scoreRecords) {
                    String scoreDescription;
                    float currentScore = scoreRecord.getScore();
                    if (Float.isNaN(currentScore) || currentScore == 0.0f || (scoreDescription = scoreRecord.getScoreDescription()) == null || this.mDescriptions.contains(scoreDescription)) continue;
                    this.mDescriptions.add(scoreDescription);
                }
            }
        }
    }

    public final float getScore() {
        return this.mScore;
    }

    public final List<String> getScoreDescriptions() {
        return this.mDescriptions;
    }
}

