/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.template;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class IndexListParser {
    private List<String> mIndexes = new ArrayList<String>();

    public IndexListParser(String indexes) {
        StringTokenizer indexTokenizer = new StringTokenizer(indexes, ",", false);
        while (indexTokenizer.hasMoreElements()) {
            this.mIndexes.add(indexTokenizer.nextToken());
        }
    }

    public int[] getIndexList(int length) {
        int estimatedSize = this.countIndexes(length);
        int[] indexList = new int[estimatedSize];
        int idx = 0;
        for (String index : this.mIndexes) {
            int currentIndex;
            if (index.charAt(0) == '[') {
                for (currentIndex = this.getFirstIndexFromRange(index, length); currentIndex <= this.getLastIndexFromRange(index, length); ++currentIndex) {
                    if (currentIndex < 0 || currentIndex >= length) continue;
                    indexList[idx++] = currentIndex;
                }
                continue;
            }
            currentIndex = this.parseIndex(index, length);
            if (currentIndex < 0 || currentIndex >= length) continue;
            indexList[idx++] = currentIndex;
        }
        if (estimatedSize != idx) {
            int[] sizedIndexList = new int[idx];
            System.arraycopy(indexList, 0, sizedIndexList, 0, idx);
            indexList = sizedIndexList;
        }
        return indexList;
    }

    private int countIndexes(int length) {
        int numIndexes = 0;
        for (String index : this.mIndexes) {
            if (index.charAt(0) == '[') {
                numIndexes += this.getLastIndexFromRange(index, length) - this.getFirstIndexFromRange(index, length) + 1;
                continue;
            }
            ++numIndexes;
        }
        return numIndexes;
    }

    private int getFirstIndexFromRange(String range, int length) {
        return this.parseIndex(range.substring(1, range.indexOf(58)), length);
    }

    private int getLastIndexFromRange(String range, int length) {
        return this.parseIndex(range.substring(range.indexOf(58) + 1, range.length() - 1), length);
    }

    private int parseIndex(String index, int length) {
        int parsedIndex = Integer.valueOf(index);
        if (parsedIndex < 0) {
            parsedIndex = length + parsedIndex;
        }
        return parsedIndex;
    }
}

