/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.template;

import com.ibm.aurora.rare.core.parameterparser.ParameterParsingHelper;
import com.ibm.aurora.rare.core.template.IndexListParser;
import com.ibm.aurora.rare.core.utils.XMLHelperD4J;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;

public class ParsedNode {
    public static final short ELEMENT_NODE = 1;
    public static final short TEXT_NODE = 3;
    public static final short CDATA_SECTION_NODE = 4;
    public static final String CDATA_SECTION_OPEN = "<![CDATA[";
    public static final String CDATA_SECTION_CLOSE = "]]>";
    private final boolean mInTemplateNamespace;
    private final String mNamespacePrefix;
    private final short mNodeType;
    private final String mNodeName;
    private final List<ParsedNode> mChildNodeList;
    private final Map<String, ParsedNode> mChildElementMap;
    private final Map<String, String> mAttributeMap;
    private final String mTextContent;
    private final boolean mTrimmedTextContentEmpty;
    private final String mTagToStringOpen;
    private final String mTagToStringClose;
    private final IndexListParser mIndexListParser;
    private final String mDeclaredNamespaces;
    private Map<String, List<String>> mAttributesAsPropertyList;

    public ParsedNode(String namespacePrefix, Element node) {
        this(namespacePrefix, (Node)node, null, null, null);
    }

    private ParsedNode(String namespacePrefix, Node node, String textContent, String tagToStringOpen, String tagToStringClose) {
        boolean isElement = node.getNodeType() == 1;
        this.mInTemplateNamespace = isElement ? XMLHelperD4J.checkNamespace((Element)node, namespacePrefix) : false;
        this.mNamespacePrefix = namespacePrefix;
        this.mTextContent = textContent;
        this.mTagToStringOpen = tagToStringOpen;
        this.mTagToStringClose = tagToStringClose;
        this.mNodeType = node.getNodeType();
        this.mNodeName = XMLHelperD4J.getNodeName(node);
        if (null == textContent && isElement) {
            this.mDeclaredNamespaces = XMLHelperD4J.getDeclaredNamespaces((Element)node);
            this.mChildNodeList = ParsedNode.buildChildNodeList(namespacePrefix, (Element)node);
            this.mChildElementMap = ParsedNode.buildChildElementMap(this.mChildNodeList);
            this.mAttributeMap = null == tagToStringOpen && null == tagToStringClose ? XMLHelperD4J.getAttributesFromNode((Element)node) : null;
        } else {
            this.mChildNodeList = null;
            this.mChildElementMap = null;
            this.mAttributeMap = null;
            this.mDeclaredNamespaces = null;
        }
        this.mTrimmedTextContentEmpty = null != textContent ? textContent.trim().isEmpty() : true;
        this.mIndexListParser = this.mAttributeMap != null && this.mAttributeMap.containsKey("indexes") ? new IndexListParser(this.mAttributeMap.get("indexes")) : null;
        this.mAttributesAsPropertyList = null;
    }

    public short getNodeType() {
        return this.mNodeType;
    }

    public String getNodeName() {
        return this.mNodeName;
    }

    public boolean inTemplateNamespace() {
        return this.mInTemplateNamespace;
    }

    public List<ParsedNode> getChildNodes() {
        return this.mChildNodeList;
    }

    public ParsedNode getChildElement(String name) {
        return this.mChildElementMap.get(name);
    }

    public Map<String, String> getAttributes() {
        return this.mAttributeMap;
    }

    public String getAttribute(String name) {
        return this.mAttributeMap.get(name);
    }

    public List<String> getAttributeAsPropertyList(String attribute) {
        List<String> result;
        if (null == this.mAttributesAsPropertyList) {
            this.mAttributesAsPropertyList = Collections.synchronizedMap(new HashMap());
        }
        if (null == (result = this.mAttributesAsPropertyList.get(attribute))) {
            result = ParameterParsingHelper.getPropertyListFromNodeAttribute(this.getAttribute(attribute));
            this.mAttributesAsPropertyList.put(attribute, result);
        }
        return result;
    }

    public String getTextContent() {
        return this.mTextContent;
    }

    public boolean isTrimmedTextContentEmpty() {
        return this.mTrimmedTextContentEmpty;
    }

    public String getTagToStringOpen() {
        return this.mTagToStringOpen;
    }

    public String getTagToStringClose() {
        return this.mTagToStringClose;
    }

    public IndexListParser getIndexListParser() {
        return this.mIndexListParser;
    }

    public void toStringBuilder(StringBuilder sb) {
        if (null == this.mTextContent) {
            if (null == this.mTagToStringOpen) {
                sb.append('<');
                this.appendNamespacePrefix(sb);
                sb.append(this.mNodeName);
                this.appendDeclaredNamespaces(sb);
                if (null != this.mAttributeMap) {
                    for (Map.Entry entry : this.mAttributeMap.entrySet()) {
                        sb.append(' ').append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append('\"');
                    }
                }
                sb.append('>');
            } else {
                sb.append(this.mTagToStringOpen);
            }
            if (null != this.mChildNodeList) {
                for (ParsedNode parsedNode : this.mChildNodeList) {
                    parsedNode.toStringBuilder(sb);
                }
            }
            if (null == this.mTagToStringClose) {
                sb.append("</");
                this.appendNamespacePrefix(sb);
                sb.append(this.mNodeName).append('>');
            } else {
                sb.append(this.mTagToStringClose);
            }
        } else {
            if (null != this.mTagToStringOpen) {
                sb.append(this.mTagToStringOpen);
            }
            sb.append(this.mTextContent);
            if (null != this.mTagToStringClose) {
                sb.append(this.mTagToStringClose);
            }
        }
    }

    private void appendDeclaredNamespaces(StringBuilder sb) {
        if (null != this.mDeclaredNamespaces && !this.mDeclaredNamespaces.isEmpty()) {
            sb.append(this.mDeclaredNamespaces);
        }
    }

    private void appendNamespacePrefix(StringBuilder sb) {
        if (null != this.mNamespacePrefix && !this.mNamespacePrefix.isEmpty()) {
            sb.append(this.mNamespacePrefix).append(':');
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(sb);
        return sb.toString();
    }

    private static List<ParsedNode> buildChildNodeList(String namespacePrefix, Element node) {
        ArrayList<ParsedNode> result = new ArrayList<ParsedNode>();
        Iterator childItr = node.nodeIterator();
        while (childItr.hasNext()) {
            Node childNode = (Node)childItr.next();
            short nodeType = childNode.getNodeType();
            if (nodeType == 1) {
                Element elementChild = (Element)childNode;
                if (XMLHelperD4J.checkNamespace(elementChild, namespacePrefix)) {
                    result.add(new ParsedNode(namespacePrefix, elementChild));
                    continue;
                }
                result.add(new ParsedNode(namespacePrefix, (Node)elementChild, null, XMLHelperD4J.tagToStringOpen(elementChild), XMLHelperD4J.tagToStringClose(elementChild)));
                continue;
            }
            if (nodeType == 3) {
                result.add(new ParsedNode(namespacePrefix, childNode, childNode.getText(), null, null));
                continue;
            }
            if (nodeType != 4) continue;
            result.add(new ParsedNode(namespacePrefix, childNode, childNode.getText(), CDATA_SECTION_OPEN, CDATA_SECTION_CLOSE));
        }
        return result;
    }

    private static Map<String, ParsedNode> buildChildElementMap(List<ParsedNode> childNodeList) {
        HashMap<String, ParsedNode> result = new HashMap<String, ParsedNode>();
        for (ParsedNode childNode : childNodeList) {
            if (childNode.getNodeType() != 1) continue;
            result.put(childNode.getNodeName(), childNode);
        }
        return result;
    }
}

