/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.template;

import com.ibm.aurora.rare.IClassificationStreamer;
import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.classification.ITemplateRepository;
import com.ibm.aurora.rare.core.exception.ParameterCreationException;
import com.ibm.aurora.rare.core.exception.ParameterResolutionException;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.exception.TemplateParsingException;
import com.ibm.aurora.rare.core.exception.TemplateResolutionException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.parameter.ConditionalParentParameter;
import com.ibm.aurora.rare.core.parameter.DependentParameter;
import com.ibm.aurora.rare.core.parameter.LoopParameter;
import com.ibm.aurora.rare.core.parameter.MultiVariableParameter;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.ParentParameter;
import com.ibm.aurora.rare.core.parameter.ScopeParentParameter;
import com.ibm.aurora.rare.core.parameter.SubTemplateParameter;
import com.ibm.aurora.rare.core.parameter.VariableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IConditionalParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IResolvableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IScopeParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IValueParameter;
import com.ibm.aurora.rare.core.parameter.parameterFactory.ParameterFactory;
import com.ibm.aurora.rare.core.parameterparser.ParameterParsingHelper;
import com.ibm.aurora.rare.core.template.ITemplate;
import com.ibm.aurora.rare.core.template.ParsedNode;
import com.ibm.aurora.rare.core.template.SubTemplateHandle;
import com.ibm.aurora.rare.core.utils.JsonHelper;
import com.ibm.aurora.rare.core.utils.Pair;
import com.ibm.aurora.rare.core.utils.XMLHelperD4J;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class Template
implements ITemplate {
    private final String mId;
    private final ParsedNode mParsedTemplateRoot;
    private final ParameterFactory mParameterFactory;
    private final ITemplateRepository mTemplateRepository;
    private final IClassificationStreamer mClassificationStreamer;
    private final String mTemplateVersion;
    private final Map<String, SubTemplateHandle> mSubTemplates;
    private final LoggingManager mLoggingManager;
    private final boolean mSupressWhiteSpaceContent;

    public Template(String id, Element templateRoot, ParameterFactory parameterFactory, ITemplateRepository templateRepository, IClassificationStreamer classificationStreamer, LoggingManager loggingManager, boolean suppressWhiteSpaceContent) throws RAREException {
        this.mId = id;
        this.mLoggingManager = loggingManager;
        String templateNamespacePrefix = null;
        if (templateNamespacePrefix == null && (templateNamespacePrefix = XMLHelperD4J.lookupPrefix("http://developer.cognos.com/rare/xmlns/template/", templateRoot)) == null) {
            templateNamespacePrefix = XMLHelperD4J.lookupPrefix("http://developer.cognos.com/rare/xmlns/classification/", templateRoot);
        }
        this.mParsedTemplateRoot = new ParsedNode(templateNamespacePrefix, templateRoot);
        this.mParameterFactory = parameterFactory;
        this.mTemplateRepository = templateRepository;
        this.mClassificationStreamer = classificationStreamer;
        this.mTemplateVersion = Template.getVersion(templateRoot);
        this.verifyVersion();
        this.mSubTemplates = this.loadSubTemplates(this.mParsedTemplateRoot);
        this.mSupressWhiteSpaceContent = suppressWhiteSpaceContent;
    }

    public String getId() {
        return this.mId;
    }

    public boolean suppressWhiteSpaceContent() {
        return this.mSupressWhiteSpaceContent;
    }

    @Override
    public StringBuilder resolveTemplate(IVariationsInitializationHandle handle, ScopeParentParameter resolvedParameterTree) throws RAREException {
        StringBuilder stringBuilder = new StringBuilder();
        this.resolveTemplateNode(stringBuilder, handle, resolvedParameterTree, this.mParsedTemplateRoot);
        return stringBuilder;
    }

    private void resolveTemplateNode(StringBuilder stringBuilder, IVariationsInitializationHandle handle, ScopeParentParameter resolvedParameterTree, ParsedNode parsedNode) throws RAREException {
        this.resolveTemplateNodeChildren(stringBuilder, handle, resolvedParameterTree, parsedNode, new HashMap<String, SubTemplateParameter>(), null);
    }

    private void resolveTemplateNodeChildren(StringBuilder stringBuilder, IVariationsInitializationHandle handle, ScopeParentParameter resolvedParameterTree, ParsedNode parsedNode, Map<String, SubTemplateParameter> templateRootParameters, Map<String, Parameter> templateReferencedParameters) throws RAREException {
        this.resolveTemplateNodeList(stringBuilder, handle, parsedNode, resolvedParameterTree, resolvedParameterTree, null, templateRootParameters, templateReferencedParameters, resolvedParameterTree.getScope());
    }

    private void resolveTemplateNodeList(StringBuilder stringBuilder, IVariationsInitializationHandle handle, ParsedNode parsedNode, ParentParameter parentParam, ParentParameter rootParameter, SubTemplateHandle currentTemplate, Map<String, SubTemplateParameter> templateRootParameters, Map<String, Parameter> templateReferencedParameters, InputScopeObject currentScope) throws RAREException {
        for (ParsedNode templateChildNode : parsedNode.getChildNodes()) {
            if (templateChildNode.getNodeType() == 1) {
                if (templateChildNode.inTemplateNamespace()) {
                    TemplateResolutionException exception;
                    String localNodeName = templateChildNode.getNodeName();
                    if (localNodeName.equals("callSubTemplate")) {
                        this.resolveCallSubTemplateTag(stringBuilder, handle, templateChildNode, parentParam, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, currentScope);
                        continue;
                    }
                    Parameter param = this.extractParameterFromTemplateNode(handle, templateChildNode, parentParam, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, currentScope);
                    if (currentTemplate != null && DependentParameter.class.isInstance(param) && ((DependentParameter)param).isDependent()) {
                        this.resolveSubTemplateDependentParameters(handle, (DependentParameter)param, parentParam, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, currentScope);
                    }
                    InputScopeObject subScope = currentScope;
                    if (IScopeParameter.class.isInstance(param)) {
                        subScope = ((IScopeParameter)((Object)param)).getScope();
                    }
                    if (localNodeName.equals("valueof")) {
                        if (!IValueParameter.class.isInstance(param)) {
                            exception = new TemplateResolutionException("valueof tag references a parameter ( " + param.getName() + " ) that is not a ValueParameter. ", this.mId);
                            if (this.mLoggingManager.canLog()) {
                                this.mLoggingManager.getLogger().error("valueof tag references parameter " + param.getName() + " which is not a value parameter", exception);
                            }
                            throw exception;
                        }
                        this.resolveValueParameter(stringBuilder, templateChildNode, (IValueParameter)((Object)param));
                        continue;
                    }
                    if (localNodeName.equals("if")) {
                        if (!IConditionalParameter.class.isInstance(param) && !LoopParameter.class.isInstance(param)) {
                            exception = new TemplateResolutionException("if tag references a parameter ( " + param.getName() + " ) that is not a ConditionalParameter. ", this.mId);
                            if (this.mLoggingManager.canLog()) {
                                this.mLoggingManager.getLogger().error("if tag references parameter " + param.getName() + " which is not a conditional parameter", exception);
                            }
                            throw exception;
                        }
                        List<ParsedNode> containedNodes = templateChildNode.getChildNodes();
                        int idx = 0;
                        int numNodes = containedNodes.size();
                        ParsedNode childNode = containedNodes.get(idx++);
                        while (idx < numNodes && childNode.getNodeType() != 1) {
                            childNode = containedNodes.get(idx++);
                        }
                        String childNodeName = childNode.getNodeName();
                        if ("then".equals(childNodeName)) {
                            for (ParsedNode containedChildNode : containedNodes) {
                                if (containedChildNode.getNodeType() != 1) continue;
                                if ("then".equals(containedChildNode.getNodeName())) {
                                    this.resolveIfStatement(stringBuilder, handle, containedChildNode, param, parentParam, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, subScope, false);
                                    continue;
                                }
                                if ("else".equals(containedChildNode.getNodeName())) {
                                    this.resolveIfStatement(stringBuilder, handle, containedChildNode, param, parentParam, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, subScope, true);
                                    continue;
                                }
                                TemplateResolutionException exception2 = new TemplateResolutionException("if statement with first child (then) contains invalid child node (only then or else allowed)", this.mId);
                                if (this.mLoggingManager.canLog()) {
                                    this.mLoggingManager.getLogger().error("if tag has a non recognized child tag " + containedChildNode.getNodeName(), exception2);
                                }
                                throw exception2;
                            }
                            continue;
                        }
                        this.resolveIfStatement(stringBuilder, handle, templateChildNode, param, parentParam, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, subScope, false);
                        continue;
                    }
                    if (localNodeName.equals("ifexists")) {
                        if (ParameterParsingHelper.findParameter(templateChildNode, null, parentParam, rootParameter, ParameterParsingHelper.getRootParameterFromTemplateHandle(currentTemplate, templateRootParameters), templateReferencedParameters, this.mParameterFactory).getSecond() == null) continue;
                        this.resolveTemplateNodeList(stringBuilder, handle, templateChildNode, parentParam, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, currentScope);
                        continue;
                    }
                    if (localNodeName.equals("switch")) {
                        if (!VariableParameter.class.isInstance(param)) {
                            exception = new TemplateResolutionException("switch tag references a parameter ( " + param.getName() + " ) that is not a VariableParameter. ", this.mId);
                            if (this.mLoggingManager.canLog()) {
                                this.mLoggingManager.getLogger().error("switch tag references parameter " + param.getName() + " which is not a variable parameter", exception);
                            }
                            throw exception;
                        }
                        this.resolveVariableSwitchStatement(stringBuilder, handle, templateChildNode, (VariableParameter)param, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, subScope);
                        continue;
                    }
                    if (localNodeName.equals("scope")) {
                        this.resolveScopeStatement(stringBuilder, handle, templateChildNode, param, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, subScope);
                        continue;
                    }
                    if (localNodeName.equals("loop")) {
                        if (!LoopParameter.class.isInstance(param) && !IScopeParameter.class.isInstance(param)) {
                            exception = new TemplateResolutionException("loop tag references a parameter ( " + param.getName() + " ) that is not a LoopParameter. ", this.mId);
                            if (this.mLoggingManager.canLog()) {
                                this.mLoggingManager.getLogger().error("loop tag references parameter " + param.getName() + " which is not a loop parameter", exception);
                            }
                            throw exception;
                        }
                        if (LoopParameter.class.isInstance(param)) {
                            this.resolveLoopStatement(stringBuilder, handle, templateChildNode, (LoopParameter)param, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, subScope);
                            continue;
                        }
                        this.resolveScopeStatement(stringBuilder, handle, templateChildNode, param, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, subScope);
                        continue;
                    }
                    exception = new TemplateResolutionException("Invalid ELEMENT_NODE with name: " + templateChildNode.getNodeName(), this.mId);
                    if (this.mLoggingManager.canLog()) {
                        this.mLoggingManager.getLogger().error("tag not recognized by template parser: " + templateChildNode.getNodeName(), exception);
                    }
                    throw exception;
                }
                stringBuilder.append(templateChildNode.getTagToStringOpen());
                this.resolveTemplateNodeList(stringBuilder, handle, templateChildNode, parentParam, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, currentScope);
                stringBuilder.append(templateChildNode.getTagToStringClose());
                continue;
            }
            if (templateChildNode.getNodeType() == 3) {
                if (this.mSupressWhiteSpaceContent && templateChildNode.isTrimmedTextContentEmpty()) continue;
                stringBuilder.append(templateChildNode.getTextContent());
                continue;
            }
            if (templateChildNode.getNodeType() != 4) continue;
            stringBuilder.append("<![CDATA[");
            stringBuilder.append(templateChildNode.getTextContent());
            stringBuilder.append("]]>");
        }
    }

    private void resolveSubTemplateDependentParameters(IVariationsInitializationHandle handle, DependentParameter param, ParentParameter parentParam, ParentParameter rootParameter, SubTemplateHandle currentTemplate, Map<String, SubTemplateParameter> templateRootParameters, Map<String, Parameter> templateReferencedParameters, InputScopeObject currentScope) throws ParameterResolutionException {
        List<String> dependentParameterNames = param.getDependentParametersNames();
        ArrayList<Parameter> dependentParameters = new ArrayList<Parameter>();
        for (String name : dependentParameterNames) {
            Parameter dependentparam = ParameterParsingHelper.getParameterFromScope(null, name, parentParam, rootParameter, ParameterParsingHelper.getRootParameterFromTemplateHandle(currentTemplate, templateRootParameters));
            if (dependentparam == null) {
                dependentparam = ParameterParsingHelper.getReferencedParameterFromScope(null, name, parentParam, ParameterParsingHelper.getRootParameterFromTemplateHandle(currentTemplate, templateRootParameters), templateReferencedParameters);
            }
            dependentParameters.add(dependentparam);
        }
        param.setDependentParameters(dependentParameters);
        if (IResolvableParameter.class.isInstance(param)) {
            ((IResolvableParameter)((Object)param)).resolve(handle, currentScope);
        }
    }

    private void resolveCallSubTemplateTag(StringBuilder stringBuilder, IVariationsInitializationHandle handle, ParsedNode templateNode, ParentParameter parentParam, ParentParameter rootParameter, SubTemplateHandle currentTemplate, Map<String, SubTemplateParameter> templateRootParameters, Map<String, Parameter> templateReferencedParameters, InputScopeObject currentScope) throws RAREException {
        Map<String, Parameter> subTemplateReferencedParameters;
        String subTemplateName = templateNode.getAttribute("name");
        SubTemplateHandle subTemplateChildHandle = currentTemplate != null ? this.getSubTemplate(subTemplateName, currentTemplate) : this.getSubTemplate(subTemplateName, this.mId);
        if (subTemplateChildHandle == null) {
            TemplateResolutionException exception = new TemplateResolutionException("Invalid subTemplate reference " + subTemplateName, this.mId);
            if (this.mLoggingManager.canLog()) {
                this.mLoggingManager.getLogger().error("Subtemplate reference to " + subTemplateName + "is not valid", exception);
            }
            throw exception;
        }
        subTemplateName = subTemplateChildHandle.getName();
        try {
            ScopeParentParameter scopeParentParameter = ParameterParsingHelper.getRootParameterFromTemplateHandle(currentTemplate, templateRootParameters);
            subTemplateReferencedParameters = ParameterParsingHelper.getReferencedTemplateParameters(templateNode, parentParam, rootParameter, scopeParentParameter, templateReferencedParameters, this.mParameterFactory, this.mLoggingManager);
        }
        catch (RAREException e) {
            TemplateResolutionException exception = new TemplateResolutionException(e.getMessage(), this.mId, e);
            if (this.mLoggingManager.canLog()) {
                this.mLoggingManager.getLogger().error(e.getMessage(), exception);
            }
            throw exception;
        }
        ParsedNode subTemplateRootNode = subTemplateChildHandle.getRoot();
        ParsedNode subTemplatePayloadNode = subTemplateRootNode.getChildElement("payload");
        if (subTemplatePayloadNode != null) {
            subTemplateRootNode = subTemplatePayloadNode;
        }
        SubTemplateParameter storedTemplateRootParameter = templateRootParameters.get(subTemplateName);
        SubTemplateParameter templateRootParameter = (SubTemplateParameter)parentParam.getChildParameter(subTemplateName);
        templateRootParameters.put(subTemplateName, templateRootParameter);
        if (templateRootParameter == null || !ParentParameter.class.isInstance(templateRootParameter)) {
            TemplateResolutionException exception = new TemplateResolutionException("Parameter " + parentParam.getName() + " calls template " + subTemplateName + " but contains no reference to it", this.mId);
            if (this.mLoggingManager.canLog()) {
                this.mLoggingManager.getLogger().error("Subtemplate " + subTemplateName + " referred to within the scope of parameter " + parentParam.getName() + " but does not exist in the parameter tree ", exception);
            }
            throw exception;
        }
        this.resolveTemplateNodeList(stringBuilder, handle, subTemplateRootNode, templateRootParameter, rootParameter, subTemplateChildHandle, templateRootParameters, subTemplateReferencedParameters, currentScope);
        templateRootParameters.put(subTemplateName, storedTemplateRootParameter);
    }

    private Parameter extractParameterFromTemplateNode(IVariationsInitializationHandle handle, ParsedNode templateNode, ParentParameter parentParam, ParentParameter rootParameter, SubTemplateHandle currentTemplate, Map<String, SubTemplateParameter> templateRootParameters, Map<String, Parameter> templateReferencedParameters, InputScopeObject currentScope) throws RAREException {
        Map<String, String> attributes = templateNode.getAttributes();
        String scope = attributes.get("scope");
        Pair<String, Parameter> nameParamPair = ParameterParsingHelper.findParameter(templateNode, null, parentParam, rootParameter, ParameterParsingHelper.getRootParameterFromTemplateHandle(currentTemplate, templateRootParameters), templateReferencedParameters, this.mParameterFactory);
        Parameter param = nameParamPair.getSecond();
        String name = nameParamPair.getFirst();
        if (param == null) {
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                if (!this.mParameterFactory.canCreateParameterType(attribute.getKey())) continue;
                try {
                    param = this.mParameterFactory.createParameter(attribute.getKey(), attribute.getValue(), attributes);
                    if (IResolvableParameter.class.isInstance(param)) {
                        ((IResolvableParameter)((Object)param)).resolve(handle, currentScope);
                    }
                }
                catch (ParameterCreationException vpce) {
                }
                catch (ParameterResolutionException vpre) {
                    TemplateResolutionException exception = new TemplateResolutionException("Parameter(" + name + ") at scope (" + scope + ") was created, but cannot be resolved", this.mId, vpre);
                    if (this.mLoggingManager.canLog()) {
                        this.mLoggingManager.getLogger().error("Cannot resolve inline parameter " + name, exception);
                    }
                    throw exception;
                }
                if (param == null) continue;
                break;
            }
        }
        if (param == null) {
            TemplateResolutionException exception = scope != null ? new TemplateResolutionException("Parameter(" + name + ") at scope (" + scope + ") does not exist in the parameterTree", this.mId) : new TemplateResolutionException("Parameter(" + name + ") under parent parameter(" + parentParam.getName() + "), does not exist in the parameterTree", this.mId);
            if (this.mLoggingManager.canLog()) {
                this.mLoggingManager.getLogger().error("Parameter " + name + " does not exist" + name, exception);
            }
            throw exception;
        }
        return param;
    }

    private void resolveParentOrValueParameter(StringBuilder stringBuilder, IVariationsInitializationHandle handle, ParsedNode templateNode, Parameter param, ParentParameter rootParameter, SubTemplateHandle currentTemplate, Map<String, SubTemplateParameter> templateRootParameters, Map<String, Parameter> templateReferencedParameters, InputScopeObject currentScope) throws RAREException {
        if (ParentParameter.class.isInstance(param)) {
            this.resolveTemplateNodeList(stringBuilder, handle, templateNode, (ParentParameter)param, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, currentScope);
        } else if (IValueParameter.class.isInstance(param)) {
            this.resolveValueParameter(stringBuilder, templateNode, (IValueParameter)((Object)param));
        }
    }

    private void resolveValueParameter(StringBuilder stringBuilder, ParsedNode templateNode, IValueParameter param) throws RAREException {
        String textEncoding = templateNode.getAttribute("encoding");
        if ("xmlEncoded".equals(textEncoding)) {
            stringBuilder.append(XMLHelperD4J.encode(param.valueToString()));
        } else if ("JSON".equals(textEncoding)) {
            stringBuilder.append(JsonHelper.encodeString(param.valueToString()));
        } else {
            stringBuilder.append(param.valueToString());
        }
    }

    private void resolveVariableSwitchStatement(StringBuilder stringBuilder, IVariationsInitializationHandle handle, ParsedNode templateNode, VariableParameter param, ParentParameter rootParameter, SubTemplateHandle currentTemplate, Map<String, SubTemplateParameter> templateRootParameters, Map<String, Parameter> templateReferencedParameters, InputScopeObject currentScope) throws RAREException {
        if (MultiVariableParameter.class.isInstance(param)) {
            TemplateResolutionException exception = new TemplateResolutionException("MultiVariation parameters cannot be resolved by a switch tag, parameter: " + param.getName(), this.mId);
            if (this.mLoggingManager.canLog()) {
                this.mLoggingManager.getLogger().error("Switch tag refers to a multivariable parameter " + param.getName(), exception);
            }
            throw exception;
        }
        Parameter variationParam = param.getCurrentVariation();
        for (ParsedNode currentOptionNode : templateNode.getChildNodes()) {
            if (!currentOptionNode.inTemplateNamespace() || !currentOptionNode.getNodeName().equals("case") || !this.containsName(currentOptionNode, variationParam.getName(), "variation")) continue;
            this.resolveParentOrValueParameter(stringBuilder, handle, currentOptionNode, variationParam, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, currentScope);
        }
    }

    private void resolveIfStatement(StringBuilder stringBuilder, IVariationsInitializationHandle handle, ParsedNode templateNode, Parameter param, ParentParameter parentParam, ParentParameter rootParameter, SubTemplateHandle currentTemplate, Map<String, SubTemplateParameter> templateRootParameters, Map<String, Parameter> templateReferencedParameters, InputScopeObject currentScope, boolean reversed) throws RAREException {
        boolean isValid = false;
        if (IConditionalParameter.class.isInstance(param)) {
            isValid = ((IConditionalParameter)((Object)param)).isValid();
        } else if (LoopParameter.class.isInstance(param)) {
            isValid = ((LoopParameter)param).hasChildren();
        }
        if (isValid && !reversed || !isValid && reversed) {
            if (ParentParameter.class.isInstance(param) && IConditionalParameter.class.isInstance(param)) {
                if (ConditionalParentParameter.class.isInstance(param) && reversed) {
                    ParentParameter elseParam = ((ConditionalParentParameter)param).getElse();
                    this.resolveTemplateNodeList(stringBuilder, handle, templateNode, elseParam, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, currentScope);
                } else {
                    this.resolveTemplateNodeList(stringBuilder, handle, templateNode, (ParentParameter)param, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, currentScope);
                }
            } else {
                this.resolveTemplateNodeList(stringBuilder, handle, templateNode, parentParam, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, currentScope);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resolveScopeStatement(StringBuilder stringBuilder, IVariationsInitializationHandle handle, ParsedNode templateNode, Parameter param, ParentParameter rootParameter, SubTemplateHandle currentTemplate, Map<String, SubTemplateParameter> templateRootParameters, Map<String, Parameter> templateReferencedParameters, InputScopeObject currentScope) throws RAREException {
        int[] indexList;
        Parameter scopedParameter = null;
        if (templateNode.getNodeName().equals("loop") && templateNode.getIndexListParser() != null && (indexList = templateNode.getIndexListParser().getIndexList(1)).length != 1) {
            return;
        }
        if (LoopParameter.class.isInstance(param)) {
            LoopParameter loopParam = (LoopParameter)param;
            if (!loopParam.hasChildren()) return;
            scopedParameter = ((LoopParameter)param).getParameters().get(0);
        } else {
            scopedParameter = param;
        }
        if (!ParentParameter.class.isInstance(scopedParameter)) {
            TemplateResolutionException exception = new TemplateResolutionException("scope tag references a non parent parameter ", this.mId);
            if (!this.mLoggingManager.canLog()) throw exception;
            this.mLoggingManager.getLogger().error("Scope tag refers to leaf parameter " + scopedParameter.getName(), exception);
            throw exception;
        }
        this.resolveTemplateNodeList(stringBuilder, handle, templateNode, (ParentParameter)scopedParameter, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, currentScope);
    }

    private void resolveLoopStatement(StringBuilder stringBuilder, IVariationsInitializationHandle handle, ParsedNode templateNode, LoopParameter param, ParentParameter rootParameter, SubTemplateHandle currentTemplate, Map<String, SubTemplateParameter> templateRootParameters, Map<String, Parameter> templateReferencedParameters, InputScopeObject currentScope) throws RAREException {
        String delimeter = templateNode.getAttribute("delimeter");
        boolean skipEmpty = "true".equals(templateNode.getAttribute("skipEmpty"));
        if (param.hasChildren()) {
            int[] indexList;
            if (templateNode.getIndexListParser() != null) {
                indexList = templateNode.getIndexListParser().getIndexList(param.getNumChildren());
            } else {
                indexList = new int[param.getNumChildren()];
                for (int i = 0; i < indexList.length; ++i) {
                    indexList[i] = i;
                }
            }
            boolean reversed = "true".equals(templateNode.getAttribute("reversed"));
            boolean first = true;
            if (reversed) {
                int[] reversedList = new int[indexList.length];
                for (int i = 0; i < indexList.length; ++i) {
                    reversedList[i] = indexList[indexList.length - 1 - i];
                }
                indexList = reversedList;
            }
            for (int i = 0; i < indexList.length; ++i) {
                StringBuilder iterationContent = new StringBuilder();
                this.resolveParentOrValueParameter(iterationContent, handle, templateNode, param.getParameters().get(indexList[i]), rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters, currentScope);
                if (!skipEmpty || !iterationContent.toString().trim().isEmpty()) {
                    if (!first) {
                        if (delimeter != null) {
                            stringBuilder.append(delimeter);
                        }
                    } else {
                        first = false;
                    }
                }
                stringBuilder.append((CharSequence)iterationContent);
            }
        }
    }

    private boolean containsName(ParsedNode node, String name, String paramType) {
        boolean containsName = false;
        List<String> names = node.getAttributeAsPropertyList(paramType);
        for (String currentName : names) {
            if (!currentName.equals(name)) continue;
            containsName = true;
            break;
        }
        return containsName;
    }

    public String toString() {
        return this.mId;
    }

    public ParsedNode getTemplateRoot() {
        return this.mParsedTemplateRoot;
    }

    private void verifyVersion() throws TemplateParsingException {
        if (!this.mTemplateVersion.equals("1")) {
            TemplateParsingException exception = new TemplateParsingException("Template ( " + this.mId + " ) uses unspported version ( " + this.mTemplateVersion + " )");
            if (this.mLoggingManager.canLog()) {
                this.mLoggingManager.getLogger().error("Template version " + this.mTemplateVersion + " is not supported", exception);
            }
            throw exception;
        }
    }

    public SubTemplateHandle getSubTemplate(String name) throws RAREException {
        return this.mSubTemplates.get(name);
    }

    private Map<String, SubTemplateHandle> loadSubTemplates(ParsedNode templateRoot) throws RAREException {
        HashMap<String, SubTemplateHandle> subTemplates = new HashMap<String, SubTemplateHandle>();
        ParsedNode subTemplatesNode = templateRoot.getChildElement("subtemplates");
        this.verifyVersion();
        if (subTemplatesNode != null) {
            for (ParsedNode subtemplateChildNode : subTemplatesNode.getChildNodes()) {
                if (subtemplateChildNode.getNodeType() != 1) continue;
                String subTemplateName = subtemplateChildNode.getAttribute("name");
                if (subTemplates.containsKey(subTemplateName)) {
                    TemplateParsingException exception = new TemplateParsingException("Template ( " + this.mId + " ), Multiple SubTemplates with name " + subTemplateName);
                    if (this.mLoggingManager.canLog()) {
                        this.mLoggingManager.getLogger().error("Subtemplate collision with name " + this.mId, exception);
                    }
                    throw exception;
                }
                subTemplates.put(subTemplateName, new SubTemplateHandle(this.mId, subTemplateName, subtemplateChildNode));
            }
        }
        return subTemplates;
    }

    private SubTemplateHandle getSubTemplate(String name, SubTemplateHandle currentTemplate) throws RAREException {
        return this.getSubTemplate(name, currentTemplate.getId());
    }

    private SubTemplateHandle getSubTemplate(String name, String currentTemplateId) throws RAREException {
        try {
            return this.mTemplateRepository.getSubTemplateHandle(name, currentTemplateId, this.newTemplateFactoryForSubTemplate(name, currentTemplateId));
        }
        catch (IOException e) {
            RAREException exception = new RAREException("failed loading sub template " + name + " " + currentTemplateId, e);
            if (this.mLoggingManager.canLog()) {
                this.mLoggingManager.getLogger().error("Subtemplate " + name + " could not be loaded", exception);
            }
            throw exception;
        }
    }

    private ITemplateRepository.ITemplateFactory newTemplateFactoryForSubTemplate(final String name, final String currentTemplateId) throws RAREException {
        final String templateId = this.mTemplateRepository.getReferencedTemplateName(name, currentTemplateId);
        return new ITemplateRepository.ITemplateFactory(){

            @Override
            public Template createTemplate() throws RAREException, IOException {
                try {
                    return new Template(templateId, XMLHelperD4J.parseXMLStream(Template.this.mClassificationStreamer.getTemplateStream(templateId)), Template.this.mParameterFactory, Template.this.mTemplateRepository, Template.this.mClassificationStreamer, Template.this.mLoggingManager, Template.this.mSupressWhiteSpaceContent);
                }
                catch (RAREException raree) {
                    RAREException exception = new RAREException("failed creating sub template factory" + name + " " + currentTemplateId, raree);
                    if (Template.this.mLoggingManager.canLog()) {
                        Template.this.mLoggingManager.getLogger().error("Subtemplate factory for subtemplate " + name + " could not be instantiated", exception);
                    }
                    throw exception;
                }
            }
        };
    }

    private static String getVersion(Element templateRoot) {
        Attribute attribute = templateRoot.attribute("version");
        String templateVersion = attribute != null ? attribute.getValue() : "1";
        return templateVersion;
    }
}

