/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.utils;

import com.ibm.aurora.rare.IClassificationEntry;
import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.VariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.ParentParameter;
import com.ibm.aurora.rare.core.parameter.ScopeParentParameter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TreeWriter {
    private static final String TREE_WRITER_INDENTER = "    ";

    protected TreeWriter() {
    }

    public static String writeTree(IVariationsInitializationHandle handle, IClassificationEntry entry) {
        ScopeParentParameter tree = ((VariationsInitializationHandle)handle).getResolvedVariationTree(entry.getClassificationId(), entry.getVariationKey());
        return TreeWriter.writeTree(tree);
    }

    public static String writeTree(ScopeParentParameter tree) {
        if (tree != null) {
            return TreeWriter.writeParameter("", tree, new HashSet<Parameter>());
        }
        return "";
    }

    private static String writeParameterTree(String prefix, Parameter param, Set<Parameter> writtenParameters) {
        String output = "";
        if (ParentParameter.class.isInstance(param) && ((ParentParameter)param).hasChildren()) {
            List<Parameter> selectedChildren = ((ParentParameter)param).getParameters();
            for (Parameter parameter : selectedChildren) {
                output = output + TreeWriter.writeParameter(prefix + TREE_WRITER_INDENTER, parameter, writtenParameters);
            }
        }
        return output;
    }

    private static String writeParameter(String prefix, Parameter param, Set<Parameter> writtenParameters) {
        String parameterString = prefix + param.getClass().getSimpleName() + ":" + param.getName();
        if (writtenParameters.contains(param)) {
            parameterString = parameterString + " [Referenced Ancestor]\n";
        } else {
            try {
                parameterString = parameterString + param.logResolution();
            }
            catch (RAREException e) {
                parameterString = parameterString + e.getMessage();
            }
            writtenParameters.add(param);
            parameterString = parameterString + "\n" + TreeWriter.writeParameterTree(prefix, param, writtenParameters);
            writtenParameters.remove(param);
        }
        return parameterString;
    }
}

