/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.utils;

import com.ibm.aurora.rare.core.exception.XMLParsingException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class XMLHelperD4J {
    private static final String XML_HEADER_START = "<?xml";
    private static final String XML_HEADER_ENCODING = "encoding=";
    private static final char[] ENCODED_QUOT = "&quot;".toCharArray();
    private static final char[] ENCODED_AMP = "&amp;".toCharArray();
    private static final char[] ENCODED_APOS = "&apos;".toCharArray();
    private static final char[] ENCODED_LT = "&lt;".toCharArray();
    private static final char[] ENCODED_GT = "&gt;".toCharArray();

    public static Element parseXMLFile(String sFileName) throws XMLParsingException {
        Document document;
        SAXReader reader = new SAXReader();
        try {
            document = reader.read(new File(sFileName));
        }
        catch (Exception e) {
            throw new XMLParsingException("Could not parse XML File: " + e.getMessage(), e);
        }
        return document.getRootElement();
    }

    public static Element parseXMLStream(InputStream istream) throws XMLParsingException {
        Document document;
        SAXReader reader = new SAXReader();
        try {
            document = reader.read(istream);
        }
        catch (Exception e) {
            throw new XMLParsingException("Could not parse XML File: " + e.getMessage(), e);
        }
        return document.getRootElement();
    }

    public static Element parseString(String sInput) throws XMLParsingException {
        return XMLHelperD4J.getParsedDocument(sInput).getRootElement();
    }

    public static Document getParsedDocument(String contents) throws XMLParsingException {
        Document document;
        ByteArrayInputStream inStream;
        String processingInstruction;
        int posEncoding;
        String encoding = "UTF-8";
        int index = XML_HEADER_START.length();
        if (XML_HEADER_START.equals(contents.substring(0, index)) && (posEncoding = (processingInstruction = contents.substring(index, contents.indexOf("?>"))).indexOf(XML_HEADER_ENCODING)) != -1) {
            int posQuot;
            posEncoding += XML_HEADER_ENCODING.length();
            if ((posQuot = (encoding = processingInstruction.substring(++posEncoding)).indexOf(34)) == -1) {
                posQuot = encoding.indexOf(39);
            }
            encoding = encoding.substring(0, posQuot);
        }
        try {
            inStream = new ByteArrayInputStream(contents.trim().getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLParsingException("Could not parse XML File: " + e.getMessage(), e);
        }
        SAXReader reader = new SAXReader();
        try {
            document = reader.read((InputStream)inStream);
        }
        catch (Exception e) {
            throw new XMLParsingException("Could not parse XML File: " + e.getMessage(), e);
        }
        return document;
    }

    public static String getNodeName(Node node) {
        return node.getName();
    }

    public static String getAttribute(Element node, String attributeName) {
        return node.attributeValue(attributeName);
    }

    public String getAttributeChecked(Element element, String name) throws XMLParsingException {
        Attribute attribute = element.attribute(name);
        if (attribute != null) {
            return attribute.getValue();
        }
        throw new UnsupportedOperationException("Expected " + name + " attribute in:\n" + this.nodeToString((Node)element));
    }

    public Element getChildElement(Element element, String name, String xmlns, boolean checkAndThrow) throws XMLParsingException {
        Element result = null;
        int countMatches = 0;
        Iterator childItr = element.elementIterator(name);
        while (childItr.hasNext()) {
            result = (Element)childItr.next();
            ++countMatches;
            if (checkAndThrow) continue;
        }
        if (checkAndThrow && 1 != countMatches) {
            if (0 == countMatches) {
                throw new XMLParsingException("Expected " + name + " element in:\n" + this.nodeToString((Node)element));
            }
            throw new XMLParsingException("Expected only one " + name + " element in:\n" + this.nodeToString((Node)element));
        }
        return result;
    }

    public static List<Element> getChildElements(Element element, String name, String xmlns) {
        ArrayList<Element> results = new ArrayList<Element>();
        Iterator childItr = element.elementIterator(name);
        while (childItr.hasNext()) {
            results.add((Element)childItr.next());
        }
        return results;
    }

    public Element getChildElementWithAttribute(Element element, String elementName, String attributeName, String attributeValue, String xmlns, boolean checkAndThrow) throws XMLParsingException {
        if (attributeValue.isEmpty()) {
            throw new UnsupportedOperationException("attributeValue.isEmpty()");
        }
        Element result = null;
        int countMatches = 0;
        Iterator childItr = element.elementIterator(elementName);
        while (childItr.hasNext()) {
            Element childElement = (Element)childItr.next();
            if (!attributeValue.equals(childElement.attribute(attributeName).getValue()) || xmlns != null && !childElement.getNamespacePrefix().equals(xmlns)) continue;
            ++countMatches;
            result = childElement;
            if (checkAndThrow) continue;
            break;
        }
        if (checkAndThrow && 1 != countMatches) {
            if (0 == countMatches) {
                throw new UnsupportedOperationException("Expected " + elementName + " element in:\n" + this.nodeToString((Node)element));
            }
            throw new UnsupportedOperationException("Expected only one " + elementName + " element in:\n" + this.nodeToString((Node)element));
        }
        return result;
    }

    public static boolean checkNamespace(Element node, String xmlns) {
        boolean result = null != xmlns && !xmlns.isEmpty() ? xmlns.equals(node.getNamespacePrefix()) : true;
        return result;
    }

    public static String getAttributeOrNull(Element element, String xmlns, String namespaceURI, String localName) {
        String result = null;
        Attribute att = null != xmlns && !xmlns.isEmpty() ? element.attribute(QName.get((String)localName, (String)xmlns, (String)namespaceURI)) : element.attribute(localName);
        if (att != null) {
            result = att.getValue();
        }
        return result;
    }

    public Element getFirstChildElement(Element element, String name, String xmlns) throws XMLParsingException {
        Element child = this.getChildElement(element, name, xmlns, false);
        if (child == null) {
            throw new XMLParsingException("Expected " + name + " element in:\n" + this.nodeToString((Node)element));
        }
        return child;
    }

    public Element getChildElementChecked(Element element, String name, String xmlns) throws XMLParsingException {
        return this.getChildElement(element, name, xmlns, true);
    }

    public Element getChildElement(Element element, String name, String xmlns) throws XMLParsingException {
        return this.getChildElement(element, name, xmlns, false);
    }

    public static Map<String, String> getAttributesFromNode(Element node) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        List atts = node.attributes();
        for (Attribute attribute : atts) {
            attributes.put(attribute.getName(), attribute.getValue());
        }
        return attributes;
    }

    public String nodeToString(Node node) throws XMLParsingException {
        if (node == null) {
            throw new XMLParsingException("Could not tansform a null node");
        }
        if (node.getNodeType() == 1) {
            node = (Node)node.clone();
            this.cleanNamespace((Element)node);
        }
        return node.asXML();
    }

    private Node cleanNamespace(Element node) {
        node.setQName(new QName(node.getName(), Namespace.NO_NAMESPACE));
        Iterator childItr = node.elementIterator();
        while (childItr.hasNext()) {
            this.cleanNamespace((Element)childItr.next());
        }
        return node;
    }

    public String docToString(Node node) throws XMLParsingException {
        String serialized = node.asXML();
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + serialized;
    }

    public String docToString(Document doc) throws XMLParsingException {
        return doc.asXML();
    }

    public static String tagToStringOpen(Element tag) {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        sb.append(tag.getQualifiedName());
        sb.append(XMLHelperD4J.getDeclaredNamespaces(tag));
        List nodeAttributes = tag.attributes();
        for (Attribute attribute : nodeAttributes) {
            sb.append(' ').append(attribute.getName()).append("=\"").append(attribute.getValue()).append('\"');
        }
        sb.append('>');
        return sb.toString();
    }

    public static String getDeclaredNamespaces(Element node) {
        String declaredNamespaces = "";
        if (node.declaredNamespaces() != null && !node.declaredNamespaces().isEmpty()) {
            for (Object obj : node.declaredNamespaces()) {
                Namespace namespace = (Namespace)obj;
                declaredNamespaces = ' ' + namespace.asXML();
            }
        }
        return declaredNamespaces;
    }

    public static String tagToStringClose(Element tag) {
        return "</" + tag.getQualifiedName() + '>';
    }

    public static String lookupPrefix(String uri, Element node) {
        Namespace namespace = null;
        List declaredNamespaces = node.declaredNamespaces();
        for (Namespace ns : declaredNamespaces) {
            if (!ns.getURI().equals(uri)) continue;
            namespace = ns;
            break;
        }
        if (namespace != null) {
            return namespace.getPrefix();
        }
        return null;
    }

    public static String encode(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        int i = 0;
        int len = str.length();
        int begin = 0;
        char[] entity = null;
        char[] chars = str.toCharArray();
        StringBuffer buffer = new StringBuffer(len + 64);
        for (i = 0; i < len; ++i) {
            char ch = chars[i];
            if (ch == '<') {
                entity = ENCODED_LT;
            } else if (ch == '>') {
                entity = ENCODED_GT;
            } else if (ch == '\"') {
                entity = ENCODED_QUOT;
            } else if (ch == '&') {
                entity = ENCODED_AMP;
            } else {
                if (ch != '\'') continue;
                entity = ENCODED_APOS;
            }
            buffer.append(chars, begin, i - begin);
            buffer.append(entity);
            begin = i + 1;
        }
        buffer.append(chars, begin, len - begin);
        return buffer.toString();
    }

    public static String decode(String str) {
        if (str == null || str.length() < 1) {
            return "";
        }
        int len = str.length();
        int i = str.indexOf(38);
        if (i < 0) {
            return str;
        }
        int curPos = 0;
        char[] chars = str.toCharArray();
        StringBuffer buffer = new StringBuffer(len);
        try {
            do {
                int elen = 0;
                int ch = 38;
                char cch = chars[i + 1];
                if (cch == 'q') {
                    if (chars[i + 2] == 'u' && chars[i + 3] == 'o' && chars[i + 4] == 't') {
                        elen = 5;
                        ch = 34;
                    }
                } else if (cch == 'a') {
                    cch = chars[i + 2];
                    if (cch == 'm') {
                        if (chars[i + 3] == 'p') {
                            elen = 4;
                            ch = 38;
                        }
                    } else if (cch == 'p' && chars[i + 3] == 'o' && chars[i + 4] == 's') {
                        elen = 5;
                        ch = 39;
                    }
                } else if (cch == 'l') {
                    if (chars[i + 2] == 't') {
                        elen = 3;
                        ch = 60;
                    }
                } else if (cch == 'g' && chars[i + 2] == 't') {
                    elen = 3;
                    ch = 62;
                }
                if (chars[i + elen] == ';') {
                    buffer.append(chars, curPos, i - curPos);
                    buffer.append((char)ch);
                    curPos = i += elen + 1;
                    continue;
                }
                ++i;
            } while ((i = str.indexOf(38, i)) > 0);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        buffer.append(chars, curPos, len - curPos);
        return buffer.toString();
    }
}

