/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.variationengine;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.parameter.DependentParameter;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.ParentParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IScorableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IValidationParameter;
import com.ibm.aurora.rare.core.variationengine.descriptors.MultiDependentsDescriptor;

public class DependentValidationAndScoringManager {
    private MultiDependentsDescriptor mValidationParameters;
    private MultiDependentsDescriptor mScoringParameters;

    public DependentValidationAndScoringManager(IVariationsInitializationHandle handle, ParentParameter treeRoot) {
        this.mValidationParameters = new MultiDependentsDescriptor(handle);
        this.mScoringParameters = new MultiDependentsDescriptor(handle);
        if (treeRoot.hasChildren()) {
            for (Parameter param : treeRoot.getParameters()) {
                if (IValidationParameter.class.isInstance(param)) {
                    this.addIfDependent(param, this.mValidationParameters);
                    continue;
                }
                if (!IScorableParameter.class.isInstance(param)) continue;
                this.addIfDependent(param, this.mScoringParameters);
            }
        }
    }

    private void addIfDependent(Parameter param, MultiDependentsDescriptor descriptor) {
        DependentParameter dependentParam;
        if (DependentParameter.class.isInstance(param) && (dependentParam = (DependentParameter)param).isDependent()) {
            descriptor.addDependentParameter(dependentParam);
        }
    }

    public MultiDependentsDescriptor getValidationDescriptor() {
        return this.mValidationParameters;
    }

    public MultiDependentsDescriptor getScoringDescriptor() {
        return this.mScoringParameters;
    }
}

