/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.variationengine;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.parameter.ConditionalParentParameter;
import com.ibm.aurora.rare.core.parameter.DependentParameter;
import com.ibm.aurora.rare.core.parameter.MultiVariableParameter;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.ParentParameter;
import com.ibm.aurora.rare.core.parameter.ScopeParentParameter;
import com.ibm.aurora.rare.core.parameter.VariableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IConditionalParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IMultiResolvableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IResolvableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IScopeParameter;
import com.ibm.aurora.rare.core.parameter.parameterFactory.ParameterFactory;
import com.ibm.aurora.rare.core.variationengine.VariationTree;
import com.ibm.aurora.rare.core.variationengine.descriptors.GroupedOutputsDescriptor;
import com.ibm.aurora.rare.logging.ELogLevel;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParameterVariationTreeProducer {
    private ParameterFactory mParameterFactory = null;
    private Map<Parameter, List<? extends InputScopeObject>> _PossibleVariationsMap;
    private final LoggingManager mLoggingManager;

    public ParameterVariationTreeProducer(ParameterFactory parameterFactory, LoggingManager loggingManager) {
        this.mParameterFactory = parameterFactory;
        this.mLoggingManager = loggingManager;
    }

    public VariationTree getParameterVariationTree(IVariationsInitializationHandle handle, ParentParameter parameterTree) throws RAREException {
        this._PossibleVariationsMap = new HashMap<Parameter, List<? extends InputScopeObject>>();
        ScopeParentParameter rootParameter = new ScopeParentParameter(parameterTree, true);
        rootParameter.resolve(handle, handle.getInputManager().getRootScope());
        if (this.processAllNodeChildParameters(handle, rootParameter.getScope(), rootParameter, parameterTree, null)) {
            return new VariationTree(rootParameter);
        }
        return null;
    }

    private boolean canProcessParameter(Parameter param) {
        return !DependentParameter.class.isInstance(param) || !((DependentParameter)param).isDependent();
    }

    private Parameter processParameter(IVariationsInitializationHandle handle, InputScopeObject currentScope, Parameter originalParameter, Map<String, GroupedOutputsDescriptor> outputDescriptorsMap) throws RAREException {
        if (IMultiResolvableParameter.class.isInstance(originalParameter)) {
            return this.processMultiResolvableParameter(handle, currentScope, (IMultiResolvableParameter)((Object)originalParameter), originalParameter, outputDescriptorsMap);
        }
        return this.processSimpleParameter(handle, currentScope, originalParameter, outputDescriptorsMap);
    }

    private Parameter processSimpleParameter(IVariationsInitializationHandle handle, InputScopeObject currentScope, Parameter originalParameter, Map<String, GroupedOutputsDescriptor> outputDescriptorsMap) throws RAREException {
        Parameter param = null;
        boolean isParentParameter = ParentParameter.class.isInstance(originalParameter);
        param = isParentParameter ? ((ParentParameter)originalParameter).shallowCopy(true, this.mLoggingManager) : originalParameter.copy(this.mLoggingManager);
        if (IResolvableParameter.class.isInstance(param) && !((IResolvableParameter)((Object)param)).isResolved()) {
            ((IResolvableParameter)((Object)param)).resolve(handle, currentScope);
        }
        if (isParentParameter) {
            ParentParameter parentParam = null;
            ParentParameter originalParentParam = null;
            if (ConditionalParentParameter.class.isInstance(param) && !((IConditionalParameter)((Object)param)).isValid()) {
                originalParentParam = ((ConditionalParentParameter)originalParameter).getElse();
                if (originalParentParam != null) {
                    ParentParameter elseParam = new ParentParameter("else");
                    elseParam.setAttribute("isElse", "true");
                    ((ConditionalParentParameter)param).setElse(elseParam);
                    parentParam = elseParam;
                }
            } else if (!IConditionalParameter.class.isInstance(param) || ((IConditionalParameter)((Object)param)).isValid() || "true".equals(param.getAttribute("hasElse"))) {
                parentParam = (ParentParameter)param;
                originalParentParam = (ParentParameter)originalParameter;
            }
            if (parentParam != null && !this.processAllNodeChildParameters(handle, currentScope, parentParam, originalParentParam, outputDescriptorsMap)) {
                return null;
            }
        }
        return param;
    }

    private Parameter processMultiResolvableParameter(IVariationsInitializationHandle handle, InputScopeObject currentScope, IMultiResolvableParameter variationsProducer, Parameter originalParameter, Map<String, GroupedOutputsDescriptor> outputDescriptorsMap) throws RAREException {
        List<? extends InputScopeObject> possibleVariations = variationsProducer.resolvePossibleVariations(handle, currentScope);
        if (!this.setBindingInfo(variationsProducer.getResolutionGroupName(), possibleVariations, variationsProducer.getMinBindings(), variationsProducer.getMaxBindings(), outputDescriptorsMap)) {
            if (this.mLoggingManager.canLog(ELogLevel.DEBUG)) {
                this.mLoggingManager.getLogger().debug("Parameter " + originalParameter.getName() + " could not satisfy bindings min = " + variationsProducer.getMinBindings() + " max = " + variationsProducer.getMaxBindings() + "  possible bindings = " + possibleVariations);
            }
            return null;
        }
        Parameter processedParam = null;
        if (possibleVariations.size() <= 1 && variationsProducer.getMinBindings() == 1 && variationsProducer.getMaxBindings() == 1) {
            processedParam = this.processSimpleParameter(handle, possibleVariations.get(0), originalParameter, outputDescriptorsMap);
        } else {
            MultiVariableParameter varParam = (MultiVariableParameter)this.mParameterFactory.createParameter("multivariation", originalParameter.getName());
            varParam.setTransient(true);
            varParam.setEnumerateAllVariationsActive(variationsProducer.allowsEnumerateAllPossiblities());
            varParam.setMinBindings(variationsProducer.getMinBindings());
            varParam.setMaxBindings(Math.min(variationsProducer.getMaxBindings(), possibleVariations.size()));
            varParam.setAllowsBindingSizeVariations(variationsProducer.allowsBindingSizeVariations());
            varParam.setEnumerateAllOrders(variationsProducer.allowsEnumerateAllOrderings());
            for (InputScopeObject inputScopeObject : possibleVariations) {
                Parameter param = this.processSimpleParameter(handle, inputScopeObject, originalParameter, outputDescriptorsMap);
                if (param != null) {
                    varParam.addVariation(param);
                    continue;
                }
                return null;
            }
            varParam.setToResolutionGroup(variationsProducer);
            processedParam = varParam;
        }
        this._PossibleVariationsMap.put(processedParam, possibleVariations);
        return processedParam;
    }

    private boolean processAllNodeChildParameters(IVariationsInitializationHandle handle, InputScopeObject scopeList, ParentParameter parentParam, ParentParameter originalParameter, Map<String, GroupedOutputsDescriptor> outputDescriptorsMap) throws RAREException {
        List<Parameter> originalChildParameters;
        Map<String, GroupedOutputsDescriptor> outputDescriptors = outputDescriptorsMap;
        boolean outputDescriptorRoot = IScopeParameter.class.isInstance(parentParam);
        if (outputDescriptorRoot) {
            outputDescriptors = new HashMap<String, GroupedOutputsDescriptor>();
        }
        InputScopeObject currentScope = scopeList;
        if (IScopeParameter.class.isInstance(parentParam)) {
            currentScope = ((IScopeParameter)((Object)parentParam)).getScope();
        }
        if ((originalChildParameters = originalParameter.getParameters()) != null) {
            for (int i = 0; i < originalChildParameters.size(); ++i) {
                Parameter originalVisParam = originalChildParameters.get(i);
                if (this.canProcessParameter(originalVisParam)) {
                    Parameter childParam = this.processParameter(handle, currentScope, originalVisParam, outputDescriptors);
                    if (childParam != null) {
                        parentParam.addChildParameter(childParam);
                        continue;
                    }
                    return false;
                }
                Parameter param = ParentParameter.getCopyOfParameter(originalVisParam, this.mLoggingManager);
                parentParam.addChildParameter(param);
            }
        }
        if (outputDescriptorRoot && parentParam.hasChildren()) {
            return this.updateMaxBindingsPerResolutionGroup(parentParam, outputDescriptors);
        }
        return true;
    }

    private boolean setBindingInfo(String group, List<? extends InputScopeObject> inputs, int minBindings, int maxBindings, Map<String, GroupedOutputsDescriptor> outputDescriptorsMap) {
        if (inputs.size() < minBindings) {
            return false;
        }
        GroupedOutputsDescriptor outputDescriptor = outputDescriptorsMap.get(group);
        if (outputDescriptor == null) {
            outputDescriptor = new GroupedOutputsDescriptor();
            outputDescriptorsMap.put(group, outputDescriptor);
        }
        outputDescriptor.addInputs(inputs);
        outputDescriptor.registerMinRequired(minBindings);
        outputDescriptor.registerMaxRequired(maxBindings);
        return outputDescriptor.getMinRequiredBindingsInGroup() <= outputDescriptor.getTotalBindingsInGroup();
    }

    private int getNewMaxBinding(String group, List<? extends InputScopeObject> possibleVariations, int min, int max, Map<String, GroupedOutputsDescriptor> outputDescriptorsMap) {
        GroupedOutputsDescriptor outputDescriptor = outputDescriptorsMap.get(group);
        if (outputDescriptor != null) {
            return outputDescriptor.reserveBindings(max - min, possibleVariations) + min;
        }
        return -1;
    }

    private boolean registerMinBindings(String group, List<? extends InputScopeObject> possibleVariations, int min, Map<String, GroupedOutputsDescriptor> outputDescriptorsMap) {
        GroupedOutputsDescriptor outputDescriptor = outputDescriptorsMap.get(group);
        if (outputDescriptor != null) {
            return outputDescriptor.reserveBindings(min, possibleVariations) == min;
        }
        return true;
    }

    private void reregisterCounts(String group, List<? extends InputScopeObject> possibleVariations, Map<String, GroupedOutputsDescriptor> outputDescriptorsMap) {
        GroupedOutputsDescriptor outputDescriptor = outputDescriptorsMap.get(group);
        if (outputDescriptor != null) {
            outputDescriptor.reregisterInputs(possibleVariations);
        }
    }

    private boolean updateMaxBindingsPerResolutionGroup(ParentParameter parent, Map<String, GroupedOutputsDescriptor> outputDescriptorsMap) {
        if (this.registerMinBindingsPerGroup(parent, outputDescriptorsMap)) {
            this.reregisterGroupDescriptorCounts(parent, outputDescriptorsMap);
            this.updateMaxBindings(parent, outputDescriptorsMap);
            return true;
        }
        return false;
    }

    private void updateMaxBindings(ParentParameter parent, Map<String, GroupedOutputsDescriptor> outputDescriptorsMap) {
        List<Parameter> childParameters = parent.getParameters();
        for (Parameter param : childParameters) {
            ParentParameter parentParam;
            GroupedOutputsDescriptor outputDescriptor;
            if (VariableParameter.class.isInstance(param) && (outputDescriptor = outputDescriptorsMap.get(((VariableParameter)param).getResolutionGroupName())) != null) {
                ((VariableParameter)param).setMaxNumBindingsInGroup(outputDescriptor.getMaxRequiredBindingsInGroup());
            }
            if (MultiVariableParameter.class.isInstance(param)) {
                MultiVariableParameter multiVarParam = (MultiVariableParameter)param;
                List<? extends InputScopeObject> possibleVariations = this._PossibleVariationsMap.get(multiVarParam);
                if (!multiVarParam.allowsBindingSizeVariations()) {
                    int newMax = this.getNewMaxBinding(multiVarParam.getResolutionGroupName(), possibleVariations, multiVarParam.getMinBindings(), multiVarParam.getMaxBindings(), outputDescriptorsMap);
                    if (newMax != -1) {
                        multiVarParam.setMaxBindings(newMax);
                        multiVarParam.setMinBindings(newMax);
                    }
                } else {
                    multiVarParam.setMaxBindings(Math.min(multiVarParam.getMaxBindings(), possibleVariations.size()));
                }
            }
            if (!ParentParameter.class.isInstance(param) || IScopeParameter.class.isInstance(param) || !(parentParam = (ParentParameter)param).hasChildren()) continue;
            this.updateMaxBindingsPerResolutionGroup((ParentParameter)param, outputDescriptorsMap);
        }
    }

    private boolean registerMinBindingsPerGroup(ParentParameter parent, Map<String, GroupedOutputsDescriptor> outputDescriptorsMap) {
        List<Parameter> childParameters = parent.getParameters();
        boolean passed = true;
        for (Parameter param : childParameters) {
            ParentParameter parentParam;
            if (IMultiResolvableParameter.class.isInstance(param)) {
                IMultiResolvableParameter multiResolvableParam = (IMultiResolvableParameter)((Object)param);
                List<? extends InputScopeObject> possibleVariations = this._PossibleVariationsMap.get(multiResolvableParam);
                if (possibleVariations != null && ((IMultiResolvableParameter)((Object)param)).getMinBindings() == 1 && ((IMultiResolvableParameter)((Object)param)).getMaxBindings() == 1) {
                    passed = this.registerMinBindings(multiResolvableParam.getResolutionGroupName(), possibleVariations, 1, outputDescriptorsMap);
                }
            } else if (MultiVariableParameter.class.isInstance(param)) {
                MultiVariableParameter multiVarParam = (MultiVariableParameter)param;
                passed = this.registerMinBindings(multiVarParam.getResolutionGroupName(), this._PossibleVariationsMap.get(multiVarParam), multiVarParam.getMinBindings(), outputDescriptorsMap);
            }
            if (passed && ParentParameter.class.isInstance(param) && !IScopeParameter.class.isInstance(param) && (parentParam = (ParentParameter)param).hasChildren()) {
                passed = this.registerMinBindingsPerGroup((ParentParameter)param, outputDescriptorsMap);
            }
            if (passed) continue;
            return false;
        }
        return true;
    }

    private void reregisterGroupDescriptorCounts(ParentParameter parent, Map<String, GroupedOutputsDescriptor> outputDescriptorsMap) {
        List<Parameter> childParameters = parent.getParameters();
        boolean passed = true;
        for (Parameter param : childParameters) {
            ParentParameter parentParam;
            if (IMultiResolvableParameter.class.isInstance(param)) {
                IMultiResolvableParameter multiResolvableParam = (IMultiResolvableParameter)((Object)param);
                List<? extends InputScopeObject> possibleVariations = this._PossibleVariationsMap.get(multiResolvableParam);
                if (possibleVariations != null && ((IMultiResolvableParameter)((Object)param)).getMinBindings() == 1 && ((IMultiResolvableParameter)((Object)param)).getMaxBindings() == 1) {
                    this.reregisterCounts(multiResolvableParam.getResolutionGroupName(), possibleVariations, outputDescriptorsMap);
                }
            } else if (MultiVariableParameter.class.isInstance(param)) {
                MultiVariableParameter multiVarParam = (MultiVariableParameter)param;
                this.reregisterCounts(multiVarParam.getResolutionGroupName(), this._PossibleVariationsMap.get(multiVarParam), outputDescriptorsMap);
            }
            if (!passed || !ParentParameter.class.isInstance(param) || IScopeParameter.class.isInstance(param) || !(parentParam = (ParentParameter)param).hasChildren()) continue;
            this.reregisterGroupDescriptorCounts((ParentParameter)param, outputDescriptorsMap);
        }
    }
}

