/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.variationengine;

import com.ibm.aurora.rare.core.exception.VariationSerializationException;
import com.ibm.aurora.rare.core.parameter.DependentParameter;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.ParentParameter;
import com.ibm.aurora.rare.core.parameter.VariableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IScopeParameter;
import com.ibm.aurora.rare.core.variationengine.descriptors.GroupedScopeObjectDescriptor;
import com.ibm.aurora.rare.core.variationengine.descriptors.GroupedVariationDescriptor;
import com.ibm.aurora.rare.core.variationengine.descriptors.IGroupVariationDescriptor;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Utils {
    protected Utils() {
    }

    public static List<ParentParameter> getParentParametersFromParameterList(List<Parameter> parameters) {
        ArrayList<ParentParameter> parentParameters = new ArrayList<ParentParameter>();
        if (parameters != null) {
            for (Parameter param : parameters) {
                if (!ParentParameter.class.isInstance(param) || !((ParentParameter)param).hasChildren()) continue;
                parentParameters.add((ParentParameter)param);
            }
        }
        return parentParameters;
    }

    public static List<Parameter> getNonDependentParametersFromParameterList(List<Parameter> parameters, Class<?> parameterClass) {
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        if (parameters != null) {
            for (Parameter param : parameters) {
                if (!parameterClass.isInstance(param) || DependentParameter.class.isInstance(param) && ((DependentParameter)param).isDependent()) continue;
                parameterList.add(param);
            }
        }
        return parameterList;
    }

    public static Map<String, IGroupVariationDescriptor> createEmptyGroupedVariationMap(List<Parameter> parameters) throws VariationSerializationException {
        HashMap<String, IGroupVariationDescriptor> groupedVariationParameters = new HashMap<String, IGroupVariationDescriptor>();
        Utils.createEmptyGroupedVariationMap(parameters, groupedVariationParameters);
        return groupedVariationParameters;
    }

    private static void createEmptyGroupedVariationMap(List<Parameter> parameters, Map<String, IGroupVariationDescriptor> groupedVariationParameters) throws VariationSerializationException {
        for (Parameter parameter : parameters) {
            if (VariableParameter.class.isInstance(parameter) && ((VariableParameter)parameter).getResolutionGroupName() != null) {
                VariableParameter resolutionGroupParam = (VariableParameter)parameter;
                if (groupedVariationParameters.containsKey(resolutionGroupParam.getResolutionGroupName())) continue;
                IGroupVariationDescriptor currentGroupDescriptor = null;
                currentGroupDescriptor = VariableParameter.class.isInstance(parameter) && ((VariableParameter)parameter).isTransient() ? new GroupedScopeObjectDescriptor() : new GroupedVariationDescriptor();
                groupedVariationParameters.put(resolutionGroupParam.getResolutionGroupName(), currentGroupDescriptor);
                continue;
            }
            if (!ParentParameter.class.isInstance(parameter) || !((ParentParameter)parameter).hasChildren() || IScopeParameter.class.isInstance(parameter)) continue;
            Utils.createEmptyGroupedVariationMap(((ParentParameter)parameter).getParameters(), groupedVariationParameters);
        }
    }

    public static List<int[]> generatePossibleOrderingsForMultiGroup(boolean[] innactiveVariations, int sizeOfSets, boolean allowMultipleOrderings, boolean enumerateAllOrderings, LoggingManager loggingManager) throws VariationSerializationException {
        int i;
        int validVariationsCounter = 0;
        for (i = 0; i < innactiveVariations.length; ++i) {
            if (innactiveVariations[i]) continue;
            ++validVariationsCounter;
        }
        if (validVariationsCounter < sizeOfSets) {
            VariationSerializationException exception = new VariationSerializationException("Impossible to generate necessary multi-group orderings, only " + validVariationsCounter + " possible choices but " + sizeOfSets + " are desired");
            if (loggingManager.canLog()) {
                loggingManager.getLogger().error("Multi orderings grouping could not be generated", exception);
            }
            throw exception;
        }
        int currentArrayIndex = 0;
        int[] validIndexes = new int[validVariationsCounter];
        boolean[] arrayMask = new boolean[validVariationsCounter];
        for (i = 0; i < innactiveVariations.length; ++i) {
            if (innactiveVariations[i]) continue;
            validIndexes[currentArrayIndex++] = i;
        }
        if (allowMultipleOrderings) {
            return Utils.generatePossibleOrderingsForMultiGroup(validIndexes, sizeOfSets, arrayMask, enumerateAllOrderings, 0);
        }
        int[] singleVariation = new int[sizeOfSets];
        for (i = 0; i < sizeOfSets; ++i) {
            singleVariation[i] = validIndexes[i];
        }
        ArrayList<int[]> singleOrdering = new ArrayList<int[]>();
        singleOrdering.add(singleVariation);
        return singleOrdering;
    }

    private static List<int[]> generatePossibleOrderingsForMultiGroup(int[] arrayMembers, int desiredArraySize, boolean[] arrayMask, boolean enumerateAllOrderings, int startidx) {
        ArrayList<int[]> orderings = new ArrayList<int[]>();
        if (desiredArraySize > 0) {
            for (int i = startidx; i < arrayMembers.length; ++i) {
                if (arrayMask[i]) continue;
                if (desiredArraySize == 1) {
                    int[] currentOrder = new int[]{arrayMembers[i]};
                    orderings.add(currentOrder);
                    continue;
                }
                arrayMask[i] = true;
                List<int[]> subArrays = Utils.generatePossibleOrderingsForMultiGroup(arrayMembers, desiredArraySize - 1, arrayMask, enumerateAllOrderings, enumerateAllOrderings ? 0 : i + 1);
                arrayMask[i] = false;
                for (int[] subArray : subArrays) {
                    int[] currentOrder = new int[desiredArraySize];
                    currentOrder[0] = arrayMembers[i];
                    System.arraycopy(subArray, 0, currentOrder, 1, subArray.length);
                    orderings.add(currentOrder);
                }
            }
        } else {
            orderings.add(new int[0]);
        }
        return orderings;
    }

    public static boolean isUnambiguousVariationSerializaion(StringBuilder serialization) {
        for (int i = 0; i < serialization.length(); ++i) {
            if (serialization.charAt(i) == ',') continue;
            return false;
        }
        return true;
    }

    public static byte[] generatePositionalKeyFromOrdering(int[] ordering, int size) {
        int i;
        byte[] orderingKey = new byte[size];
        for (i = 0; i < size; ++i) {
            orderingKey[i] = 0;
        }
        for (i = 0; i < ordering.length; ++i) {
            orderingKey[ordering[i]] = 1;
        }
        return orderingKey;
    }

    public static boolean checkForPositionKeyOverlaps(byte[] key1, byte[] key2) {
        for (int i = 0; i < key1.length; ++i) {
            if (key1[i] != 1 || key2[i] != 1) continue;
            return true;
        }
        return false;
    }

    public static Set<byte[]> getNonOverlappingPositionKeys(Set<byte[]> keys, byte[] newKey) {
        HashSet<byte[]> nonOverlappingKeys = null;
        for (byte[] key : keys) {
            if (Utils.checkForPositionKeyOverlaps(key, newKey)) continue;
            if (nonOverlappingKeys == null) {
                nonOverlappingKeys = new HashSet<byte[]>();
            }
            nonOverlappingKeys.add(key);
        }
        return nonOverlappingKeys;
    }

    public static int countActivePositionsInKey(byte[] key) {
        int count = 0;
        for (int i = 0; i < key.length; ++i) {
            if (key[i] != 1) continue;
            ++count;
        }
        return count;
    }

    public static boolean isKeyPositionActive(byte[] key, int position) {
        return key[position] == 1;
    }

    public static byte[] setKeyPositionActive(byte[] key, int position) {
        key[position] = 1;
        return key;
    }
}

