/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.variationengine;

import com.ibm.aurora.rare.core.parameter.MultiVariableParameter;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.ParentParameter;
import com.ibm.aurora.rare.core.parameter.ScopeParentParameter;
import com.ibm.aurora.rare.core.parameter.VariableParameter;
import com.ibm.aurora.rare.core.variationengine.Utils;
import java.util.ArrayList;
import java.util.List;

public class VariationTree {
    private ScopeParentParameter mTreeRoot = null;

    public VariationTree(ScopeParentParameter root) {
        this.mTreeRoot = root;
    }

    public ScopeParentParameter getRoot() {
        return this.mTreeRoot;
    }

    public void setToVariationKey(StringBuilder key) {
        if (key.length() > 0) {
            this.setToVariationKey(key, 0, this.mTreeRoot);
        }
    }

    private int setToVariationKey(StringBuilder key, int keyIndex, ParentParameter parentParameter) {
        List<ParentParameter> childParentParameters;
        int currentIndex = keyIndex;
        if (VariableParameter.class.isInstance(parentParameter)) {
            List<Parameter> currentVariations;
            currentIndex = ((VariableParameter)parentParameter).deserializeVariationChoices(key, currentIndex);
            if (MultiVariableParameter.class.isInstance(parentParameter)) {
                currentVariations = ((MultiVariableParameter)parentParameter).getCurrentVariations();
            } else {
                currentVariations = new ArrayList<Parameter>();
                currentVariations.add(((VariableParameter)parentParameter).getCurrentVariation());
            }
            childParentParameters = Utils.getParentParametersFromParameterList(currentVariations);
        } else {
            childParentParameters = Utils.getParentParametersFromParameterList(parentParameter.getParameters());
        }
        if (key.charAt(currentIndex) == '(') {
            ++currentIndex;
            for (ParentParameter childParentParameter : childParentParameters) {
                if (key.charAt(currentIndex) != ',') {
                    currentIndex = this.setToVariationKey(key, currentIndex, childParentParameter);
                }
                if (key.charAt(currentIndex) != ',') continue;
                ++currentIndex;
            }
            ++currentIndex;
        }
        return currentIndex;
    }
}

