/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.variationengine;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.ParameterCreationException;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.parameter.ConditionalParentParameter;
import com.ibm.aurora.rare.core.parameter.DependentParameter;
import com.ibm.aurora.rare.core.parameter.LoopParameter;
import com.ibm.aurora.rare.core.parameter.MultiVariableParameter;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.ParentParameter;
import com.ibm.aurora.rare.core.parameter.ScopeParentParameter;
import com.ibm.aurora.rare.core.parameter.SubTemplateParameter;
import com.ibm.aurora.rare.core.parameter.VariableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IResolvableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IScopeParameter;
import com.ibm.aurora.rare.core.parameter.parameterFactory.ParameterFactory;
import com.ibm.aurora.rare.core.variationengine.VariationTree;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VariationTreeResolver {
    private ParameterFactory mParameterFactory = null;
    private final LoggingManager mLoggingManager;

    public VariationTreeResolver(ParameterFactory parameterFactory, LoggingManager loggingManager) {
        this.mParameterFactory = parameterFactory;
        this.mLoggingManager = loggingManager;
    }

    public ScopeParentParameter resolveVariation(IVariationsInitializationHandle handle, StringBuilder key, VariationTree variationTree) throws RAREException {
        variationTree.setToVariationKey(key);
        ScopeParentParameter resolvedRoot = new ScopeParentParameter(variationTree.getRoot(), true);
        resolvedRoot.addChildParameters(this.resolveVariationTreeChildren(variationTree.getRoot()));
        this.resolveAllDependentParameters(handle, resolvedRoot, resolvedRoot, resolvedRoot, resolvedRoot.getScope());
        return resolvedRoot;
    }

    private List<Parameter> resolveVariationTreeChildren(ParentParameter parentParameter) throws ParameterCreationException {
        List<Parameter> parameters = parentParameter.getParameters();
        ArrayList<Parameter> resolvedParameters = new ArrayList<Parameter>();
        if (parameters != null) {
            Iterator<Parameter> i$ = parameters.iterator();
            while (i$.hasNext()) {
                Parameter parameter;
                Parameter currentParameter = parameter = i$.next();
                Parameter currentCopy = null;
                if (VariableParameter.class.isInstance(parameter) && ((VariableParameter)parameter).isTransient()) {
                    if (!MultiVariableParameter.class.isInstance(parameter)) {
                        currentParameter = ((VariableParameter)parameter).getCurrentVariation();
                    } else {
                        LoopParameter loopParam = (LoopParameter)this.mParameterFactory.createParameter("loop", parameter.getName());
                        List<Parameter> currentVariations = ((MultiVariableParameter)parameter).getCurrentVariations();
                        loopParam.addChildParameters(currentVariations);
                        currentParameter = loopParam;
                    }
                }
                if (ParentParameter.class.isInstance(currentParameter)) {
                    ParentParameter elseParam;
                    currentCopy = ((ParentParameter)currentParameter).shallowCopy(true, this.mLoggingManager);
                    ParentParameter currentParentParameter = (ParentParameter)currentParameter;
                    if (currentParentParameter.getNumChildren() != 0) {
                        ((ParentParameter)currentCopy).addChildParameters(this.resolveVariationTreeChildren(currentParentParameter));
                    }
                    if (ConditionalParentParameter.class.isInstance(currentParameter) && (elseParam = ((ConditionalParentParameter)currentParameter).getElse()) != null) {
                        ParentParameter elseCopy = elseParam.shallowCopy(true, this.mLoggingManager);
                        ((ConditionalParentParameter)currentCopy).setElse(elseCopy);
                        elseCopy.addChildParameters(this.resolveVariationTreeChildren(elseParam));
                    }
                } else {
                    currentCopy = currentParameter.copy(this.mLoggingManager);
                }
                resolvedParameters.add(currentCopy);
            }
        }
        return resolvedParameters;
    }

    private void resolveAllDependentParameters(IVariationsInitializationHandle handle, ParentParameter parameter, ParentParameter scopeParent, ParentParameter rootParameter, InputScopeObject currentInputScope) throws RAREException {
        if (parameter.hasChildren()) {
            for (Parameter param : parameter.getParameters()) {
                DependentParameter dependentParam;
                List<String> dependentNames;
                if (DependentParameter.class.isInstance(param) && (dependentNames = (dependentParam = (DependentParameter)param).getDependentParametersNames()) != null) {
                    dependentParam.setDependentParameters(this.getParametersByName(dependentNames, scopeParent));
                    if (IResolvableParameter.class.isInstance(param)) {
                        ((IResolvableParameter)((Object)param)).resolve(handle, currentInputScope);
                    }
                }
                if (!ParentParameter.class.isInstance(param) || SubTemplateParameter.class.isInstance(param)) continue;
                if (IScopeParameter.class.isInstance(param)) {
                    this.resolveAllDependentParameters(handle, (ParentParameter)param, (ParentParameter)param, rootParameter, ((IScopeParameter)((Object)param)).getScope());
                    continue;
                }
                this.resolveAllDependentParameters(handle, (ParentParameter)param, scopeParent, rootParameter, currentInputScope);
            }
        }
    }

    private List<Parameter> getParametersByName(List<String> parameterNames, ParentParameter scopeRoot) {
        ArrayList<Parameter> visParameters = new ArrayList<Parameter>();
        for (String parameterName : parameterNames) {
            List<Parameter> paramReferences = this.getParameterDescedents(parameterName, scopeRoot);
            if (paramReferences == null) continue;
            visParameters.addAll(paramReferences);
        }
        return visParameters;
    }

    private List<Parameter> getParameterDescedents(String parameterPath, ParentParameter parentParameter) {
        List<Object> parameters = null;
        if (parameterPath != null) {
            Parameter currentParameter;
            boolean hasChildren;
            String paramName = parameterPath;
            String remainingPath = null;
            if (paramName.indexOf(46) != -1) {
                paramName = parameterPath.substring(0, parameterPath.indexOf(46));
                remainingPath = parameterPath.substring(parameterPath.indexOf(46) + 1);
            }
            boolean bl = hasChildren = ParentParameter.class.isInstance(currentParameter = parentParameter.getChildParameter(paramName)) && ((ParentParameter)currentParameter).hasChildren();
            if (LoopParameter.class.isInstance(currentParameter)) {
                parameters = new ArrayList<Parameter>();
                if (hasChildren) {
                    for (Parameter childParameter : ((LoopParameter)currentParameter).getParameters()) {
                        if (ParentParameter.class.isInstance(childParameter) && remainingPath != null) {
                            parameters.addAll(this.getParameterDescedents(remainingPath, (ParentParameter)childParameter));
                            continue;
                        }
                        parameters.add(childParameter);
                    }
                }
            } else if (remainingPath != null && hasChildren) {
                parameters = this.getParameterDescedents(remainingPath, (ParentParameter)currentParameter);
            } else {
                parameters = new ArrayList();
                parameters.add(currentParameter);
            }
        }
        return parameters;
    }
}

