/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.variationengine;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.VariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.CancelException;
import com.ibm.aurora.rare.core.exception.ParameterResolutionException;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.exception.VariationSerializationException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.parameter.DependentParameter;
import com.ibm.aurora.rare.core.parameter.MultiVariableParameter;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.ParentParameter;
import com.ibm.aurora.rare.core.parameter.VariableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IBindingParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IConditionalParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IResolutionGroupMember;
import com.ibm.aurora.rare.core.parameter.interfaces.IResolvableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IScopeParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IScorableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IValidationParameter;
import com.ibm.aurora.rare.core.score.Score;
import com.ibm.aurora.rare.core.score.ScoreRecord;
import com.ibm.aurora.rare.core.score.ScoringRec;
import com.ibm.aurora.rare.core.variationengine.DependentValidationAndScoringManager;
import com.ibm.aurora.rare.core.variationengine.Utils;
import com.ibm.aurora.rare.core.variationengine.VariationKeyScorePair;
import com.ibm.aurora.rare.core.variationengine.descriptors.GroupedScopeObjectDescriptor;
import com.ibm.aurora.rare.core.variationengine.descriptors.IGroupVariationDescriptor;
import com.ibm.aurora.rare.core.variationengine.descriptors.MultiDependentsDescriptor;
import com.ibm.aurora.rare.core.variationengine.descriptors.VariationDescriptor;
import com.ibm.aurora.rare.logging.ELogLevel;
import com.ibm.aurora.rare.logging.LoggingManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VariationsSerializationsEnumerator {
    protected VariationsSerializationsEnumerator() {
    }

    public static List<VariationKeyScorePair> getVariationKeys(IVariationsInitializationHandle handle, ParentParameter rootParameter, boolean bestOnly) throws RAREException {
        DependentValidationAndScoringManager validationAndScoringManager = new DependentValidationAndScoringManager(handle, rootParameter);
        List<VariationKeyScorePair> variationKeys = new ArrayList<VariationKeyScorePair>();
        List<VariationDescriptor> varationDescriptors = new ArrayList<VariationDescriptor>();
        varationDescriptors.add(new VariationDescriptor(new StringBuilder(), null, null, validationAndScoringManager.getValidationDescriptor(), validationAndScoringManager.getScoringDescriptor(), null));
        varationDescriptors = VariationsSerializationsEnumerator.addCurrentParentParameterVariations(handle, rootParameter, varationDescriptors, true, false, ((VariationsInitializationHandle)handle).getLoggingManager(), bestOnly);
        if (varationDescriptors != null && !varationDescriptors.isEmpty()) {
            varationDescriptors = VariationsSerializationsEnumerator.performFinalValidationAndScoring(varationDescriptors, ((VariationsInitializationHandle)handle).getLoggingManager());
            for (VariationDescriptor variationDescriptor : varationDescriptors) {
                variationKeys.add(new VariationKeyScorePair(variationDescriptor.getVariationKey(), new ScoringRec(variationDescriptor.getScore()), variationDescriptor.getBoundScopes()));
            }
        }
        Collections.sort(variationKeys);
        if (bestOnly && variationKeys.size() > 0) {
            variationKeys = variationKeys.subList(0, 1);
        }
        return variationKeys;
    }

    private static List<VariationDescriptor> performFinalValidationAndScoring(List<VariationDescriptor> varationDescriptors, LoggingManager loggingManager) throws RAREException {
        ArrayList<VariationDescriptor> finalVariationDescriptors = new ArrayList<VariationDescriptor>();
        for (VariationDescriptor variationDescriptor : varationDescriptors) {
            if (!VariationsSerializationsEnumerator.validateAllResolvedParameters(variationDescriptor.getDependentValidationDescriptor().getRemainingResolvedDependentParameters(), loggingManager)) continue;
            VariationsSerializationsEnumerator.scoreAllResolvedParameters(variationDescriptor.getDependentScoringDescriptor().getRemainingResolvedDependentParameters(), variationDescriptor.getScore());
            finalVariationDescriptors.add(variationDescriptor);
        }
        return finalVariationDescriptors;
    }

    private static boolean validateParameterList(List<Parameter> parameters, VariationDescriptor currentVariationDescriptor, LoggingManager loggingManager) throws VariationSerializationException {
        List<Parameter> validationParameters = Utils.getNonDependentParametersFromParameterList(parameters, IValidationParameter.class);
        for (Parameter param : validationParameters) {
            IValidationParameter validationParam = (IValidationParameter)((Object)param);
            try {
                if (validationParam.isValid()) continue;
                if (loggingManager.canLog(ELogLevel.DEBUG)) {
                    loggingManager.getLogger().debug("Validation Parameter " + ((Parameter)((Object)validationParam)).getFullName() + " did not validate");
                }
                return false;
            }
            catch (ParameterResolutionException e) {
                throw new VariationSerializationException(e);
            }
        }
        for (Parameter param : parameters) {
            if (!VariationsSerializationsEnumerator.canValidateDependentParameter(param) || VariationsSerializationsEnumerator.validateFromNewDependency(param, currentVariationDescriptor, loggingManager)) continue;
            return false;
        }
        return true;
    }

    private static boolean validateFromNewDependency(Parameter param, VariationDescriptor currentVariationDescriptor, LoggingManager loggingManager) throws VariationSerializationException {
        List<DependentParameter> resolvedDependentParameters = null;
        try {
            resolvedDependentParameters = currentVariationDescriptor.getDependentValidationDescriptor().addDependency(param);
        }
        catch (RAREException e) {
            VariationSerializationException exception = new VariationSerializationException("Error resolving parameter depedent on " + param.getFullName(), e);
            if (loggingManager.canLog()) {
                loggingManager.getLogger().error("Cannot resolve dependency on " + param.getFullName(), exception);
            }
            throw exception;
        }
        return VariationsSerializationsEnumerator.validateAllResolvedParameters(resolvedDependentParameters, loggingManager);
    }

    private static void scoreFromNewDependency(Parameter param, VariationDescriptor currentVariationDescriptor, LoggingManager loggingManager) throws VariationSerializationException {
        List<DependentParameter> resolvedDependentParameters = null;
        try {
            resolvedDependentParameters = currentVariationDescriptor.getDependentScoringDescriptor().addDependency(param);
        }
        catch (RAREException e) {
            VariationSerializationException exception = new VariationSerializationException("Error resolving parameter depedent on " + param.getFullName(), e);
            if (loggingManager.canLog()) {
                loggingManager.getLogger().error("Cannot resolve dependency on " + param.getFullName(), exception);
            }
            throw exception;
        }
        VariationsSerializationsEnumerator.scoreAllResolvedParameters(resolvedDependentParameters, currentVariationDescriptor.getScore());
    }

    private static boolean hasUnresolvedDependentParameters(Parameter param, VariationDescriptor currentVariationDescriptor, LoggingManager loggingManager) {
        return currentVariationDescriptor.getDependentScoringDescriptor().hasUnresolvedDependencies() || currentVariationDescriptor.getDependentValidationDescriptor().hasUnresolvedDependencies();
    }

    private static boolean validateAllResolvedParameters(List<DependentParameter> resolvedDependentParameters, LoggingManager loggingManager) throws VariationSerializationException {
        if (resolvedDependentParameters != null) {
            for (DependentParameter dependentParam : resolvedDependentParameters) {
                try {
                    if (!IValidationParameter.class.isInstance(dependentParam) || ((IValidationParameter)((Object)dependentParam)).isValid()) continue;
                    if (loggingManager.canLog(ELogLevel.DEBUG)) {
                        loggingManager.getLogger().debug("Dependent Validation Parameter " + dependentParam.getFullName() + " with dependencies: " + dependentParam.getDependentParametersNames() + " did not validate");
                    }
                    return false;
                }
                catch (ParameterResolutionException e) {
                    throw new VariationSerializationException(e);
                }
            }
        }
        return true;
    }

    private static void scoreParameterList(List<Parameter> parameters, VariationDescriptor currentVariationDescriptor, LoggingManager loggingManager) throws VariationSerializationException {
        List<Parameter> scoringParameters = Utils.getNonDependentParametersFromParameterList(parameters, IScorableParameter.class);
        for (Parameter param : scoringParameters) {
            IScorableParameter scoringParameter = (IScorableParameter)((Object)param);
            currentVariationDescriptor.getScore().addDescribedScore(VariationsSerializationsEnumerator.createScoreRec(scoringParameter));
        }
        for (Parameter param : parameters) {
            if (!VariationsSerializationsEnumerator.canValidateDependentParameter(param)) continue;
            VariationsSerializationsEnumerator.scoreFromNewDependency(param, currentVariationDescriptor, loggingManager);
        }
    }

    private static boolean canValidateDependentParameter(Parameter param) {
        if (IResolvableParameter.class.isInstance(param) && !((IResolvableParameter)((Object)param)).isResolved()) {
            return false;
        }
        return !VariableParameter.class.isInstance(param) || ((VariableParameter)param).getcurrentVariationIndex() != -1;
    }

    private static void scoreAllResolvedParameters(List<DependentParameter> resolvedDependentParameters, Score score) throws VariationSerializationException {
        if (resolvedDependentParameters != null) {
            for (DependentParameter dependentParam : resolvedDependentParameters) {
                if (!IScorableParameter.class.isInstance(dependentParam)) continue;
                score.addDescribedScore(VariationsSerializationsEnumerator.createScoreRec((IScorableParameter)((Object)dependentParam)));
            }
        }
    }

    private static ScoreRecord createScoreRec(IScorableParameter scoreParameter) throws VariationSerializationException {
        try {
            return new ScoreRecord(scoreParameter.getScore(), scoreParameter.getScoreDescription());
        }
        catch (ParameterResolutionException e) {
            throw new VariationSerializationException(e);
        }
    }

    private static void addBindingsToVariationDescriptor(List<Parameter> parameters, VariationDescriptor currentVariationDescriptor) throws VariationSerializationException {
        for (Parameter param : parameters) {
            VariationsSerializationsEnumerator.addBindingToVariationDescriptor(param, currentVariationDescriptor);
        }
    }

    private static void addBindingToVariationDescriptor(Parameter param, VariationDescriptor currentVariationDescriptor) throws VariationSerializationException {
        if (IBindingParameter.class.isInstance(param)) {
            InputScopeObject scope;
            try {
                scope = ((IScopeParameter)((Object)param)).getScope();
            }
            catch (ParameterResolutionException e) {
                throw new VariationSerializationException(e);
            }
            currentVariationDescriptor.addBoundScope(param.getFullName(), scope);
        }
    }

    private static List<VariationDescriptor> getVariationKeysFromVarationParameterList(IVariationsInitializationHandle handle, List<Parameter> parameters, VariationDescriptor currentVariationDescriptor, boolean scopeChange, boolean parentIsAvariableParameter, LoggingManager loggingManager, boolean bestOnly) throws VariationSerializationException {
        List<VariationDescriptor> varationDescriptors = new ArrayList<VariationDescriptor>();
        if (VariationsSerializationsEnumerator.validateParameterList(parameters, currentVariationDescriptor, loggingManager)) {
            VariationsSerializationsEnumerator.addBindingsToVariationDescriptor(parameters, currentVariationDescriptor);
            VariationsSerializationsEnumerator.scoreParameterList(parameters, currentVariationDescriptor, loggingManager);
            List<ParentParameter> parentParameters = Utils.getParentParametersFromParameterList(parameters);
            if (!parentParameters.isEmpty() && varationDescriptors != null) {
                int numParameters = parentParameters.size();
                VariationDescriptor variationDescriptor = scopeChange ? new VariationDescriptor(new StringBuilder(), currentVariationDescriptor.getScore(), null, currentVariationDescriptor.getDependentValidationDescriptor(), currentVariationDescriptor.getDependentScoringDescriptor(), currentVariationDescriptor.getBoundScopes()) : new VariationDescriptor(new StringBuilder(), currentVariationDescriptor);
                if (variationDescriptor.getGroupDescriptor() == null) {
                    variationDescriptor.overwriteGroupDescriptor(Utils.createEmptyGroupedVariationMap(parameters));
                }
                varationDescriptors.add(variationDescriptor);
                for (int i = 0; i < numParameters && varationDescriptors != null; ++i) {
                    ParentParameter parentParameter = parentParameters.get(i);
                    varationDescriptors = VariationsSerializationsEnumerator.addCurrentParentParameterVariations(handle, parentParameter, varationDescriptors, i == 0, parentIsAvariableParameter, loggingManager, bestOnly);
                }
                if (varationDescriptors != null) {
                    for (VariationDescriptor descriptor : varationDescriptors) {
                        if (Utils.isUnambiguousVariationSerializaion(descriptor.getVariationKey())) {
                            descriptor.setVariationKey(new StringBuilder());
                        }
                        if (descriptor.getVariationKey().length() > 0) {
                            descriptor.setVariationKey(new StringBuilder("(").append((CharSequence)descriptor.getVariationKey()).append(')'));
                        }
                        if (!scopeChange) continue;
                        descriptor.overwriteGroupDescriptor(currentVariationDescriptor.getGroupDescriptor());
                    }
                }
            }
            return varationDescriptors;
        }
        return null;
    }

    private static List<VariationDescriptor> addCurrentParentParameterVariations(IVariationsInitializationHandle handle, ParentParameter parentParameter, List<VariationDescriptor> variationsSoFar, boolean firstPass, boolean parentIsAvariableParameter, LoggingManager loggingManager, boolean bestOnly) throws VariationSerializationException {
        ArrayList<VariationDescriptor> variationKeys = null;
        if (handle.isCanceled()) {
            throw new CancelException();
        }
        for (VariationDescriptor variationSoFar : variationsSoFar) {
            List<VariationDescriptor> variationKeysFromParameter = VariationsSerializationsEnumerator.generateParentVariationKeys(handle, parentParameter, variationSoFar, parentIsAvariableParameter, loggingManager, bestOnly);
            if (variationKeysFromParameter == null) continue;
            if (variationKeys == null) {
                variationKeys = new ArrayList<VariationDescriptor>();
            }
            StringBuilder keySoFar = new StringBuilder(variationSoFar.getVariationKey());
            if (!firstPass) {
                keySoFar.append(",");
            }
            if (variationKeysFromParameter.isEmpty()) {
                variationKeys.add(new VariationDescriptor(keySoFar, variationSoFar));
                continue;
            }
            for (VariationDescriptor variationFromParent : variationKeysFromParameter) {
                if (variationFromParent.getVariationKey() == null) continue;
                VariationDescriptor varDesc = new VariationDescriptor(new StringBuilder(keySoFar).append((CharSequence)variationFromParent.getVariationKey()), variationFromParent);
                variationKeys.add(varDesc);
            }
        }
        return variationKeys;
    }

    private static List<VariationDescriptor> generateParentVariationKeys(IVariationsInitializationHandle handle, ParentParameter parentParameter, VariationDescriptor currentVariationDescriptor, boolean parentIsAvariableParameter, LoggingManager loggingManager, boolean bestOnly) throws VariationSerializationException {
        List<VariationDescriptor> variationKeys = new ArrayList<VariationDescriptor>();
        if (parentParameter.hasChildren()) {
            variationKeys = MultiVariableParameter.class.isInstance(parentParameter) ? VariationsSerializationsEnumerator.generateMultiVariableParameterVariationKeys(handle, (MultiVariableParameter)parentParameter, currentVariationDescriptor, loggingManager, bestOnly) : (VariableParameter.class.isInstance(parentParameter) ? VariationsSerializationsEnumerator.generateVariableParameterVariationKeys(handle, (VariableParameter)parentParameter, currentVariationDescriptor, loggingManager, bestOnly) : VariationsSerializationsEnumerator.generateParentParameterVariationKeys(handle, parentParameter, currentVariationDescriptor, parentIsAvariableParameter, loggingManager, bestOnly));
        }
        return variationKeys;
    }

    private static List<VariationDescriptor> generateParentParameterVariationKeys(IVariationsInitializationHandle handle, ParentParameter parentParameter, VariationDescriptor currentVariationDescriptor, boolean parentIsAvariableParameter, LoggingManager loggingManager, boolean bestOnly) throws VariationSerializationException {
        IGroupVariationDescriptor currentGroupDescriptor;
        ArrayList<VariationDescriptor> variationKeys = new ArrayList();
        if (!parentIsAvariableParameter && IScopeParameter.class.isInstance(parentParameter) && IResolutionGroupMember.class.isInstance(parentParameter) && (currentGroupDescriptor = VariationsSerializationsEnumerator.getCurrentGroupDescriptor((IResolutionGroupMember)((Object)parentParameter), currentVariationDescriptor.getGroupDescriptor())) != null && GroupedScopeObjectDescriptor.class.isInstance(currentGroupDescriptor)) {
            InputScopeObject scope;
            try {
                scope = ((IScopeParameter)((Object)parentParameter)).getScope();
            }
            catch (ParameterResolutionException e) {
                throw new VariationSerializationException(e);
            }
            GroupedScopeObjectDescriptor groupedScopeDescriptor = (GroupedScopeObjectDescriptor)currentGroupDescriptor;
            if (groupedScopeDescriptor.isScopeReserved(scope)) {
                return null;
            }
            groupedScopeDescriptor.reserveScope(scope, true);
        }
        variationKeys = VariationsSerializationsEnumerator.getVariationKeysFromVarationParameterList(handle, parentParameter.getParameters(), currentVariationDescriptor, IScopeParameter.class.isInstance(parentParameter), false, loggingManager, bestOnly);
        return variationKeys;
    }

    private static List<VariationDescriptor> generateMultiVariableParameterVariationKeys(IVariationsInitializationHandle handle, MultiVariableParameter multiVarParm, VariationDescriptor currentVariationDescriptor, LoggingManager loggingManager, boolean bestOnly) throws VariationSerializationException {
        List<VariationDescriptor> variationKeys = new ArrayList<VariationDescriptor>();
        try {
            IGroupVariationDescriptor currentGroupDescriptor = VariationsSerializationsEnumerator.getCurrentGroupDescriptor(multiVarParm, currentVariationDescriptor.getGroupDescriptor());
            List<int[]> varationOrderings = VariationsSerializationsEnumerator.getOrderingsFromMultiVariableParameter(multiVarParm, currentGroupDescriptor, loggingManager);
            Score currentScoreRec = currentVariationDescriptor.getScore();
            boolean hasDependencies = false;
            if (!varationOrderings.isEmpty()) {
                for (int[] varationOrdering : varationOrderings) {
                    int i;
                    if (currentGroupDescriptor != null) {
                        for (i = 0; i < varationOrdering.length; ++i) {
                            currentGroupDescriptor.reserveVariation(multiVarParm, varationOrdering[i], true);
                        }
                    }
                    multiVarParm.setAllVariationsInnactive();
                    for (i = 0; i < varationOrdering.length; ++i) {
                        multiVarParm.setVariationActive(varationOrdering[i], true);
                    }
                    List<Parameter> currentVariations = multiVarParm.getCurrentVariations();
                    if (!hasDependencies && VariationsSerializationsEnumerator.hasUnresolvedDependentParameters(multiVarParm, currentVariationDescriptor, loggingManager)) {
                        hasDependencies = true;
                    }
                    currentVariationDescriptor.setScore(currentScoreRec);
                    VariationsSerializationsEnumerator.scoreFromNewDependency(multiVarParm, currentVariationDescriptor, loggingManager);
                    if (VariationsSerializationsEnumerator.validateFromNewDependency(multiVarParm, currentVariationDescriptor, loggingManager)) {
                        VariationDescriptor variationDescriptor = new VariationDescriptor(new StringBuilder(), currentVariationDescriptor);
                        variationDescriptor.cloneDescriptors(multiVarParm, currentGroupDescriptor);
                        List<VariationDescriptor> subVarationDescriptors = VariationsSerializationsEnumerator.getVariationKeysFromVarationParameterList(handle, currentVariations, variationDescriptor, false, true, loggingManager, bestOnly);
                        if (subVarationDescriptors != null) {
                            if (subVarationDescriptors.isEmpty()) {
                                VariationDescriptor varDesc = new VariationDescriptor(multiVarParm.serializeVariationChoices(), variationDescriptor);
                                variationKeys.add(varDesc);
                                varDesc.setVariationOrder(varationOrdering);
                            } else {
                                for (VariationDescriptor subVariationDescriptor : subVarationDescriptors) {
                                    VariationDescriptor varDesc = new VariationDescriptor(multiVarParm.serializeVariationChoices().append((CharSequence)subVariationDescriptor.getVariationKey()), subVariationDescriptor);
                                    variationKeys.add(varDesc);
                                    varDesc.setVariationOrder(varationOrdering);
                                }
                            }
                        }
                    }
                    currentVariationDescriptor.getDependentValidationDescriptor().removeDependency(multiVarParm);
                    currentVariationDescriptor.getDependentScoringDescriptor().removeDependency(multiVarParm);
                    if (currentGroupDescriptor == null) continue;
                    for (i = 0; i < varationOrdering.length; ++i) {
                        currentGroupDescriptor.reserveVariation(multiVarParm, varationOrdering[i], false);
                    }
                }
            }
            if (variationKeys.isEmpty()) {
                variationKeys = null;
            } else if (bestOnly) {
                int maxRequiredSize = multiVarParm.getMaxNumBindingsInGroup() - multiVarParm.getMaxBindings();
                if (currentGroupDescriptor != null) {
                    maxRequiredSize -= currentGroupDescriptor.numReserved();
                }
                variationKeys = VariationsSerializationsEnumerator.getMinimalBestSetWithAllCombinationsOfnNodesUnbound(variationKeys, maxRequiredSize, multiVarParm.getNumVariations(), currentVariationDescriptor);
            }
        }
        catch (ParameterResolutionException pre) {
            throw new VariationSerializationException(pre);
        }
        return variationKeys;
    }

    private static List<VariationDescriptor> generateVariableParameterVariationKeys(IVariationsInitializationHandle handle, VariableParameter varParam, VariationDescriptor currentVariationDescriptor, LoggingManager loggingManager, boolean bestOnly) throws VariationSerializationException {
        List<VariationDescriptor> variationKeys = null;
        try {
            IGroupVariationDescriptor currentGroupDescriptor = VariationsSerializationsEnumerator.getCurrentGroupDescriptor(varParam, currentVariationDescriptor.getGroupDescriptor());
            List<Integer> allowedsubVariations = VariationsSerializationsEnumerator.getAllowedVariationIndexesFromVariableParameter(varParam, currentGroupDescriptor);
            Score currentScoreRec = currentVariationDescriptor.getScore();
            boolean hasDependencies = false;
            for (Integer variationIndex : allowedsubVariations) {
                if (currentGroupDescriptor != null) {
                    currentGroupDescriptor.reserveVariation(varParam, variationIndex, true);
                }
                varParam.setcurrentVariation(variationIndex);
                Parameter currentVariation = varParam.getCurrentVariation();
                if (!hasDependencies && VariationsSerializationsEnumerator.hasUnresolvedDependentParameters(varParam, currentVariationDescriptor, loggingManager)) {
                    hasDependencies = true;
                }
                currentVariationDescriptor.setScore(currentScoreRec);
                VariationsSerializationsEnumerator.scoreFromNewDependency(varParam, currentVariationDescriptor, loggingManager);
                if (VariationsSerializationsEnumerator.validateFromNewDependency(varParam, currentVariationDescriptor, loggingManager)) {
                    try {
                        if (ParentParameter.class.isInstance(currentVariation)) {
                            VariationDescriptor variationDescriptor = new VariationDescriptor(new StringBuilder(), currentVariationDescriptor);
                            variationDescriptor.cloneDescriptors(varParam, currentGroupDescriptor);
                            VariationsSerializationsEnumerator.addBindingToVariationDescriptor(currentVariation, variationDescriptor);
                            List<VariationDescriptor> subVarationDescriptors = VariationsSerializationsEnumerator.generateParentVariationKeys(handle, (ParentParameter)currentVariation, variationDescriptor, true, loggingManager, bestOnly);
                            if (subVarationDescriptors != null) {
                                if (variationKeys == null) {
                                    variationKeys = new ArrayList<VariationDescriptor>();
                                }
                                if (subVarationDescriptors.isEmpty()) {
                                    VariationDescriptor varDesc = new VariationDescriptor(varParam.serializeVariationChoices(), variationDescriptor);
                                    variationKeys.add(varDesc);
                                    varDesc.setVariationIndex(variationIndex);
                                } else {
                                    for (VariationDescriptor subVariationDescriptor : subVarationDescriptors) {
                                        VariationDescriptor varDesc = new VariationDescriptor(varParam.serializeVariationChoices().append('(').append((CharSequence)subVariationDescriptor.getVariationKey()).append(')'), subVariationDescriptor);
                                        variationKeys.add(varDesc);
                                        varDesc.setVariationIndex(variationIndex);
                                    }
                                }
                            }
                        } else if (!IValidationParameter.class.isInstance(currentVariation) || ((IValidationParameter)((Object)currentVariation)).isValid()) {
                            if (variationKeys == null) {
                                variationKeys = new ArrayList<VariationDescriptor>();
                            }
                            VariationDescriptor varDesc = new VariationDescriptor(varParam.serializeVariationChoices(), currentVariationDescriptor);
                            varDesc.cloneDescriptors(varParam, currentGroupDescriptor);
                            variationKeys.add(varDesc);
                            varDesc.setVariationIndex(variationIndex);
                        }
                    }
                    catch (ParameterResolutionException e) {
                        throw new VariationSerializationException(e);
                    }
                }
                currentVariationDescriptor.getDependentValidationDescriptor().removeDependency(varParam);
                currentVariationDescriptor.getDependentScoringDescriptor().removeDependency(varParam);
                if (currentGroupDescriptor == null) continue;
                currentGroupDescriptor.reserveVariation(varParam, variationIndex, false);
            }
            if (bestOnly && variationKeys != null) {
                int maxRequiredSize = varParam.getMaxNumBindingsInGroup() - 1;
                if (currentGroupDescriptor != null) {
                    maxRequiredSize -= currentGroupDescriptor.numReserved();
                }
                variationKeys = VariationsSerializationsEnumerator.getMinimalBestSetWithAllCombinationsOfnNodesUnbound(variationKeys, maxRequiredSize, varParam.getNumVariations(), currentVariationDescriptor);
            }
        }
        catch (ParameterResolutionException pre) {
            throw new VariationSerializationException(pre);
        }
        return variationKeys;
    }

    private static List<VariationDescriptor> getMinimalBestSetWithAllCombinationsOfnNodesUnbound(List<VariationDescriptor> variationKeys, int n, int numPositions, VariationDescriptor currentVariationDescriptor) {
        Collections.sort(variationKeys);
        MultiDependentsDescriptor currentValidationDescriptor = currentVariationDescriptor.getDependentValidationDescriptor();
        MultiDependentsDescriptor currentScoringDescriptor = currentVariationDescriptor.getDependentScoringDescriptor();
        ArrayList<VariationDescriptor> subSet = new ArrayList<VariationDescriptor>();
        HashSet<byte[]> dissalowedCombinations = new HashSet<byte[]>();
        byte[] emptyKey = Utils.generatePositionalKeyFromOrdering(new int[0], numPositions);
        dissalowedCombinations.add(emptyKey);
        HashSet<byte[]> keptCombinations = new HashSet<byte[]>();
        for (VariationDescriptor varDesc : variationKeys) {
            byte[] currentKeyAndRestrictions;
            Set<byte[]> nonOverlappingKeys;
            int[] varOrder = varDesc.getVariationOrder();
            byte[] currentKey = Utils.generatePositionalKeyFromOrdering(varOrder, numPositions);
            if (!dissalowedCombinations.isEmpty() && !keptCombinations.contains(currentKey) && (nonOverlappingKeys = Utils.getNonOverlappingPositionKeys(dissalowedCombinations, currentKeyAndRestrictions = currentKey)) != null) {
                for (byte[] nonOverlappingKey : nonOverlappingKeys) {
                    dissalowedCombinations.remove(nonOverlappingKey);
                    int keyLength = Utils.countActivePositionsInKey(nonOverlappingKey);
                    if (keyLength >= n) continue;
                    for (int position = 0; position < currentKeyAndRestrictions.length; ++position) {
                        if (!Utils.isKeyPositionActive(currentKeyAndRestrictions, position)) continue;
                        byte[] newKey = Utils.setKeyPositionActive(nonOverlappingKey, position);
                        dissalowedCombinations.add(newKey);
                    }
                }
                keptCombinations.add(currentKey);
            }
            if (keptCombinations.contains(currentKey)) {
                subSet.add(varDesc);
                continue;
            }
            MultiDependentsDescriptor newValidationDescriptor = varDesc.getDependentValidationDescriptor();
            MultiDependentsDescriptor newScoringDescriptor = varDesc.getDependentScoringDescriptor();
            if (currentValidationDescriptor.hasNewConsideredUnresolvedDependentParameters(newValidationDescriptor)) {
                subSet.add(varDesc);
            }
            if (!currentScoringDescriptor.hasNewConsideredUnresolvedDependentParameters(newScoringDescriptor)) continue;
            subSet.add(varDesc);
        }
        return subSet;
    }

    private static IGroupVariationDescriptor getCurrentGroupDescriptor(IResolutionGroupMember resolutionGroupMember, Map<String, IGroupVariationDescriptor> groupVariationDescriptors) {
        if (groupVariationDescriptors.containsKey(resolutionGroupMember.getResolutionGroupName())) {
            return groupVariationDescriptors.get(resolutionGroupMember.getResolutionGroupName());
        }
        return null;
    }

    private static List<Integer> getAllowedVariationIndexesFromVariableParameter(VariableParameter varParameter, IGroupVariationDescriptor currentGroupDescriptor) throws VariationSerializationException, ParameterResolutionException {
        ArrayList<Integer> allowedVariations = new ArrayList<Integer>();
        boolean allowMultipleVariations = varParameter.enumerateAllVariationsActive();
        for (int i = 0; i < varParameter.getNumVariations() && (allowMultipleVariations || allowedVariations.isEmpty()); ++i) {
            Parameter childParam;
            if (currentGroupDescriptor != null && currentGroupDescriptor.isVariationReserved(varParameter, i) || IConditionalParameter.class.isInstance(childParam = varParameter.getParameters().get(i)) && !((IConditionalParameter)((Object)childParam)).isValid()) continue;
            allowedVariations.add(i);
        }
        return allowedVariations;
    }

    private static List<int[]> getOrderingsFromMultiVariableParameter(MultiVariableParameter multiVarParameter, IGroupVariationDescriptor currentGroupDescriptor, LoggingManager loggingManager) throws VariationSerializationException, ParameterResolutionException {
        int minSize;
        int i;
        int bindingSize = multiVarParameter.getNumVariations();
        boolean[] reservedVariations = new boolean[bindingSize];
        if (currentGroupDescriptor != null) {
            for (i = 0; i < reservedVariations.length; ++i) {
                boolean isReserved;
                reservedVariations[i] = isReserved = currentGroupDescriptor.isVariationReserved(multiVarParameter, i);
                if (!isReserved) continue;
                --bindingSize;
            }
        } else {
            for (i = 0; i < reservedVariations.length; ++i) {
                reservedVariations[i] = false;
            }
        }
        for (i = 0; i < reservedVariations.length; ++i) {
            Parameter childParam;
            if (reservedVariations[i] || !IConditionalParameter.class.isInstance(childParam = multiVarParameter.getParameters().get(i)) || ((IConditionalParameter)((Object)childParam)).isValid()) continue;
            reservedVariations[i] = true;
            --bindingSize;
        }
        int maxSize = multiVarParameter.getMaxBindings() > bindingSize ? bindingSize : multiVarParameter.getMaxBindings();
        int n = minSize = multiVarParameter.allowsBindingSizeVariations() ? multiVarParameter.getMinBindings() : maxSize;
        if (minSize > maxSize) {
            maxSize = minSize;
        }
        ArrayList<int[]> variations = new ArrayList<int[]>();
        if (multiVarParameter.getMinBindings() > bindingSize) {
            return variations;
        }
        for (int size = maxSize; size >= minSize; --size) {
            variations.addAll(Utils.generatePossibleOrderingsForMultiGroup(reservedVariations, size, multiVarParameter.enumerateAllVariationsActive(), multiVarParameter.enumerateAllOrders(), loggingManager));
        }
        return variations;
    }
}

