/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.variationengine.descriptors;

import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupedOutputsDescriptor {
    private int mMinRequiredBindings = 0;
    private int mMaxRequiredBindings = 0;
    private Map<InputScopeObject, Integer> mPossibleInputs = new HashMap<InputScopeObject, Integer>();

    public void addInputs(List<? extends InputScopeObject> inputs) {
        for (InputScopeObject inputScopeObject : inputs) {
            Map.Entry<InputScopeObject, Integer> entry = GroupedOutputsDescriptor.getEquivalentEntry(this.mPossibleInputs, inputScopeObject);
            if (entry == null) {
                this.mPossibleInputs.put(inputScopeObject, 1);
                continue;
            }
            this.mPossibleInputs.put(entry.getKey(), entry.getValue() + 1);
        }
    }

    public void registerMinRequired(int min) {
        this.mMinRequiredBindings += min;
    }

    public void registerMaxRequired(int max) {
        this.mMaxRequiredBindings += max;
    }

    public int getMinRequiredBindingsInGroup() {
        return this.mMinRequiredBindings;
    }

    public int getMaxRequiredBindingsInGroup() {
        return this.mMaxRequiredBindings;
    }

    public int getTotalBindingsInGroup() {
        return this.mPossibleInputs.size();
    }

    public int reserveBindings(int max, List<? extends InputScopeObject> inputs) {
        int count = 0;
        if (count < max) {
            ArrayList<ComparableEntry> possibleEntryList = new ArrayList<ComparableEntry>();
            for (InputScopeObject inputScopeObject : inputs) {
                Map.Entry<InputScopeObject, Integer> entry = GroupedOutputsDescriptor.getEquivalentEntry(this.mPossibleInputs, inputScopeObject);
                if (entry == null) continue;
                possibleEntryList.add(new ComparableEntry(entry));
            }
            Collections.sort(possibleEntryList);
            if (count < max) {
                for (ComparableEntry comparableEntry : possibleEntryList) {
                    this.mPossibleInputs.remove(comparableEntry.getEntry().getKey());
                    if (++count < max) continue;
                    break;
                }
            }
        }
        for (InputScopeObject inputScopeObject : inputs) {
            Map.Entry<InputScopeObject, Integer> entry = GroupedOutputsDescriptor.getEquivalentEntry(this.mPossibleInputs, inputScopeObject);
            if (entry == null) continue;
            this.mPossibleInputs.put(entry.getKey(), entry.getValue() - 1);
        }
        return count;
    }

    public void reregisterInputs(List<? extends InputScopeObject> inputs) {
        for (InputScopeObject inputScopeObject : inputs) {
            Map.Entry<InputScopeObject, Integer> entry = GroupedOutputsDescriptor.getEquivalentEntry(this.mPossibleInputs, inputScopeObject);
            if (entry == null) continue;
            this.mPossibleInputs.put(entry.getKey(), entry.getValue() + 1);
        }
    }

    private static Map.Entry<InputScopeObject, Integer> getEquivalentEntry(Map<InputScopeObject, Integer> map, InputScopeObject scopeObj) {
        for (Map.Entry<InputScopeObject, Integer> entry : map.entrySet()) {
            if (!entry.getKey().equals(scopeObj)) continue;
            return entry;
        }
        return null;
    }

    private class ComparableEntry
    implements Comparable<ComparableEntry> {
        private final Map.Entry<InputScopeObject, Integer> mEntry;
        private final int mValue;

        public ComparableEntry(Map.Entry<InputScopeObject, Integer> entry) {
            this.mEntry = entry;
            this.mValue = entry.getValue();
        }

        public Map.Entry<InputScopeObject, Integer> getEntry() {
            return this.mEntry;
        }

        @Override
        public int compareTo(ComparableEntry compareTo) {
            if (compareTo.mValue > this.mValue) {
                return -1;
            }
            if (compareTo.mValue < this.mValue) {
                return 1;
            }
            return 0;
        }
    }
}

