/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.variationengine.descriptors;

import com.ibm.aurora.rare.core.exception.ParameterResolutionException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.parameter.VariableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IScopeParameter;
import com.ibm.aurora.rare.core.variationengine.descriptors.IGroupVariationDescriptor;
import java.util.HashMap;
import java.util.Map;

public class GroupedScopeObjectDescriptor
implements IGroupVariationDescriptor,
Cloneable {
    private Map<InputScopeObject, Boolean> mReservedVariations = null;

    public GroupedScopeObjectDescriptor() {
    }

    public GroupedScopeObjectDescriptor(GroupedScopeObjectDescriptor descriptor) {
        if (descriptor.mReservedVariations != null) {
            this.mReservedVariations = new HashMap<InputScopeObject, Boolean>();
            this.mReservedVariations.putAll(descriptor.mReservedVariations);
        }
    }

    public void reserveScope(InputScopeObject currentScope, boolean reserved) {
        InputScopeObject equivalentScope;
        if (this.mReservedVariations == null) {
            this.mReservedVariations = new HashMap<InputScopeObject, Boolean>();
        }
        if ((equivalentScope = this.getEquivalentScopeObjInReservedSet(currentScope)) != null) {
            this.mReservedVariations.put(equivalentScope, reserved);
        } else {
            this.mReservedVariations.put(currentScope, reserved);
        }
    }

    @Override
    public void reserveVariation(VariableParameter param, int choice, boolean reserved) throws ParameterResolutionException {
        IScopeParameter currentVariation;
        InputScopeObject currentScope;
        param.setcurrentVariation(choice);
        if (IScopeParameter.class.isInstance(param.getCurrentVariation()) && (currentScope = (currentVariation = (IScopeParameter)((Object)param.getCurrentVariation())).getScope()) != null) {
            this.reserveScope(currentScope, reserved);
        }
    }

    public boolean isScopeReserved(InputScopeObject currentScope) {
        if (this.mReservedVariations != null) {
            return this.mReservedVariations.containsKey(currentScope) && this.mReservedVariations.get(currentScope) != false;
        }
        return false;
    }

    @Override
    public boolean isVariationReserved(VariableParameter param, int choice) throws ParameterResolutionException {
        if (param.getNumVariations() > choice) {
            IScopeParameter currentVariation;
            InputScopeObject currentScope;
            param.setcurrentVariation(choice);
            if (IScopeParameter.class.isInstance(param.getCurrentVariation()) && (currentScope = this.getEquivalentScopeObjInReservedSet((currentVariation = (IScopeParameter)((Object)param.getCurrentVariation())).getScope())) != null) {
                return this.isScopeReserved(currentScope);
            }
        }
        return false;
    }

    private InputScopeObject getEquivalentScopeObjInReservedSet(InputScopeObject scopeObj) {
        if (scopeObj != null && this.mReservedVariations != null) {
            if (this.mReservedVariations.containsKey(scopeObj)) {
                return scopeObj;
            }
            for (InputScopeObject checkScope : this.mReservedVariations.keySet()) {
                if (checkScope == null || !checkScope.equals(scopeObj)) continue;
                return checkScope;
            }
        }
        return null;
    }

    @Override
    public IGroupVariationDescriptor clone() {
        return new GroupedScopeObjectDescriptor(this);
    }

    @Override
    public int numReserved() {
        int numReserved = 0;
        if (this.mReservedVariations != null) {
            for (InputScopeObject checkScope : this.mReservedVariations.keySet()) {
                if (checkScope == null || !this.mReservedVariations.get(checkScope).booleanValue()) continue;
                ++numReserved;
            }
        }
        return numReserved;
    }
}

