/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.variationengine.descriptors;

import com.ibm.aurora.rare.core.parameter.VariableParameter;
import com.ibm.aurora.rare.core.variationengine.descriptors.IGroupVariationDescriptor;

public class GroupedVariationDescriptor
implements IGroupVariationDescriptor,
Cloneable {
    private boolean[] mReservedVariations = null;

    public GroupedVariationDescriptor() {
    }

    public GroupedVariationDescriptor(GroupedVariationDescriptor descriptor) {
        if (descriptor.mReservedVariations != null) {
            this.mReservedVariations = (boolean[])descriptor.mReservedVariations.clone();
        }
    }

    @Override
    public void reserveVariation(VariableParameter param, int choice, boolean reserved) {
        if (this.mReservedVariations == null) {
            this.mReservedVariations = new boolean[param.getNumVariations()];
            for (int i = 0; i < this.mReservedVariations.length; ++i) {
                this.mReservedVariations[i] = false;
            }
        }
        this.mReservedVariations[choice] = reserved;
    }

    @Override
    public boolean isVariationReserved(VariableParameter param, int choice) {
        if (this.mReservedVariations != null && choice < this.mReservedVariations.length) {
            return this.mReservedVariations[choice];
        }
        return false;
    }

    @Override
    public IGroupVariationDescriptor clone() {
        return new GroupedVariationDescriptor(this);
    }

    @Override
    public int numReserved() {
        int numReserved = 0;
        for (int i = 0; i < this.mReservedVariations.length; ++i) {
            if (!this.mReservedVariations[i]) continue;
            ++numReserved;
        }
        return numReserved;
    }
}

