/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.variationengine.descriptors;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.VariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.parameter.DependentParameter;
import com.ibm.aurora.rare.core.parameter.MultiVariableParameter;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.VariableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IResolvableParameter;
import com.ibm.aurora.rare.core.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiDependentsDescriptor
implements Cloneable {
    private Set<String> mParameterDependencyPaths = null;
    private Map<String, Pair<Parameter, StringBuilder>> mParameterDependencies = new HashMap<String, Pair<Parameter, StringBuilder>>();
    private Map<String, DependentParameter> mUnresolvedDependentParameters = null;
    private Set<String> mResolvedDependentParameters = new HashSet<String>();
    private final IVariationsInitializationHandle mHandle;

    public MultiDependentsDescriptor(IVariationsInitializationHandle handle) {
        this.mHandle = handle;
    }

    public void addDependentParameter(DependentParameter parameter) {
        if (this.mParameterDependencyPaths == null) {
            this.mParameterDependencyPaths = new HashSet<String>();
        }
        if (this.mUnresolvedDependentParameters == null) {
            this.mUnresolvedDependentParameters = new HashMap<String, DependentParameter>();
        }
        if (parameter.isDependent() && IResolvableParameter.class.isInstance(parameter)) {
            for (String dependencyName : parameter.getDependentParametersNames()) {
                this.mParameterDependencyPaths.add(dependencyName);
            }
            this.mUnresolvedDependentParameters.put(parameter.getFullName(), parameter);
        }
    }

    public List<DependentParameter> addDependency(Parameter parameter) throws RAREException {
        String path;
        if (this.mParameterDependencyPaths != null && this.mParameterDependencyPaths.contains(path = parameter.getFullName())) {
            Parameter dependency = parameter;
            if (VariableParameter.class.isInstance(dependency)) {
                this.mParameterDependencies.put(path, new Pair<Parameter, StringBuilder>(dependency, ((VariableParameter)dependency).serializeVariationChoices()));
            } else {
                this.mParameterDependencies.put(path, new Pair<Parameter, Object>(dependency, null));
            }
            return this.getNewResolvedDependentParameters();
        }
        return null;
    }

    public void removeDependency(Parameter parameter) {
        String path = parameter.getFullName();
        if (this.mParameterDependencies.containsKey(path)) {
            this.mParameterDependencies.remove(path);
            this.removeNonResolvableDependentParameters();
        }
    }

    public boolean hasUnresolvedDependencies() {
        return this.mUnresolvedDependentParameters != null && this.mUnresolvedDependentParameters.size() != this.mResolvedDependentParameters.size();
    }

    public boolean hasNewConsideredUnresolvedDependentParameters(MultiDependentsDescriptor newerDescriptor) {
        if (this.mParameterDependencies.size() < newerDescriptor.mParameterDependencies.size()) {
            for (String dependencyName : newerDescriptor.mParameterDependencies.keySet()) {
                if (this.mParameterDependencies.containsKey(dependencyName)) continue;
                for (String dependentParamKey : newerDescriptor.mUnresolvedDependentParameters.keySet()) {
                    DependentParameter depParam;
                    if (newerDescriptor.mResolvedDependentParameters.contains(dependentParamKey) || !(depParam = newerDescriptor.mUnresolvedDependentParameters.get(dependentParamKey)).getDependentParametersNames().contains(dependencyName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public MultiDependentsDescriptor clone() {
        MultiDependentsDescriptor newDescriptor = new MultiDependentsDescriptor(this.mHandle);
        newDescriptor.mUnresolvedDependentParameters = this.mUnresolvedDependentParameters;
        newDescriptor.mParameterDependencyPaths = this.mParameterDependencyPaths;
        newDescriptor.mParameterDependencies.putAll(this.mParameterDependencies);
        newDescriptor.mResolvedDependentParameters.addAll(this.mResolvedDependentParameters);
        return newDescriptor;
    }

    public List<DependentParameter> getRemainingResolvedDependentParameters() throws RAREException {
        ArrayList<DependentParameter> parameters = new ArrayList<DependentParameter>();
        if (this.mUnresolvedDependentParameters != null) {
            for (Map.Entry<String, DependentParameter> dependentEntry : this.mUnresolvedDependentParameters.entrySet()) {
                DependentParameter dependentParam = dependentEntry.getValue();
                if (this.mResolvedDependentParameters.contains(dependentEntry.getKey())) continue;
                DependentParameter dependentParamCopy = (DependentParameter)dependentParam.copy(((VariationsInitializationHandle)this.mHandle).getLoggingManager());
                this.setParameterDependencies(dependentParamCopy);
                ((IResolvableParameter)((Object)dependentParamCopy)).resolve(this.mHandle, null);
                parameters.add(dependentParamCopy);
            }
        }
        return parameters;
    }

    private List<DependentParameter> getNewResolvedDependentParameters() throws RAREException {
        ArrayList<DependentParameter> parameters = new ArrayList<DependentParameter>();
        if (this.mUnresolvedDependentParameters != null) {
            for (Map.Entry<String, DependentParameter> dependentEntry : this.mUnresolvedDependentParameters.entrySet()) {
                DependentParameter dependentParam = dependentEntry.getValue();
                if (this.mResolvedDependentParameters.contains(dependentEntry.getKey()) || !this.isParameterResolvable(dependentParam)) continue;
                DependentParameter dependentParamCopy = (DependentParameter)dependentParam.copy(((VariationsInitializationHandle)this.mHandle).getLoggingManager());
                this.setParameterDependencies(dependentParamCopy);
                ((IResolvableParameter)((Object)dependentParamCopy)).resolve(this.mHandle, null);
                parameters.add(dependentParamCopy);
                this.mResolvedDependentParameters.add(dependentEntry.getKey());
            }
        }
        return parameters;
    }

    private void removeNonResolvableDependentParameters() {
        if (this.mUnresolvedDependentParameters != null) {
            ArrayList<String> parametersToRemove = new ArrayList<String>();
            for (String path : this.mResolvedDependentParameters) {
                if (this.isParameterResolvable(this.mUnresolvedDependentParameters.get(path))) continue;
                parametersToRemove.add(path);
            }
            for (String path : parametersToRemove) {
                this.mResolvedDependentParameters.remove(path);
            }
        }
    }

    private boolean isParameterResolvable(DependentParameter dependentParam) {
        for (String path : dependentParam.getDependentParametersNames()) {
            if (this.mParameterDependencies.containsKey(path)) continue;
            return false;
        }
        return true;
    }

    private void setParameterDependencies(DependentParameter parameter) {
        ArrayList<Parameter> dependencies = new ArrayList<Parameter>();
        for (String path : parameter.getDependentParametersNames()) {
            Pair<Parameter, StringBuilder> dependencyPair = this.mParameterDependencies.get(path);
            if (dependencyPair == null) continue;
            Parameter dependentParameter = dependencyPair.getFirst();
            if (MultiVariableParameter.class.isInstance(dependentParameter)) {
                ((MultiVariableParameter)dependentParameter).deserializeVariationChoices(dependencyPair.getSecond(), 0);
                if (((MultiVariableParameter)dependentParameter).isTransient()) {
                    for (Parameter choice : ((MultiVariableParameter)dependentParameter).getCurrentVariations()) {
                        dependencies.add(choice);
                    }
                    continue;
                }
                dependencies.add(dependentParameter);
                continue;
            }
            if (VariableParameter.class.isInstance(dependentParameter)) {
                ((VariableParameter)dependentParameter).deserializeVariationChoices(dependencyPair.getSecond(), 0);
                if (((VariableParameter)dependentParameter).isTransient()) {
                    dependencies.add(((VariableParameter)dependentParameter).getCurrentVariation());
                    continue;
                }
                dependencies.add(dependentParameter);
                continue;
            }
            dependencies.add(dependentParameter);
        }
        parameter.setDependentParameters(dependencies);
    }
}

