/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.core.variationengine.descriptors;

import com.ibm.aurora.rare.core.exception.VariationSerializationException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.parameter.interfaces.IResolutionGroupMember;
import com.ibm.aurora.rare.core.score.Score;
import com.ibm.aurora.rare.core.variationengine.descriptors.IGroupVariationDescriptor;
import com.ibm.aurora.rare.core.variationengine.descriptors.MultiDependentsDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VariationDescriptor
implements Comparable<VariationDescriptor> {
    private int[] variationOrder = null;
    private StringBuilder variationKey;
    private Score score = null;
    private Map<String, IGroupVariationDescriptor> groupDescriptor;
    private MultiDependentsDescriptor dependentValidationDescriptor;
    private MultiDependentsDescriptor dependentScoringDescriptor;
    private Map<String, List<InputScopeObject>> boundScopes = null;

    public VariationDescriptor(StringBuilder theVariationKey, VariationDescriptor varDesc) throws VariationSerializationException {
        this.variationKey = theVariationKey;
        if (varDesc != null) {
            this.score = varDesc.score;
            this.overwriteGroupDescriptor(varDesc.groupDescriptor);
            this.setDependentValidationDescriptor(varDesc.dependentValidationDescriptor);
            this.setDependentScoringDescriptor(varDesc.dependentScoringDescriptor);
            this.addBoundScopes(varDesc.boundScopes);
        }
    }

    public VariationDescriptor(StringBuilder theVariationKey, Score theScore, Map<String, IGroupVariationDescriptor> theGroupDescriptor, MultiDependentsDescriptor theDependentValidationDescriptor, MultiDependentsDescriptor theDependentScoringDescriptor, Map<String, List<InputScopeObject>> boundScopes) throws VariationSerializationException {
        this.variationKey = theVariationKey;
        this.score = theScore;
        this.overwriteGroupDescriptor(theGroupDescriptor);
        this.setDependentValidationDescriptor(theDependentValidationDescriptor);
        this.setDependentScoringDescriptor(theDependentScoringDescriptor);
        this.addBoundScopes(boundScopes);
    }

    public final void cloneDescriptors(IResolutionGroupMember resolutionGroupMember, IGroupVariationDescriptor inGroupDescriptor) throws VariationSerializationException {
        if (inGroupDescriptor != null) {
            Map<String, IGroupVariationDescriptor> oldDescriptor = this.groupDescriptor;
            this.groupDescriptor = new HashMap<String, IGroupVariationDescriptor>();
            this.groupDescriptor.putAll(oldDescriptor);
            this.groupDescriptor.put(resolutionGroupMember.getResolutionGroupName(), inGroupDescriptor.clone());
        }
        this.dependentValidationDescriptor = this.dependentValidationDescriptor.clone();
        this.dependentScoringDescriptor = this.dependentScoringDescriptor.clone();
    }

    public final void overwriteGroupDescriptor(Map<String, IGroupVariationDescriptor> inGroupDescriptor) throws VariationSerializationException {
        this.groupDescriptor = inGroupDescriptor;
    }

    private final void setDependentValidationDescriptor(MultiDependentsDescriptor theDependentValidationDescriptor) throws VariationSerializationException {
        if (theDependentValidationDescriptor != null) {
            this.dependentValidationDescriptor = theDependentValidationDescriptor;
        }
    }

    private final void setDependentScoringDescriptor(MultiDependentsDescriptor theDependentScoringDescriptor) throws VariationSerializationException {
        if (theDependentScoringDescriptor != null) {
            this.dependentScoringDescriptor = theDependentScoringDescriptor;
        }
    }

    public StringBuilder getVariationKey() {
        return this.variationKey;
    }

    public void setVariationKey(StringBuilder key) {
        this.variationKey = key;
    }

    public Score getScore() {
        if (this.score == null) {
            this.score = new Score();
        }
        return this.score;
    }

    public float getScoreValue() {
        return this.score.getScore();
    }

    public void setScore(Score score) {
        this.score = score.clone();
    }

    public Map<String, IGroupVariationDescriptor> getGroupDescriptor() {
        return this.groupDescriptor;
    }

    public MultiDependentsDescriptor getDependentValidationDescriptor() {
        return this.dependentValidationDescriptor;
    }

    public MultiDependentsDescriptor getDependentScoringDescriptor() {
        return this.dependentScoringDescriptor;
    }

    public Map<String, List<InputScopeObject>> getBoundScopes() {
        return this.boundScopes;
    }

    public void addBoundScope(String parameterName, InputScopeObject boundScope) {
        if (this.boundScopes == null) {
            this.boundScopes = new HashMap<String, List<InputScopeObject>>();
        }
        if (!this.boundScopes.containsKey(parameterName)) {
            this.boundScopes.put(parameterName, new ArrayList());
        }
        this.boundScopes.get(parameterName).add(boundScope);
    }

    public void addBoundScopes(Map<String, List<InputScopeObject>> boundScopeObjs) {
        if (boundScopeObjs != null) {
            if (this.boundScopes == null) {
                this.boundScopes = new HashMap<String, List<InputScopeObject>>();
            }
            for (Map.Entry<String, List<InputScopeObject>> boundScopesEntry : boundScopeObjs.entrySet()) {
                ArrayList scopeListCopy = new ArrayList();
                scopeListCopy.addAll(boundScopesEntry.getValue());
                this.boundScopes.put(boundScopesEntry.getKey(), scopeListCopy);
            }
        }
    }

    @Override
    public int compareTo(VariationDescriptor varDesc) {
        if (varDesc.getScoreValue() > this.getScoreValue()) {
            return 1;
        }
        if (varDesc.getScoreValue() < this.getScoreValue()) {
            return -1;
        }
        return 0;
    }

    public void setVariationIndex(int varIdx) {
        this.variationOrder = new int[1];
        this.variationOrder[0] = varIdx;
    }

    public void setVariationOrder(int[] varOrder) {
        this.variationOrder = varOrder;
    }

    public int[] getVariationOrder() {
        return this.variationOrder;
    }
}

