/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.logging;

import com.ibm.aurora.rare.logging.ELogLevel;
import com.ibm.aurora.rare.logging.ILogger;

public abstract class BaseLogger
implements ILogger {
    protected ELogLevel mLogLevel;

    public BaseLogger(ELogLevel logLevel) {
        this.mLogLevel = logLevel;
    }

    @Override
    public ELogLevel getLevel() {
        return this.mLogLevel;
    }

    @Override
    public boolean isEnabledFor(ELogLevel level) {
        return this.mLogLevel.compareTo(level) >= 0;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabledFor(ELogLevel.DEBUG);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabledFor(ELogLevel.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabledFor(ELogLevel.WARN);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabledFor(ELogLevel.ERROR);
    }

    @Override
    public void error(Object message) {
        this.log(ELogLevel.ERROR, message);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.log(ELogLevel.ERROR, message, t);
    }

    @Override
    public void warn(Object message) {
        this.log(ELogLevel.WARN, message);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.log(ELogLevel.WARN, message, t);
    }

    @Override
    public void info(Object message) {
        this.log(ELogLevel.INFO, message);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.log(ELogLevel.INFO, message, t);
    }

    @Override
    public void debug(Object message) {
        this.log(ELogLevel.DEBUG, message);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.log(ELogLevel.DEBUG, message, t);
    }
}

