/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.logging;

import com.ibm.aurora.rare.core.utils.XMLHelperD4J;
import com.ibm.aurora.rare.logging.BaseLogger;
import com.ibm.aurora.rare.logging.ELogLevel;
import java.io.IOException;
import java.io.OutputStream;

public class RAREXMLLogger
extends BaseLogger {
    private static final String DEFAULT_ROOT_NAME = "log";
    private OutputStream mLogginStream;
    private int mIndent;

    public RAREXMLLogger(OutputStream loggingStream, ELogLevel logLevel) {
        this(loggingStream, logLevel, DEFAULT_ROOT_NAME);
    }

    public RAREXMLLogger(OutputStream loggingStream, ELogLevel logLevel, String rootSectionName) {
        super(logLevel);
        this.mLogginStream = loggingStream;
        this.mIndent = 0;
        this.beginSection(rootSectionName);
    }

    public void endLog() {
        this.endSection(DEFAULT_ROOT_NAME);
    }

    @Override
    public void log(ELogLevel level, Object message) {
        if (this.isEnabledFor(level)) {
            StringBuffer strbuf = new StringBuffer();
            this.addIndent(strbuf, this.mIndent);
            strbuf.append('<');
            strbuf.append(level.toString());
            strbuf.append('>');
            strbuf.append(XMLHelperD4J.encode(message.toString()));
            strbuf.append("</");
            strbuf.append(level.toString());
            strbuf.append(">\n");
            this.writeStringBuffer(strbuf);
        }
    }

    @Override
    public void log(ELogLevel level, Object message, Throwable t) {
        if (this.isEnabledFor(level)) {
            StringBuffer strbuf = new StringBuffer();
            this.addIndent(strbuf, this.mIndent);
            strbuf.append('<');
            strbuf.append(level.toString());
            strbuf.append(">\n");
            this.addIndent(strbuf, this.mIndent + 1);
            strbuf.append(XMLHelperD4J.encode(message.toString()));
            strbuf.append('\n');
            this.addIndent(strbuf, this.mIndent + 1);
            strbuf.append("<exception>");
            strbuf.append(t.getLocalizedMessage());
            strbuf.append("</exception>\n");
            this.addIndent(strbuf, this.mIndent);
            strbuf.append("</");
            strbuf.append(level.toString());
            strbuf.append(">\n");
            this.writeStringBuffer(strbuf);
        }
    }

    @Override
    public void beginSection(Object section) {
        if (this.getLevel() != ELogLevel.OFF) {
            StringBuffer strbuf = new StringBuffer();
            this.addIndent(strbuf, this.mIndent);
            strbuf.append('<');
            strbuf.append(section.toString().replace(' ', '_'));
            strbuf.append(">\n");
            ++this.mIndent;
            this.writeStringBuffer(strbuf);
        }
    }

    @Override
    public void endSection(Object section) {
        if (this.getLevel() != ELogLevel.OFF) {
            --this.mIndent;
            StringBuffer strbuf = new StringBuffer();
            this.addIndent(strbuf, this.mIndent);
            strbuf.append("</");
            strbuf.append(section.toString().replace(' ', '_'));
            strbuf.append(">\n");
            this.writeStringBuffer(strbuf);
        }
    }

    private void writeStringBuffer(StringBuffer strbuf) {
        try {
            this.mLogginStream.write(String.valueOf(strbuf).getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addIndent(StringBuffer strbuf, int indent) {
        for (int i = 0; i < indent; ++i) {
            strbuf.append('\t');
        }
    }
}

