/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.smdrules.childrules;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.RuleException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.rule.IBooleanRule;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelScopeIterator;
import com.ibm.aurora.rare.smdrules.rules.BaseRule;
import com.ibm.aurora.rare.smdrules.utils.RulesUtil;
import java.util.List;
import java.util.Map;

public class ConceptNodesCount
extends BaseRule
implements IBooleanRule {
    static final String PARAM_CONCEPT = "concept";
    static final String PARAM_MAXCOUNT = "maxCount";
    static final String PARAM_MINCOUNT = "minCount";
    static final String PARAM_INCLUSIONS = "include";
    static final String PARAM_EXCLUSIONS = "exclude";
    private String _concept = null;
    private long _maxCount = Long.MAX_VALUE;
    private long _minCount = 0L;
    private String _inclusions = null;
    private String _exclusions = null;

    @Override
    public void setProperties(Map<String, String> properties) {
        super.setProperties(properties);
        this._concept = RulesUtil.getAttribute(PARAM_CONCEPT, properties, this._concept);
        this._maxCount = RulesUtil.getAttribute(PARAM_MAXCOUNT, properties, this._maxCount);
        this._minCount = RulesUtil.getAttribute(PARAM_MINCOUNT, properties, this._minCount);
        this._inclusions = RulesUtil.getAttribute(PARAM_INCLUSIONS, properties, this._inclusions);
        this._exclusions = RulesUtil.getAttribute(PARAM_EXCLUSIONS, properties, this._exclusions);
    }

    public Boolean apply(List<? extends InputScopeObject> inputs, Map<String, String> attributes, IVariationsInitializationHandle handle) throws RuleException {
        String concept = RulesUtil.getAttribute(PARAM_CONCEPT, attributes, this._concept);
        long minCount = RulesUtil.getAttribute(PARAM_MINCOUNT, attributes, this._minCount);
        long maxCount = RulesUtil.getAttribute(PARAM_MAXCOUNT, attributes, this._maxCount);
        long count = 0L;
        for (InputScopeObject inputScopeObject : inputs) {
            AssociativeModelScopeIterator itr = new AssociativeModelScopeIterator(inputScopeObject, concept, this._inclusions, this._exclusions);
            while (itr.hasNext()) {
                itr.next();
                ++count;
            }
        }
        if (count >= minCount && count <= maxCount) {
            return true;
        }
        return false;
    }
}

