/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.smdrules.childrules;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.RuleException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.rule.IBooleanRule;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelNodeScopeObject;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelScopeIterator;
import com.ibm.aurora.rare.smdrules.rules.BaseRule;
import com.ibm.aurora.rare.smdrules.utils.RulesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ConceptsCount
extends BaseRule
implements IBooleanRule {
    static final String PARAM_CONCEPTS = "concepts";
    static final String PARAM_MAXCOUNT = "maxCount";
    static final String PARAM_MINCOUNT = "minCount";
    private String _concepts = "";
    private long _maxCount = Long.MAX_VALUE;
    private long _minCount = 0L;

    @Override
    public void setProperties(Map<String, String> properties) {
        super.setProperties(properties);
        this._concepts = RulesUtil.getAttribute(PARAM_CONCEPTS, properties, this._concepts);
        this._maxCount = RulesUtil.getAttribute(PARAM_MAXCOUNT, properties, this._maxCount);
        this._minCount = RulesUtil.getAttribute(PARAM_MINCOUNT, properties, this._minCount);
    }

    public Boolean apply(List<? extends InputScopeObject> inputs, Map<String, String> attributes, IVariationsInitializationHandle handle) throws RuleException {
        String concepts = RulesUtil.getAttribute(PARAM_CONCEPTS, attributes, this._concepts);
        long minCount = RulesUtil.getAttribute(PARAM_MINCOUNT, attributes, this._minCount);
        long maxCount = RulesUtil.getAttribute(PARAM_MAXCOUNT, attributes, this._maxCount);
        StringTokenizer tokens = new StringTokenizer(concepts, ",", false);
        ArrayList<AssociativeModelNodeScopeObject> scopes = new ArrayList<AssociativeModelNodeScopeObject>();
        int countConcepts = 0;
        for (InputScopeObject inputScopeObject : inputs) {
            AssociativeModelScopeIterator itr = new AssociativeModelScopeIterator(inputScopeObject, null, null, null);
            while (itr.hasNext()) {
                scopes.add((AssociativeModelNodeScopeObject)itr.next().getScope("model"));
            }
        }
        while (tokens.hasMoreTokens()) {
            String concept = tokens.nextToken();
            for (AssociativeModelNodeScopeObject scopeNode : scopes) {
                if (!scopeNode.isOfConcept(concept)) continue;
                ++countConcepts;
                break;
            }
            if ((long)countConcepts <= maxCount) continue;
            break;
        }
        return (long)countConcepts <= maxCount && (long)countConcepts >= minCount;
    }
}

