/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.smdrules.childrules;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.RuleException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.rule.IInputScopeObjectRule;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelNodeScopeObject;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelScopeIterator;
import com.ibm.aurora.rare.smdrules.input.InputScopeList;
import com.ibm.aurora.rare.smdrules.rules.BaseRule;
import com.ibm.aurora.rare.smdrules.utils.RulesUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DataBinding
extends BaseRule
implements IInputScopeObjectRule {
    static final String PARAM_CONCEPT = "concept";
    static final String PARAM_MIN_BINDINGS = "minBindings";
    static final String PARAM_MIN_NUMBER_INSTANCES = "minNumberInstances";
    static final String PARAM_MAX_NUMBER_INSTANCES = "maxNumberInstances";
    static final String PARAM_INCLUSIONS = "include";
    static final String PARAM_EXCLUSIONS = "exclude";
    static final String PARAM_FLATTEN_INPUT = "flattenInput";
    private String _concept = null;
    private int _minBindings = 1;
    private long _minNbrInstances = 0L;
    private long _maxNbrInstances = Long.MAX_VALUE;
    private String _inclusions = null;
    private String _exclusions = null;
    private Boolean _flattenInput = false;

    @Override
    public void setProperties(Map<String, String> properties) {
        super.setProperties(properties);
        this._concept = RulesUtil.getAttribute(PARAM_CONCEPT, properties, this._concept);
        this._minBindings = RulesUtil.getAttribute(PARAM_MIN_BINDINGS, properties, this._minBindings);
        this._minNbrInstances = RulesUtil.getAttribute(PARAM_MIN_NUMBER_INSTANCES, properties, this._minNbrInstances);
        this._maxNbrInstances = RulesUtil.getAttribute(PARAM_MAX_NUMBER_INSTANCES, properties, this._maxNbrInstances);
        this._inclusions = RulesUtil.getAttribute(PARAM_INCLUSIONS, properties, this._inclusions);
        this._exclusions = RulesUtil.getAttribute(PARAM_EXCLUSIONS, properties, this._exclusions);
        this._flattenInput = RulesUtil.getAttribute(PARAM_FLATTEN_INPUT, properties, Boolean.toString(this._flattenInput)).equals(Boolean.toString(true));
    }

    public List<? extends InputScopeObject> apply(List<? extends InputScopeObject> inputs, Map<String, String> attributes, IVariationsInitializationHandle handle) throws RuleException {
        String concept = RulesUtil.getAttribute(PARAM_CONCEPT, attributes, this._concept);
        int minBindings = RulesUtil.getAttribute(PARAM_MIN_BINDINGS, attributes, this._minBindings);
        long minNbrInstances = RulesUtil.getAttribute(PARAM_MIN_NUMBER_INSTANCES, attributes, this._minNbrInstances);
        long maxNbrInstances = RulesUtil.getAttribute(PARAM_MAX_NUMBER_INSTANCES, attributes, this._maxNbrInstances);
        ArrayList<InputScopeObject> output = new ArrayList<InputScopeObject>();
        for (InputScopeObject inputScopeObject : inputs) {
            this.addCurrentItemToMatchingScopeList(inputScopeObject, concept, minNbrInstances, maxNbrInstances, output);
        }
        if (output.size() < minBindings) {
            return Collections.emptyList();
        }
        return output;
    }

    private void addCurrentItemToMatchingScopeList(InputScopeObject input, String concept, long minNbrInstances, long maxNbrInstances, List<InputScopeObject> output) {
        AssociativeModelScopeIterator itr = new AssociativeModelScopeIterator(input, concept, this._inclusions, this._exclusions);
        while (itr.hasNext()) {
            InputScopeList node = itr.next();
            this.addMatchingScopeObject(minNbrInstances, maxNbrInstances, node, concept, output);
            if (!this._flattenInput.booleanValue()) continue;
            this.addCurrentItemToMatchingScopeList(node, concept, minNbrInstances, maxNbrInstances, output);
        }
    }

    private boolean addMatchingScopeObject(long minNbrInstances, long maxNbrInstances, InputScopeList obj, String concept, List<InputScopeObject> output) {
        AssociativeModelNodeScopeObject modelNode = this.getAssociativeModelNodeScopeObject(obj);
        if (modelNode.checkDistinctCount(minNbrInstances, maxNbrInstances)) {
            output.add(obj);
            return true;
        }
        if (!this._flattenInput.booleanValue()) {
            AssociativeModelScopeIterator itr = new AssociativeModelScopeIterator(obj, concept, this._inclusions, this._exclusions);
            while (itr.hasNext()) {
                InputScopeList childObj = itr.next();
                if (!this.addMatchingScopeObject(minNbrInstances, maxNbrInstances, childObj, concept, output)) continue;
                return true;
            }
        }
        return false;
    }
}

