/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.smdrules.childrules;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.RuleException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.rule.IInputScopeObjectRule;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelNodeScopeObject;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelScopeIterator;
import com.ibm.aurora.rare.smdrules.input.InputScopeList;
import com.ibm.aurora.rare.smdrules.rules.BaseRule;
import com.ibm.aurora.rare.smdrules.utils.RulesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NodesByDistinctCount
extends BaseRule
implements IInputScopeObjectRule {
    static final String PARAM_MIN = "minDistinctCount";
    static final String PARAM_MAX = "maxDistinctCount";
    private long _minDistinctCount = 0L;
    private long _maxDistinctCount = Long.MAX_VALUE;

    @Override
    public void setProperties(Map<String, String> properties) {
        super.setProperties(properties);
        this._minDistinctCount = RulesUtil.getAttribute(PARAM_MIN, properties, this._minDistinctCount);
        this._maxDistinctCount = RulesUtil.getAttribute(PARAM_MAX, properties, this._maxDistinctCount);
    }

    public List<? extends InputScopeObject> apply(List<? extends InputScopeObject> inputs, Map<String, String> attributes, IVariationsInitializationHandle handle) throws RuleException {
        long min = RulesUtil.getAttribute(PARAM_MIN, attributes, this._minDistinctCount);
        long max = RulesUtil.getAttribute(PARAM_MAX, attributes, this._maxDistinctCount);
        ArrayList<InputScopeList> output = new ArrayList<InputScopeList>();
        for (InputScopeObject inputScopeObject : inputs) {
            AssociativeModelScopeIterator itr = new AssociativeModelScopeIterator(inputScopeObject);
            while (itr.hasNext()) {
                InputScopeList node = itr.next();
                AssociativeModelNodeScopeObject modelNode = this.getAssociativeModelNodeScopeObject(node);
                if (!modelNode.checkDistinctCount(min, max)) continue;
                output.add(node);
            }
        }
        return output;
    }
}

