/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.smdrules.childrules;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.RuleException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.rule.INumericRule;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelNodeScopeObject;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelScopeIterator;
import com.ibm.aurora.rare.smdrules.rules.BaseRule;
import com.ibm.aurora.rare.smdrules.utils.RulesUtil;
import java.util.List;
import java.util.Map;

public class ScoreByMetricDefaultAggregation
extends BaseRule
implements INumericRule {
    static final String PARAM_AGGR = "aggregation";
    static final String PARAM_SCORE = "score";
    private String _aggregation = null;
    private long _score = 0L;

    @Override
    public void setProperties(Map<String, String> properties) {
        super.setProperties(properties);
        this._aggregation = RulesUtil.getAttribute(PARAM_AGGR, properties, this._aggregation);
        this._score = RulesUtil.getAttribute(PARAM_SCORE, properties, this._score);
    }

    public Number apply(List<? extends InputScopeObject> inputs, Map<String, String> attributes, IVariationsInitializationHandle handle) throws RuleException {
        String aggregation = RulesUtil.getAttribute(PARAM_AGGR, attributes, this._aggregation);
        if (aggregation == null) {
            return 0L;
        }
        long score = RulesUtil.getAttribute(PARAM_SCORE, attributes, this._score);
        for (InputScopeObject inputScopeObject : inputs) {
            AssociativeModelScopeIterator itr = new AssociativeModelScopeIterator(inputScopeObject, "metric");
            while (itr.hasNext()) {
                AssociativeModelNodeScopeObject obj = this.getAssociativeModelNodeScopeObject(itr.next());
                if (!aggregation.equals(obj.getDefaultAggregation())) continue;
                return score;
            }
        }
        return 0L;
    }
}

