/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.smdrules.childrules;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.RuleException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.rule.INumericRule;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelNodeScopeObject;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelScopeIterator;
import com.ibm.aurora.rare.smdrules.rules.BaseRule;
import com.ibm.aurora.rare.smdrules.utils.RulesUtil;
import java.util.List;
import java.util.Map;

public class ScoreByNodesDistinctCount
extends BaseRule
implements INumericRule {
    static final String PARAM_CONCEPT = "concept";
    static final String PARAM_MIN = "minDistinctCount";
    static final String PARAM_MAX = "maxDistinctCount";
    static final String PARAM_SCORE = "score";
    private long _minDistinctCount = 0L;
    private long _maxDistinctCount = Long.MAX_VALUE;
    private String _concept = null;
    private long _score = 0L;

    @Override
    public void setProperties(Map<String, String> properties) {
        super.setProperties(properties);
        this._minDistinctCount = RulesUtil.getAttribute(PARAM_MIN, properties, this._minDistinctCount);
        this._maxDistinctCount = RulesUtil.getAttribute(PARAM_MAX, properties, this._maxDistinctCount);
        this._score = RulesUtil.getAttribute(PARAM_SCORE, properties, this._score);
        this._concept = RulesUtil.getAttribute(PARAM_CONCEPT, properties, this._concept);
    }

    public Number apply(List<? extends InputScopeObject> inputs, Map<String, String> attributes, IVariationsInitializationHandle handle) throws RuleException {
        long minCount = RulesUtil.getAttribute(PARAM_MIN, attributes, this._minDistinctCount);
        long maxCount = RulesUtil.getAttribute(PARAM_MAX, attributes, this._maxDistinctCount);
        long score = RulesUtil.getAttribute(PARAM_SCORE, attributes, this._score);
        String concept = RulesUtil.getAttribute(PARAM_CONCEPT, attributes, this._concept);
        for (InputScopeObject inputScopeObject : inputs) {
            AssociativeModelScopeIterator itr = new AssociativeModelScopeIterator(inputScopeObject, concept);
            while (itr.hasNext()) {
                AssociativeModelNodeScopeObject node = this.getAssociativeModelNodeScopeObject(itr.next());
                long distinctCount = node.distinctCount();
                if (distinctCount < minCount || distinctCount > maxCount) continue;
                return score;
            }
        }
        return 0L;
    }
}

