/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.smdrules.childrules;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.RuleException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.rule.INumericRule;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelNodeScopeObject;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelScopeIterator;
import com.ibm.aurora.rare.smdrules.rules.BaseRule;
import com.ibm.aurora.rare.smdrules.utils.RulesUtil;
import java.util.List;
import java.util.Map;

public class ScoreByPropertyValue
extends BaseRule
implements INumericRule {
    static final String PARAM_PROPERTY_NAME = "propertyName";
    static final String PARAM_MIN = "min";
    static final String PARAM_MAX = "max";
    static final String PARAM_SCORE = "score";
    static final String PARAM_DATAITEM = "dataItem";
    private String _property_name = null;
    private long _min = 0L;
    private long _max = Long.MAX_VALUE;
    private double _score = 0.0;
    private boolean _data_item_property = false;

    @Override
    public void setProperties(Map<String, String> properties) {
        super.setProperties(properties);
        this._min = RulesUtil.getAttribute(PARAM_MIN, properties, this._min);
        this._max = RulesUtil.getAttribute(PARAM_MAX, properties, this._max);
        this._property_name = RulesUtil.getAttribute(PARAM_PROPERTY_NAME, properties, this._property_name);
        this._score = RulesUtil.getAttribute(PARAM_SCORE, properties, this._score);
        this._data_item_property = RulesUtil.getAttribute(PARAM_DATAITEM, properties, this._data_item_property);
    }

    public Number apply(List<? extends InputScopeObject> inputs, Map<String, String> attributes, IVariationsInitializationHandle handle) throws RuleException {
        long min = RulesUtil.getAttribute(PARAM_MIN, attributes, this._min);
        long max = RulesUtil.getAttribute(PARAM_MAX, attributes, this._max);
        double score = RulesUtil.getAttribute(PARAM_SCORE, attributes, this._score);
        boolean dataItemProperty = RulesUtil.getAttribute(PARAM_DATAITEM, attributes, this._data_item_property);
        double propVal = 0.0;
        for (InputScopeObject inputScopeObject : inputs) {
            AssociativeModelScopeIterator itr = new AssociativeModelScopeIterator(inputScopeObject);
            while (itr.hasNext()) {
                AssociativeModelNodeScopeObject node = this.getAssociativeModelNodeScopeObject(itr.next());
                if (node == null) continue;
                String propValue = null;
                propValue = dataItemProperty ? node.getDataItemProperty(this._property_name) : node.getProperty(this._property_name);
                if (propValue == null) continue;
                double val = 0.0;
                try {
                    val = Double.valueOf(propValue);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (!(val >= (double)min) || !(val <= (double)max)) continue;
                propVal += val;
            }
        }
        if (propVal != 0.0) {
            if (score > 0.0) {
                return score;
            }
            return propVal;
        }
        return 0.0;
    }
}

